/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.procedures.rule;

import java.util.List;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroup;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupBean;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupDetailBean;
import org.kuali.kra.iacuc.procedures.rule.AddProtocolStudyGroupEvent;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class AddProtocolStudyGroupRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<AddProtocolStudyGroupEvent> {
    private static final String PROCEDURE_BEAN_PATH = "iacucProtocolStudyGroupBeans";

    public boolean processRules(AddProtocolStudyGroupEvent event) {
        return this.processAddStudyGroupBusinessRules(event);
    }

    private boolean processAddStudyGroupBusinessRules(AddProtocolStudyGroupEvent event) {
        boolean rulePassed = true;
        return rulePassed &= this.isStudyGroupValid(event);
    }

    private boolean isStudyGroupValid(AddProtocolStudyGroupEvent event) {
        boolean studyGroupValid = true;
        IacucProtocolStudyGroupBean selectedIacucProtocolStudyGroupBean = event.getProcedureBean();
        List protocolSpeciesAndGroups = selectedIacucProtocolStudyGroupBean.getProtocolSpeciesAndGroups();
        List protocolPersonsResponsible = selectedIacucProtocolStudyGroupBean.getProtocolPersonsResponsible();
        if (ObjectUtils.isNull((Object)protocolSpeciesAndGroups) || ObjectUtils.isNull((Object)protocolPersonsResponsible)) {
            GlobalVariables.getMessageMap().putError(this.getErrorPath(event), "error.iacuc.validation.studyGroup.valid", new String[0]);
            studyGroupValid = false;
        }
        return studyGroupValid;
    }

    private boolean isDuplicateStudyGroup(AddProtocolStudyGroupEvent event) {
        boolean duplicateStudyGroup = false;
        IacucProtocolStudyGroupBean procedureBean = event.getProcedureBean();
        List protocolSpeciesAndGroups = procedureBean.getProtocolSpeciesAndGroups();
        for (String iacucProtocolSpeciesId : protocolSpeciesAndGroups) {
            Integer newProtocolSpeciesId = Integer.parseInt(iacucProtocolSpeciesId);
            for (IacucProtocolStudyGroupDetailBean detailBean : procedureBean.getIacucProtocolStudyGroupDetailBeans()) {
                for (IacucProtocolStudyGroup studyGroup : detailBean.getIacucProtocolStudyGroups()) {
                    if (!studyGroup.getIacucProtocolSpeciesId().equals(newProtocolSpeciesId)) continue;
                    GlobalVariables.getMessageMap().putError(this.getErrorPath(event), "error.iacuc.validation.duplicate.studyGroup", new String[0]);
                    duplicateStudyGroup = true;
                }
            }
        }
        return duplicateStudyGroup;
    }

    private String getErrorPath(AddProtocolStudyGroupEvent event) {
        StringBuffer errorPath = new StringBuffer();
        errorPath.append(PROCEDURE_BEAN_PATH);
        errorPath.append("[");
        errorPath.append(event.getProcedureBeanIndex());
        errorPath.append("]");
        return errorPath.toString();
    }
}

