/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.questionnaire;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolAction;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.questionnaire.IacucProtocolModuleQuestionnaireBean;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.questionnaire.SaveProtocolQuestionnaireEvent;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.ModuleQuestionnaireBean;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.questionnaire.answer.SaveQuestionnaireAnswerEvent;
import org.kuali.kra.questionnaire.answer.SaveQuestionnaireAnswerRule;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;

public class IacucProtocolQuestionnaireAction
extends IacucProtocolAction {
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String SUBMISSION_NUMBER = "submissionNumber";
    private static final String SUBMISSION_QUESTIONNAIRE = "submissionQuestionnaire";
    private static final String SUFFIX_T = "T";

    public void preSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.preSave(mapping, form, request, response);
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        Document document = protocolForm.getDocument();
        List answerHeaders = protocolForm.getQuestionnaireHelper().getAnswerHeaders();
        if (this.applyRules((KualiDocumentEvent)new SaveQuestionnaireAnswerEvent(document, answerHeaders)) && this.applyRules((KualiDocumentEvent)new SaveProtocolQuestionnaireEvent(document, answerHeaders))) {
            protocolForm.getQuestionnaireHelper().preSave();
            this.getBusinessObjectService().save(answerHeaders);
        }
    }

    public ActionForward updateAnswerToNewVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((IacucProtocolForm)form).getQuestionnaireHelper().updateQuestionnaireAnswer(this.getLineToDelete(request));
        this.getBusinessObjectService().save((PersistableBusinessObject)((IacucProtocolForm)form).getQuestionnaireHelper().getAnswerHeaders().get(this.getLineToDelete(request)));
        return mapping.findForward("basic");
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.refresh(mapping, form, request, response);
        if (request.getParameter("refreshCaller") != null && request.getParameter("refreshCaller").toString().equals("kualiLookupable")) {
            for (Object obj : request.getParameterMap().keySet()) {
                if (StringUtils.indexOf((String)((String)obj), (String)"questionnaireHelper.answerHeaders[") != 0) continue;
                ((IacucProtocolForm)form).getQuestionnaireHelper().updateChildIndicator(Integer.parseInt(StringUtils.substringBetween((String)((String)obj), (String)"questionnaireHelper.answerHeaders[", (String)"].answers[")));
            }
        }
        if (StringUtils.isBlank((String)((IacucProtocolForm)form).getDocId())) {
            forward = mapping.findForward(SUBMISSION_QUESTIONNAIRE);
            ((IacucProtocolForm)form).getQuestionnaireHelper().resetHeaderLabels();
        }
        return forward;
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.reload(mapping, form, request, response);
        ((IacucProtocolForm)form).getQuestionnaireHelper().prepareView();
        ((IacucProtocolForm)form).getQuestionnaireHelper().populateAnswers();
        ((IacucProtocolForm)form).getQuestionnaireHelper().setQuestionnaireActiveStatuses();
        return actionForward;
    }

    protected ActionForward saveOnClose(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List answerHeaders;
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        Document document = protocolForm.getDocument();
        if (this.applyRules((KualiDocumentEvent)new SaveQuestionnaireAnswerEvent(document, answerHeaders = protocolForm.getQuestionnaireHelper().getAnswerHeaders()))) {
            protocolForm.getQuestionnaireHelper().preSave();
            this.getBusinessObjectService().save(answerHeaders);
            forward = super.saveOnClose(mapping, form, request, response);
        }
        return forward;
    }

    public ActionForward printQuestionnaireAnswer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        int answerHeaderIndex = this.getSelectedLine(request);
        reportParameters.put("questionnaireId", ((AnswerHeader)((IacucProtocolForm)form).getQuestionnaireHelper().getAnswerHeaders().get(answerHeaderIndex)).getQuestionnaire().getQuestionnaireIdAsInteger());
        reportParameters.put("template", ((AnswerHeader)((IacucProtocolForm)form).getQuestionnaireHelper().getAnswerHeaders().get(answerHeaderIndex)).getQuestionnaire().getTemplate());
        AttachmentDataSource dataStream = this.getQuestionnairePrintingService().printQuestionnaireAnswer((KraPersistableBusinessObjectBase)protocolForm.getProtocolDocument().getProtocol(), reportParameters);
        if (dataStream.getContent() != null) {
            this.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    public ActionForward summaryQuestionnairePop(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String protocolNumber;
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        String sequenceNumber = request.getParameter(SEQUENCE_NUMBER);
        IacucProtocolModuleQuestionnaireBean moduleQuestionnaireBean = new IacucProtocolModuleQuestionnaireBean("9", protocolNumber, (protocolNumber = request.getParameter(PROTOCOL_NUMBER)).contains("A") || protocolNumber.contains("R") ? "1" : "0", sequenceNumber, true);
        protocolForm.getQuestionnaireHelper().setAnswerHeaders(this.getQuestionnaireAnswerService().getQuestionnaireAnswer((ModuleQuestionnaireBean)moduleQuestionnaireBean));
        protocolForm.getQuestionnaireHelper().setAnswerHeaders(this.getAnsweredQuestionnaire(protocolForm.getQuestionnaireHelper().getAnswerHeaders()));
        ActionForward forward = mapping.findForward("viewQuestionnaire");
        protocolForm.getQuestionnaireHelper().resetHeaderLabels();
        protocolForm.getQuestionnaireHelper().setQuestionnaireActiveStatuses();
        return forward;
    }

    public ActionForward summaryQuestionnaireAjax(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        String sequenceNumber = request.getParameter(SEQUENCE_NUMBER);
        String protocolNumber = request.getParameter(PROTOCOL_NUMBER);
        HashMap<String, String> keyValues = new HashMap<String, String>();
        keyValues.put(PROTOCOL_NUMBER, protocolNumber);
        keyValues.put(SEQUENCE_NUMBER, sequenceNumber);
        IacucProtocol protocol = (IacucProtocol)((List)this.getBusinessObjectService().findMatching(IacucProtocol.class, keyValues)).get(0);
        String subModuleCode = "0";
        if (protocol.isRenewal()) {
            subModuleCode = "1";
            if (protocol.isRenewalWithoutAmendment()) {
                subModuleCode = "3";
            }
        }
        if (protocol.isAmendment()) {
            subModuleCode = "4";
        }
        IacucProtocolModuleQuestionnaireBean moduleQuestionnaireBean = new IacucProtocolModuleQuestionnaireBean("9", protocolNumber, subModuleCode, sequenceNumber, true);
        protocolForm.getQuestionnaireHelper().setAnswerHeaders(this.getQuestionnaireAnswerService().getQuestionnaireAnswer((ModuleQuestionnaireBean)moduleQuestionnaireBean));
        if (protocol.isAmendment() || protocol.isRenewal()) {
            moduleQuestionnaireBean.setModuleSubItemCode("0");
            List answerHeaders = this.getQuestionnaireAnswerService().getQuestionnaireAnswer((ModuleQuestionnaireBean)moduleQuestionnaireBean);
            if (!answerHeaders.isEmpty()) {
                protocolForm.getQuestionnaireHelper().getAnswerHeaders().addAll(answerHeaders);
            }
        }
        protocolForm.getQuestionnaireHelper().setAnswerHeaders(this.getAnsweredQuestionnaire(protocolForm.getQuestionnaireHelper().getAnswerHeaders()));
        ActionForward forward = mapping.findForward("ajaxQuestionnaire");
        protocolForm.getQuestionnaireHelper().resetHeaderLabels();
        protocolForm.getQuestionnaireHelper().setQuestionnaireActiveStatuses();
        return forward;
    }

    private List<AnswerHeader> getAnsweredQuestionnaire(List<AnswerHeader> answerHeaders) {
        ArrayList<AnswerHeader> savedHeaders = new ArrayList<AnswerHeader>();
        for (AnswerHeader answerHeader : answerHeaders) {
            if (answerHeader.getAnswerHeaderId() == null) continue;
            savedHeaders.add(answerHeader);
        }
        return savedHeaders;
    }

    public ActionForward saveSubmissionQuestionnaire(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SaveQuestionnaireAnswerRule rule = new SaveQuestionnaireAnswerRule();
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        List answerHeaders = protocolForm.getQuestionnaireHelper().getAnswerHeaders();
        if (rule.processRules(new SaveQuestionnaireAnswerEvent(null, answerHeaders))) {
            protocolForm.getQuestionnaireHelper().preSave();
            this.getBusinessObjectService().save(answerHeaders);
        }
        protocolForm.getQuestionnaireHelper().resetHeaderLabels();
        return mapping.findForward(SUBMISSION_QUESTIONNAIRE);
    }

    protected QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return (QuestionnaireAnswerService)KraServiceLocator.getService(QuestionnaireAnswerService.class);
    }
}

