/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.rules;

import java.util.HashMap;
import org.kuali.kra.bo.PersonTraining;
import org.kuali.kra.iacuc.IacucPersonTraining;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.KraMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class IacucPersonTrainingMaintenanceDocumentRule
extends KraMaintenanceDocumentRuleBase {
    private static final String PERSON_TRAINING_FIELD_NAME = "personTrainingId";
    private transient BusinessObjectService businessObjectService;

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkIacucPersonTraining(document);
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkIacucPersonTraining(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkIacucPersonTraining(document);
    }

    public boolean isDocumentValidForSave(MaintenanceDocument document) {
        return this.checkIacucPersonTraining(document);
    }

    private boolean checkIacucPersonTraining(MaintenanceDocument document) {
        boolean isValid = true;
        IacucPersonTraining newIacucPersonTraining = (IacucPersonTraining)document.getNewMaintainableObject().getDataObject();
        return isValid &= this.isPersonTrainingValid(newIacucPersonTraining);
    }

    private boolean isPersonTrainingValid(IacucPersonTraining newIacucPersonTraining) {
        boolean isValid = true;
        String iacucTrainingPersonId = newIacucPersonTraining.getPersonId();
        Integer personTrainingId = newIacucPersonTraining.getPersonTrainingId();
        if (ObjectUtils.isNotNull((Object)personTrainingId)) {
            HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
            fieldValues.put(PERSON_TRAINING_FIELD_NAME, personTrainingId);
            PersonTraining personTraining = (PersonTraining)this.getBusinessObjectService().findByPrimaryKey(PersonTraining.class, fieldValues);
            if (ObjectUtils.isNotNull((Object)personTraining)) {
                String trainingPersonId = personTraining.getPersonId();
                if (!trainingPersonId.equals(iacucTrainingPersonId)) {
                    isValid = false;
                    this.putFieldError(PERSON_TRAINING_FIELD_NAME, "error.iacuc.validation.mismatch.person.training");
                }
            } else {
                isValid = false;
                this.putFieldError(PERSON_TRAINING_FIELD_NAME, "error.iacuc.validation.invalid.person.training");
            }
        }
        return isValid;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

