/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.species;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.species.IacucProtocolSpecies;
import org.kuali.kra.iacuc.species.IacucProtocolSpeciesService;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.ObjectUtils;

public class IacucProtocolSpeciesServiceImpl
implements IacucProtocolSpeciesService {
    private SequenceAccessorService sequenceAccessorService;
    private static final String PROTOCOL_SPECIES_SEQUENCE_ID = "SEQ_IACUC_PROTOCOL_SPECIES_ID";
    private static final String REFERENCE_SPECIES = "iacucSpecies";
    private static final String REFERENCE_SPECIES_COUNT_TYPE = "iacucSpeciesCountType";
    private static final String REFERENCE_SPECIES_PAIN_CATEGORY = "iacucPainCategory";

    public void addProtocolSpecies(IacucProtocol protocol, IacucProtocolSpecies protocolSpecies) {
        protocol.getIacucProtocolSpeciesList().add(this.getNewProtocolSpecies(protocol, protocolSpecies));
    }

    public IacucProtocolSpecies getNewProtocolSpecies(IacucProtocol protocol, IacucProtocolSpecies protocolSpecies) {
        protocolSpecies.setIacucProtocolSpeciesId(this.getNextProtocolSpeciesSequence());
        protocolSpecies.setSpeciesId(this.getNextProtocolSpeciesId(protocol));
        protocolSpecies.setProtocolNumber(protocol.getProtocolNumber());
        protocolSpecies.setSequenceNumber(protocol.getSequenceNumber());
        protocolSpecies.setProtocolId(protocol.getProtocolId());
        this.refreshSpeciesReferenceObjects(protocolSpecies);
        return protocolSpecies;
    }

    public HashMap<Integer, Integer> getNewProtocolSpeciesMap(IacucProtocol protocol) {
        List protocolSpeciesList = protocol.getIacucProtocolSpeciesList();
        HashMap<Integer, Integer> speciesIdMapping = new HashMap<Integer, Integer>();
        for (IacucProtocolSpecies protocolSpecies : protocolSpeciesList) {
            if (ObjectUtils.isNull((Object)protocolSpecies.getIacucProtocolSpeciesId())) {
                protocolSpecies.setIacucProtocolSpeciesId(this.getNextProtocolSpeciesSequence());
            }
            Integer oldProtocolSpeciesId = protocolSpecies.getOldProtocolSpeciesId() == null ? protocolSpecies.getIacucProtocolSpeciesId() : protocolSpecies.getOldProtocolSpeciesId();
            speciesIdMapping.put(oldProtocolSpeciesId, protocolSpecies.getIacucProtocolSpeciesId());
        }
        return speciesIdMapping;
    }

    private void refreshSpeciesReferenceObjects(IacucProtocolSpecies protocolSpecies) {
        protocolSpecies.refreshReferenceObject(REFERENCE_SPECIES);
        protocolSpecies.refreshReferenceObject(REFERENCE_SPECIES_COUNT_TYPE);
        protocolSpecies.refreshReferenceObject(REFERENCE_SPECIES_PAIN_CATEGORY);
    }

    private Integer getNextProtocolSpeciesSequence() {
        return this.getSequenceAccessorService().getNextAvailableSequenceNumber(PROTOCOL_SPECIES_SEQUENCE_ID).intValue();
    }

    private Integer getNextProtocolSpeciesId(IacucProtocol protocol) {
        int totalSpecies = protocol.getIacucProtocolSpeciesList().size();
        Integer nextSpeciesId = 1;
        if (totalSpecies > 0) {
            List sortedProtocolSpecies = this.getSortedSpecies(protocol);
            IacucProtocolSpecies protocolSpecies = (IacucProtocolSpecies)sortedProtocolSpecies.get(totalSpecies - 1);
            nextSpeciesId = protocolSpecies.getSpeciesId() + 1;
        }
        return nextSpeciesId;
    }

    public List<IacucProtocolSpecies> getSortedSpecies(IacucProtocol protocol) {
        ArrayList<IacucProtocolSpecies> protocolSpeciesList = new ArrayList<IacucProtocolSpecies>();
        for (IacucProtocolSpecies species : protocol.getIacucProtocolSpeciesList()) {
            protocolSpeciesList.add((IacucProtocolSpecies)ObjectUtils.deepCopy((Serializable)species));
        }
        Collections.sort(protocolSpeciesList, new /* Unavailable Anonymous Inner Class!! */);
        return protocolSpeciesList;
    }

    public SequenceAccessorService getSequenceAccessorService() {
        return this.sequenceAccessorService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }
}

