/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.species.exception;

import java.io.Serializable;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.auth.IacucProtocolTask;
import org.kuali.kra.iacuc.species.exception.IacucProtocolException;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocolExceptionHelper
implements Serializable {
    private static final long serialVersionUID = -2090976351003068814L;
    protected IacucProtocolForm form;
    protected IacucProtocolException newIacucProtocolException;

    public IacucProtocolExceptionHelper(IacucProtocolForm form) {
        this.setForm(form);
        this.setNewIacucProtocolException(new IacucProtocolException());
    }

    public void prepareView() {
    }

    protected IacucProtocol getProtocol() {
        IacucProtocolDocument document = this.form.getIacucProtocolDocument();
        if (document == null || document.getProtocol() == null) {
            throw new IllegalArgumentException("invalid (null) Iacuc ProtocolDocument in ProtocolForm");
        }
        return document.getIacucProtocol();
    }

    public IacucProtocolForm getForm() {
        return this.form;
    }

    public void setForm(IacucProtocolForm form) {
        this.form = form;
    }

    public boolean isModifyProtocolException() {
        IacucProtocolTask task = new IacucProtocolTask("modifyIacucProtocolException", (IacucProtocol)this.form.getProtocolDocument().getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), (Task)task);
    }

    public IacucProtocolException getNewIacucProtocolException() {
        return this.newIacucProtocolException;
    }

    public void setNewIacucProtocolException(IacucProtocolException newIacucProtocolException) {
        this.newIacucProtocolException = newIacucProtocolException;
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }
}

