/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.summary;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.iacuc.threers.IacucAlternateSearch;
import org.kuali.kra.iacuc.threers.IacucProtocolAlternateSearchDatabase;

public class IacucAlternateSearchSummary
implements Serializable {
    private static final long serialVersionUID = -6996989015653936693L;
    private Integer iacucAltSearchId;
    private String searchDate;
    private List<String> databases = new ArrayList();
    private String yearsSearched;
    private String keywords;
    private String comments;
    private boolean searchDateChanged;
    private boolean databasesChanged;
    private boolean yearsSearchedChanged;
    private boolean keywordsChanged;
    private boolean commentsChanged;
    private SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");

    public IacucAlternateSearchSummary(IacucAlternateSearch alternateSearch) {
        this.iacucAltSearchId = alternateSearch.getIacucAltSearchId();
        this.searchDate = this.df.format(alternateSearch.getSearchDate());
        for (IacucProtocolAlternateSearchDatabase db : alternateSearch.getDatabases()) {
            this.databases.add(db.getAlternateSearchDatabaseName());
        }
        this.yearsSearched = alternateSearch.getYearsSearched();
        this.keywords = alternateSearch.getKeywords();
        this.comments = alternateSearch.getComments();
    }

    public Integer getIacucAltSearchId() {
        return this.iacucAltSearchId;
    }

    public void setIacucAltSearchId(Integer iacucAltSearchId) {
        this.iacucAltSearchId = iacucAltSearchId;
    }

    public String getSearchDate() {
        return this.searchDate;
    }

    public void setSearchDate(String searchDate) {
        this.searchDate = searchDate;
    }

    public String getYearsSearched() {
        return this.yearsSearched;
    }

    public void setYearsSearched(String yearsSearched) {
        this.yearsSearched = yearsSearched;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public boolean isSearchDateChanged() {
        return this.searchDateChanged;
    }

    public void setSearchDateChanged(boolean searchDateChanged) {
        this.searchDateChanged = searchDateChanged;
    }

    public boolean isDatabasesChanged() {
        return this.databasesChanged;
    }

    public void setDatabasesChanged(boolean databasesChanged) {
        this.databasesChanged = databasesChanged;
    }

    public boolean isYearsSearchedChanged() {
        return this.yearsSearchedChanged;
    }

    public void setYearsSearchedChanged(boolean yearsSearchedChanged) {
        this.yearsSearchedChanged = yearsSearchedChanged;
    }

    public boolean isKeywordsChanged() {
        return this.keywordsChanged;
    }

    public void setKeywordsChanged(boolean keywordsChanged) {
        this.keywordsChanged = keywordsChanged;
    }

    public boolean isCommentsChanged() {
        return this.commentsChanged;
    }

    public void setCommentsChanged(boolean commentsChanged) {
        this.commentsChanged = commentsChanged;
    }

    public String getDatabaseList() {
        StringBuffer dbSearches = new StringBuffer();
        for (String db : this.databases) {
            if (dbSearches.length() > 0) {
                dbSearches.append(", ");
            }
            dbSearches.append(db);
        }
        return dbSearches.toString();
    }
}

