/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.summary;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupLocation;
import org.kuali.kra.iacuc.summary.IacucProcedureSummary;

public class IacucProcedureLocationSummary
implements Serializable {
    private static final long serialVersionUID = -2115905931286970929L;
    private Integer id;
    private String type;
    private String name;
    private String room;
    private String description;
    private boolean typeChanged;
    private boolean nameChanged;
    private boolean roomChanged;
    private boolean descriptionChanged;

    public IacucProcedureLocationSummary(IacucProtocolStudyGroupLocation location) {
        this.id = location.getIacucProtocolStudyGroupLocationId();
        this.type = location.getIacucLocationType().getLocation();
        this.name = location.getIacucLocationName().getLocationName();
        this.room = location.getLocationRoom();
        this.description = location.getStudyGroupLocationDescription();
        this.typeChanged = false;
        this.nameChanged = false;
        this.roomChanged = false;
        this.descriptionChanged = false;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isTypeChanged() {
        return this.typeChanged;
    }

    public void setTypeChanged(boolean typeChanged) {
        this.typeChanged = typeChanged;
    }

    public boolean isNameChanged() {
        return this.nameChanged;
    }

    public void setNameChanged(boolean nameChanged) {
        this.nameChanged = nameChanged;
    }

    public boolean isRoomChanged() {
        return this.roomChanged;
    }

    public void setRoomChanged(boolean roomChanged) {
        this.roomChanged = roomChanged;
    }

    public boolean isDescriptionChanged() {
        return this.descriptionChanged;
    }

    public void setDescriptionChanged(boolean descriptionChanged) {
        this.descriptionChanged = descriptionChanged;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void compare(IacucProcedureSummary other) {
        IacucProcedureLocationSummary otherSummary;
        IacucProcedureLocationSummary iacucProcedureLocationSummary = otherSummary = other == null ? null : other.findProcedureLocationSummary(this.id);
        if (otherSummary == null) {
            this.nameChanged = true;
            this.roomChanged = true;
            this.descriptionChanged = true;
        } else {
            this.nameChanged = !StringUtils.equals((String)this.name, (String)otherSummary.name);
            this.roomChanged = !StringUtils.equals((String)this.room, (String)otherSummary.room);
            this.descriptionChanged = !StringUtils.equals((String)this.description, (String)otherSummary.description);
        }
    }
}

