/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.summary;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.iacuc.procedures.IacucProcedure;
import org.kuali.kra.iacuc.procedures.IacucProcedureCategory;
import org.kuali.kra.iacuc.procedures.IacucProcedurePersonResponsible;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyCustomData;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroup;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupLocation;
import org.kuali.kra.iacuc.summary.IacucProcedureCustomDataSummary;
import org.kuali.kra.iacuc.summary.IacucProcedureLocationSummary;
import org.kuali.kra.iacuc.summary.IacucProcedurePersonSummary;
import org.kuali.kra.iacuc.summary.IacucProtocolSummary;

public class IacucProcedureSummary
implements Serializable {
    private static final long serialVersionUID = 4139399374995243748L;
    private Integer procedureCode;
    private String species;
    private String speciesStrain;
    private String procedureCategory;
    private String painCategory;
    private List<IacucProcedureLocationSummary> locationSummaries;
    private List<IacucProcedurePersonSummary> personSummaries;
    private List<IacucProcedureCustomDataSummary> customDataSummaries;
    private int count;
    private boolean procedureCategoryChanged;
    private boolean speciesChanged;
    private boolean speciesStrainChanged;
    private boolean painCategoryChanged;
    private boolean countChanged;

    public IacucProcedureSummary(IacucProtocolStudyGroup studyGroup, IacucProcedureCategory iacucProcedureCategory, IacucProcedure iacucProcedure) {
        this.procedureCode = iacucProcedure.getProcedureCode();
        this.species = studyGroup.getIacucProtocolSpecies() == null ? "None" : studyGroup.getIacucProtocolSpecies().getSpeciesName();
        this.speciesStrain = studyGroup.getIacucProtocolSpecies() == null ? "None" : studyGroup.getIacucProtocolSpecies().getStrain();
        this.painCategory = studyGroup.getIacucPainCategory() == null ? "None" : studyGroup.getIacucPainCategory().getPainCategory();
        this.procedureCategory = iacucProcedureCategory.getProcedureCategory() + " - " + iacucProcedure.getProcedureDescription();
        this.personSummaries = new ArrayList();
        for (IacucProcedurePersonResponsible person : studyGroup.getIacucProcedurePersonsResponsible()) {
            this.personSummaries.add(new IacucProcedurePersonSummary(person));
        }
        this.locationSummaries = new ArrayList();
        for (IacucProtocolStudyGroupLocation location : studyGroup.getIacucProtocolStudyGroupLocations()) {
            this.locationSummaries.add(new IacucProcedureLocationSummary(location));
        }
        this.customDataSummaries = new ArrayList();
        for (IacucProtocolStudyCustomData customDataItem : studyGroup.getIacucProtocolStudyCustomDataList()) {
            this.customDataSummaries.add(new IacucProcedureCustomDataSummary(customDataItem));
        }
        this.count = studyGroup.getCount();
        this.procedureCategoryChanged = false;
        this.speciesChanged = false;
        this.speciesStrainChanged = false;
        this.painCategoryChanged = false;
        this.countChanged = false;
    }

    public boolean isProcedureCategoryChanged() {
        return this.procedureCategoryChanged;
    }

    public void setProcedureCategoryChanged(boolean procedureCategoryChanged) {
        this.procedureCategoryChanged = procedureCategoryChanged;
    }

    public Integer getProcedureCode() {
        return this.procedureCode;
    }

    public void setProcedureCode(Integer procedureCode) {
        this.procedureCode = procedureCode;
    }

    public String getProcedureCategory() {
        return this.procedureCategory;
    }

    public void setProcedureCategory(String procedureCategory) {
        this.procedureCategory = procedureCategory;
    }

    public String getSpecies() {
        return this.species;
    }

    public void setSpecies(String species) {
        this.species = species;
    }

    public String getSpeciesStrain() {
        return this.speciesStrain;
    }

    public void setSpeciesStrain(String speciesStrain) {
        this.speciesStrain = speciesStrain;
    }

    public boolean isSpeciesChanged() {
        return this.speciesChanged;
    }

    public void setSpeciesChanged(boolean speciesChanged) {
        this.speciesChanged = speciesChanged;
    }

    public List<IacucProcedureLocationSummary> getLocations() {
        return this.locationSummaries;
    }

    public void setLocations(List<IacucProcedureLocationSummary> locations) {
        this.locationSummaries = locations;
    }

    public String getPainCategory() {
        return this.painCategory;
    }

    public void setPainCategory(String painCategory) {
        this.painCategory = painCategory;
    }

    public boolean isSpeciesStrainChanged() {
        return this.speciesStrainChanged;
    }

    public void setSpeciesStrainChanged(boolean speciesStrainChanged) {
        this.speciesStrainChanged = speciesStrainChanged;
    }

    public boolean isPainCategoryChanged() {
        return this.painCategoryChanged;
    }

    public void setPainCategoryChanged(boolean painCategoryChanged) {
        this.painCategoryChanged = painCategoryChanged;
    }

    public List<IacucProcedurePersonSummary> getPersonSummaries() {
        return this.personSummaries;
    }

    public void setPersonSummaries(List<IacucProcedurePersonSummary> personsResponsible) {
        this.personSummaries = personsResponsible;
    }

    public String getPersonnelList() {
        String results = "";
        if (this.personSummaries != null) {
            for (IacucProcedurePersonSummary person : this.personSummaries) {
                if (results.length() > 0) {
                    results = results + "<br/>";
                }
                results = results + person.getPersonName();
            }
        }
        return results;
    }

    public List<IacucProcedureLocationSummary> getLocationSummaries() {
        return this.locationSummaries;
    }

    public void setLocationSummaries(List<IacucProcedureLocationSummary> locationSummaries) {
        this.locationSummaries = locationSummaries;
    }

    public List<IacucProcedureCustomDataSummary> getCustomDataSummaries() {
        return this.customDataSummaries;
    }

    public void setCustomDataSummaries(List<IacucProcedureCustomDataSummary> customDataSummaries) {
        this.customDataSummaries = customDataSummaries;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean isCountChanged() {
        return this.countChanged;
    }

    public void setCountChanged(boolean countChanged) {
        this.countChanged = countChanged;
    }

    public void compare(IacucProtocolSummary other) {
        IacucProcedureSummary otherSummary;
        IacucProcedureSummary iacucProcedureSummary = otherSummary = other == null ? null : other.findProcedureSummary(this.procedureCode);
        if (otherSummary == null) {
            this.procedureCategoryChanged = true;
            this.speciesChanged = true;
            this.speciesStrainChanged = false;
            this.painCategoryChanged = false;
        } else {
            this.procedureCategoryChanged = !this.procedureCategory.equals(otherSummary.procedureCategory);
            this.speciesChanged = !StringUtils.equals((String)this.species, (String)otherSummary.species);
            this.speciesStrainChanged = !StringUtils.equals((String)this.speciesStrain, (String)otherSummary.speciesStrain);
            this.painCategoryChanged = !StringUtils.equals((String)this.painCategory, (String)otherSummary.painCategory);
        }
        this.compareProcedureCustomDataSummaries(otherSummary);
        this.compareProcedurePersonSummaries(otherSummary);
        this.compareProcedureLocationSummaries(otherSummary);
    }

    public void compareProcedureCustomDataSummaries(IacucProcedureSummary other) {
        for (IacucProcedureCustomDataSummary mySummary : this.customDataSummaries) {
            mySummary.compare(other);
        }
    }

    public IacucProcedureCustomDataSummary findProcedureCustomDataSummary(Integer id) {
        for (IacucProcedureCustomDataSummary customDataSummary : this.customDataSummaries) {
            if (!customDataSummary.getId().equals(id)) continue;
            return customDataSummary;
        }
        return null;
    }

    public void compareProcedureLocationSummaries(IacucProcedureSummary other) {
        for (IacucProcedureLocationSummary mySummary : this.locationSummaries) {
            mySummary.compare(other);
        }
    }

    public IacucProcedureLocationSummary findProcedureLocationSummary(Integer id) {
        for (IacucProcedureLocationSummary locationSummary : this.locationSummaries) {
            if (!locationSummary.getId().equals(id)) continue;
            return locationSummary;
        }
        return null;
    }

    public void compareProcedurePersonSummaries(IacucProcedureSummary other) {
        for (IacucProcedurePersonSummary mySummary : this.personSummaries) {
            mySummary.compare(other);
        }
    }

    public IacucProcedurePersonSummary findProcedurePersonSummary(String id) {
        for (IacucProcedurePersonSummary personSummary : this.personSummaries) {
            if (!personSummary.getPersonId().equals(id)) continue;
            return personSummary;
        }
        return null;
    }

    public boolean isPersonnelListChanged() {
        for (IacucProcedurePersonSummary personSummary : this.personSummaries) {
            if (!personSummary.isPersonNameChanged()) continue;
            return true;
        }
        return false;
    }
}

