/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import java.util.HashMap;
import java.util.Map;
import org.kuali.kra.SequenceAssociate;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.bo.Contactable;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.InstitutionalProposalAssociate;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class InstitutionalProposalContact
extends InstitutionalProposalAssociate
implements SequenceAssociate<InstitutionalProposal> {
    private static final long serialVersionUID = 7866050768005705153L;
    private static final String ROLODEX_ID_FIELD_NAME = "rolodexId";
    private static final String PERSON_ID_FIELD_NAME = "personId";
    protected String personId;
    protected Integer rolodexId;
    protected String roleCode;
    private Long institutionalProposalContactId;
    private ContactRole contactRole;
    private String fullName;
    private KcPerson person;
    private NonOrganizationalRolodex rolodex;
    private transient KcPersonService kcPersonService;

    public InstitutionalProposalContact() {
    }

    public InstitutionalProposalContact(NonOrganizationalRolodex rolodex, ContactRole contactRole) {
        this();
        this.setRolodex(rolodex);
        this.setContactRole(contactRole);
    }

    public InstitutionalProposalContact(KcPerson person, ContactRole role) {
        this();
        this.setPerson(person);
        this.setContactRole(role);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof InstitutionalProposalContact)) {
            return false;
        }
        InstitutionalProposalContact other = (InstitutionalProposalContact)obj;
        if (this.getContactRole() == null ? other.getContactRole() != null : !this.getContactRole().equals(other.getContactRole())) {
            return false;
        }
        if (this.getContact() == null) {
            if (other.getContact() != null) {
                return false;
            }
        } else if (this.getContact().getFullName() == null) {
            if (other.getContact().getFullName() != null) {
                return false;
            }
        } else {
            return this.getContact().getFullName().equalsIgnoreCase(other.getContact().getFullName());
        }
        return true;
    }

    public Long getInstitutionalProposalContactId() {
        return this.institutionalProposalContactId;
    }

    public Contactable getContact() {
        Contactable contact = (Contactable)(this.person != null ? this.person : (this.rolodex != null ? this.rolodex : null));
        if (contact == null) {
            if (this.personId != null) {
                this.refreshPerson();
                contact = this.person;
            } else if (this.rolodexId != null) {
                this.refreshRolodex();
                contact = this.rolodex;
            }
        }
        return contact;
    }

    public String getContactOrganizationName() {
        Contactable contact = this.getContact();
        return contact != null ? contact.getContactOrganizationName() : null;
    }

    public String getGenericId() {
        return this.rolodexId != null ? this.rolodexId.toString() : this.personId;
    }

    public String getOrganizationIdentifier() {
        return this.getContact() != null ? this.getContact().getOrganizationIdentifier() : null;
    }

    public ContactRole getContactRole() {
        return this.contactRole;
    }

    public String getContactRoleCode() {
        return this.roleCode;
    }

    public String getEmailAddress() {
        return this.getContact() != null ? this.getContact().getEmailAddress() : null;
    }

    public String getFullName() {
        return this.fullName;
    }

    public KcPerson getPerson() {
        if (this.person == null && this.personId != null) {
            this.refreshPerson();
        }
        return this.person;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPhoneNumber() {
        return this.getContact() != null ? this.getContact().getPhoneNumber() : null;
    }

    public String getRoleCode() {
        return this.roleCode;
    }

    public NonOrganizationalRolodex getRolodex() {
        return this.rolodex;
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.getContactRole() == null ? 0 : this.getContactRole().hashCode());
        return 31 * result + (this.getContact() != null && this.getContact().getFullName() != null ? this.getContact().getFullName().hashCode() : 0);
    }

    public boolean isEmployee() {
        return this.getContact() != null && this.getContact() instanceof KcPerson;
    }

    public void resetPersistenceState() {
        this.institutionalProposalContactId = null;
    }

    public void setInstitutionalProposalContactId(Long institutionalProposalContactid) {
        this.institutionalProposalContactId = institutionalProposalContactid;
    }

    public void setContactRole(ContactRole contactRole) {
        this.contactRole = contactRole;
        this.roleCode = contactRole != null ? contactRole.getRoleCode() : null;
    }

    public void setContactRoleCode(String roleCode) {
        this.roleCode = roleCode;
        this.refreshContactRole();
    }

    public void setEmailAddress(String emailAddress) {
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setPerson(KcPerson person) {
        if (person != null && person.getPersonId() == null) {
            this.person = null;
            this.personId = null;
        } else {
            this.person = person;
            this.rolodex = null;
            this.rolodexId = null;
            if (person != null) {
                this.fullName = person.getFullName();
                this.personId = person.getPersonId();
            } else {
                this.fullName = null;
                this.personId = null;
            }
        }
    }

    public void setPersonId(String personId) {
        this.personId = personId;
        this.refreshPerson();
    }

    public void setPhoneNumber(String phoneNumber) {
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
        this.refreshContactRole();
    }

    public void setRolodex(NonOrganizationalRolodex rolodex) {
        if (rolodex != null && rolodex.getRolodexId() == null) {
            this.rolodex = null;
            this.rolodexId = null;
        } else {
            this.person = null;
            this.personId = null;
            this.rolodex = rolodex;
            if (rolodex != null) {
                this.fullName = rolodex.getFullName();
                this.rolodexId = rolodex.getRolodexId();
            } else {
                this.fullName = null;
                this.rolodexId = null;
            }
        }
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
        this.refreshRolodex();
    }

    public void setUnitName(String unitName) {
    }

    protected BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    protected abstract Class<? extends ContactRole> getContactRoleType();

    protected abstract String getContactRoleTypeIdentifier();

    protected ContactRole refreshContactRole() {
        ContactRole role = this.roleCode != null ? (ContactRole)this.getBusinessObjectService().findByPrimaryKey(this.getContactRoleType(), this.getIdentifierMap(this.getContactRoleTypeIdentifier(), (Object)this.roleCode)) : null;
        this.setContactRole(role);
        return role;
    }

    protected Map<String, Object> getIdentifierMap(String identifierField, Object identifierValue) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(identifierField, identifierValue);
        return map;
    }

    protected void refreshPerson() {
        if (!(this.personId == null || this.person != null && this.personId.equals(this.person.getPersonId()))) {
            this.setPerson(this.getKcPersonService().getKcPersonByPersonId(this.personId));
        }
    }

    protected void refreshRolodex() {
        NonOrganizationalRolodex rolodex = this.rolodexId != null ? (NonOrganizationalRolodex)this.getBusinessObjectService().findByPrimaryKey(NonOrganizationalRolodex.class, this.getIdentifierMap(ROLODEX_ID_FIELD_NAME, (Object)this.rolodexId)) : null;
        this.setRolodex(rolodex);
    }

    public InstitutionalProposal getSequenceOwner() {
        return this.getInstitutionalProposal();
    }

    public void setSequenceOwner(InstitutionalProposal newlyVersionedOwner) {
        this.setInstitutionalProposal(newlyVersionedOwner);
    }
}

