/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class InstitutionalProposalPersonAuditRule
implements DocumentAuditRule {
    private static final String CONTACTS_AUDIT_ERRORS = "contactsAuditErrors";
    private List<AuditError> auditErrors = new ArrayList();
    public static final String PROPOSAL_PROJECT_PERSON_LIST_ERROR_KEY = "document.institutionalProposalList[0].projectPerson.auditErrors";
    public static final String ERROR_PROPOSAL_PROJECT_PERSON_NO_PI = "error.awardProjectPerson.no.pi.exists";
    public static final String ERROR_PROPOSAL_PROJECT_PERSON_MULTIPLE_PI_EXISTS = "error.awardProjectPerson.pi.exists";
    public static final String ERROR_PROPOSAL_PROJECT_PERSON_UNIT_DETAILS_REQUIRED = "error.awardProjectPerson.unit.details.required";
    public static final String ERROR_PROPOSAL_PROJECT_PERSON_LEAD_UNIT_REQUIRED = "error.awardProjectPerson.lead.unit.required";

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)document;
        this.auditErrors = new ArrayList();
        valid &= this.checkPrincipalInvestigators(institutionalProposalDocument.getInstitutionalProposal().getProjectPersons());
        valid &= this.checkUnits(institutionalProposalDocument.getInstitutionalProposal().getProjectPersons());
        this.reportAndCreateAuditCluster();
        return valid &= this.checkLeadUnits(institutionalProposalDocument.getInstitutionalProposal().getProjectPersons());
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put(CONTACTS_AUDIT_ERRORS, new AuditCluster("Contacts", this.auditErrors, "Validation Errors"));
        }
    }

    protected boolean checkPrincipalInvestigators(List<InstitutionalProposalPerson> institutionalProposalPersons) {
        boolean valid = true;
        List principalInvestigators = this.getPrincipalInvestigators(institutionalProposalPersons);
        int piCount = principalInvestigators.size();
        if (piCount == 0) {
            valid = false;
            this.auditErrors.add(new AuditError(PROPOSAL_PROJECT_PERSON_LIST_ERROR_KEY, ERROR_PROPOSAL_PROJECT_PERSON_NO_PI, "contacts.Contacts"));
        } else if (piCount > 1) {
            valid = false;
            this.auditErrors.add(new AuditError(PROPOSAL_PROJECT_PERSON_LIST_ERROR_KEY, ERROR_PROPOSAL_PROJECT_PERSON_MULTIPLE_PI_EXISTS, "contacts.Contacts"));
        }
        return valid;
    }

    protected boolean checkUnits(List<InstitutionalProposalPerson> institutionalProposalPersons) {
        boolean valid = true;
        for (InstitutionalProposalPerson person : institutionalProposalPersons) {
            if (!person.isPrincipalInvestigator() && !person.isCoInvestigator() || person.getUnits() == null || person.getUnits().size() != 0) continue;
            valid = false;
            this.auditErrors.add(new AuditError(PROPOSAL_PROJECT_PERSON_LIST_ERROR_KEY, ERROR_PROPOSAL_PROJECT_PERSON_UNIT_DETAILS_REQUIRED, "contacts.Contacts", new String[]{person.getFullName()}));
        }
        return valid;
    }

    protected boolean checkLeadUnits(List<InstitutionalProposalPerson> institutionalProposalPersons) {
        boolean valid = true;
        List principalInvestigators = this.getPrincipalInvestigators(institutionalProposalPersons);
        if (principalInvestigators != null && principalInvestigators.size() == 1) {
            List piUnits = ((InstitutionalProposalPerson)principalInvestigators.get(0)).getUnits();
            int leadUnits = 0;
            for (InstitutionalProposalPersonUnit unit : piUnits) {
                if (!unit.isLeadUnit()) continue;
                ++leadUnits;
            }
            if (leadUnits != 1) {
                valid = false;
                this.auditErrors.add(new AuditError(PROPOSAL_PROJECT_PERSON_LIST_ERROR_KEY, ERROR_PROPOSAL_PROJECT_PERSON_LEAD_UNIT_REQUIRED, "contacts.Contacts"));
            }
        }
        return valid;
    }

    protected List<InstitutionalProposalPerson> getPrincipalInvestigators(List<InstitutionalProposalPerson> projectPersons) {
        ArrayList<InstitutionalProposalPerson> principalInvestigators = new ArrayList<InstitutionalProposalPerson>();
        for (InstitutionalProposalPerson p : projectPersons) {
            if (!p.isPrincipalInvestigator()) continue;
            principalInvestigators.add(p);
        }
        return principalInvestigators;
    }

    protected List<InstitutionalProposalPersonUnit> getPIUnits(List<InstitutionalProposalPerson> projectPersons) {
        ArrayList<InstitutionalProposalPersonUnit> units = new ArrayList<InstitutionalProposalPersonUnit>();
        for (InstitutionalProposalPerson p : projectPersons) {
            if (!p.isPrincipalInvestigator()) continue;
            for (InstitutionalProposalPersonUnit apu : p.getUnits()) {
                units.add(apu);
            }
        }
        return units;
    }
}

