/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonSaveRule;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonSaveRuleEvent;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.rice.krad.util.GlobalVariables;

public class InstitutionalProposalPersonSaveRuleImpl
implements InstitutionalProposalPersonSaveRule {
    public boolean processInstitutionalProposalPersonSaveBusinessRules(InstitutionalProposalPersonSaveRuleEvent event) {
        return this.processSaveInstitutionalProposalProjectPersonsBusinessRules(event.getProjectPersons());
    }

    boolean processSaveInstitutionalProposalProjectPersonsBusinessRules(List<InstitutionalProposalPerson> projectPersons) {
        if (projectPersons.size() == 0) {
            return true;
        }
        boolean valid = this.checkForDuplicateUnits(projectPersons);
        valid &= this.checkForKeyPersonProjectRoles(projectPersons);
        valid &= this.checkForOnePrincipalInvestigator(projectPersons);
        valid &= this.checkForRequiredUnitDetails(projectPersons);
        return valid &= this.checkForLeadUnitForPI(projectPersons);
    }

    boolean checkForKeyPersonProjectRoles(List<InstitutionalProposalPerson> projectPersons) {
        boolean valid = true;
        for (InstitutionalProposalPerson person : projectPersons) {
            if (!StringUtils.equalsIgnoreCase((String)person.getContactRole().getRoleCode(), (String)"KP") || !StringUtils.isBlank((String)person.getKeyPersonRole())) continue;
            valid = false;
            GlobalVariables.getMessageMap().putError("projectPersons[" + projectPersons.indexOf(person) + "].keyPersonRole", "error.awardProjectPerson.keyperson.role.required", new String[]{person.getFullName()});
        }
        return valid;
    }

    boolean checkForRequiredUnitDetails(List<InstitutionalProposalPerson> projectPersons) {
        boolean valid = true;
        for (InstitutionalProposalPerson p : projectPersons) {
            if (!p.isPrincipalInvestigator() && !p.isCoInvestigator() || p.getUnits().size() != 0) continue;
            valid = false;
            GlobalVariables.getMessageMap().putError("projectPersons", "error.awardProjectPerson.unit.details.required", new String[]{p.getFullName()});
        }
        return valid;
    }

    boolean checkForDuplicateUnits(List<InstitutionalProposalPerson> projectPersons) {
        boolean valid = true;
        for (InstitutionalProposalPerson p : projectPersons) {
            HashSet<Unit> uniqueUnits = new HashSet<Unit>();
            ArrayList<Unit> tempUnits = new ArrayList<Unit>();
            for (InstitutionalProposalPersonUnit apu : p.getUnits()) {
                uniqueUnits.add(apu.getUnit());
                tempUnits.add(apu.getUnit());
            }
            if (valid &= tempUnits.size() == uniqueUnits.size()) continue;
            for (Unit u : uniqueUnits) {
                tempUnits.remove(u);
            }
            HashSet duplicateUnits = new HashSet(tempUnits);
            for (Unit dupeUnit : duplicateUnits) {
                GlobalVariables.getMessageMap().putError("projectPersons", "error.awardProjectPerson.duplicate.units", new String[]{dupeUnit.getUnitName(), dupeUnit.getUnitNumber(), p.getFullName()});
            }
        }
        return valid;
    }

    boolean checkForOnePrincipalInvestigator(List<InstitutionalProposalPerson> projectPersons) {
        boolean result;
        int count = 0;
        for (InstitutionalProposalPerson p : projectPersons) {
            if (!p.isPrincipalInvestigator()) continue;
            ++count;
        }
        boolean bl = result = count == 1;
        if (!result) {
            if (count == 0) {
                GlobalVariables.getMessageMap().putError("projectPersons", "error.awardProjectPerson.no.pi.exists", new String[0]);
            } else {
                GlobalVariables.getMessageMap().putError("projectPersons", "error.awardProjectPerson.pi.exists", new String[0]);
            }
        }
        return result;
    }

    boolean checkForLeadUnitForPI(List<InstitutionalProposalPerson> projectPersons) {
        boolean valid = true;
        for (InstitutionalProposalPerson p : projectPersons) {
            InstitutionalProposalPersonUnit apu;
            if (!p.isPrincipalInvestigator()) continue;
            boolean found = false;
            Iterator i$ = p.getUnits().iterator();
            while (i$.hasNext() && !(found = (apu = (InstitutionalProposalPersonUnit)i$.next()).isLeadUnit())) {
            }
            valid = found;
            if (valid) continue;
            GlobalVariables.getMessageMap().putError("projectPersons", "error.awardProjectPerson.lead.unit.required", new String[0]);
        }
        return valid;
    }
}

