/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import java.util.Collection;
import java.util.HashMap;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnitCreditSplitRule;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnitCreditSplitRuleEvent;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalCreditSplitAuditError;
import org.kuali.kra.proposaldevelopment.bo.InvestigatorCreditType;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class InstitutionalProposalPersonUnitCreditSplitRuleImpl
extends ResearchDocumentRuleBase
implements InstitutionalProposalPersonUnitCreditSplitRule {
    private static final KualiDecimal MAX_TOTAL_VALUE = new KualiDecimal(100.0);

    public boolean checkInstitutionalProposalPersonUnitCreditSplitTotals(InstitutionalProposalPersonUnitCreditSplitRuleEvent event) {
        int errorCount = 0;
        for (InvestigatorCreditType creditType : this.loadInvestigatorCreditTypes()) {
            if (!creditType.addsToHundred().booleanValue()) continue;
            KualiDecimal value = (KualiDecimal)event.getTotalsByCreditSplitType().get(creditType.getInvCreditTypeCode());
            if (value == null) break;
            if (((KualiDecimal)MAX_TOTAL_VALUE.subtract((AbstractKualiDecimal)value)).isZero()) continue;
            InstitutionalProposalCreditSplitAuditError.addAuditError((String)"error.award.person.unit.credit.split.error", (String[])new String[]{creditType.getDescription()});
            ++errorCount;
        }
        return errorCount == 0;
    }

    Collection<InvestigatorCreditType> loadInvestigatorCreditTypes() {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("active", "true");
        return this.getBusinessObjectService().findMatching(InvestigatorCreditType.class, valueMap);
    }
}

