/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.award.home.ContactType;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.UnitAdministrator;
import org.kuali.kra.bo.UnitContactType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalContact;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalContactsBean;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalUnitContact;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalUnitContactAddRuleImpl;
import org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.UnitService;

public class InstitutionalProposalUnitContactsBean
extends InstitutionalProposalContactsBean {
    private static final long serialVersionUID = -1563581536920498669L;
    private static final int OSP_ADMINISTRATOR_TYPE_CODE = 2;
    private static final String DEFAULT_GROUP_CODE_FOR_UNIT_CONTACTS = "U";

    public InstitutionalProposalUnitContactsBean(InstitutionalProposalForm institutionalProposalForm) {
        super(institutionalProposalForm);
    }

    public void addUnitContact() {
        boolean success = new InstitutionalProposalUnitContactAddRuleImpl().processAddInstitutionalProposalUnitContactBusinessRules(this.getInstitutionalProposal(), this.getUnitContact());
        if (success) {
            this.getInstitutionalProposal().add(this.getUnitContact());
            this.init();
        }
    }

    public void deleteUnitContact(int lineToDelete) {
        this.deleteUnitContact(this.getUnitContacts(), lineToDelete);
    }

    public void syncInstitutionalProposalUnitContactsToLeadUnitContacts() {
        this.getInstitutionalProposal().setInstitutionalProposalUnitContacts(new ArrayList());
        List unitAdministrators = this.getUnitService().retrieveUnitAdministratorsByUnitNumber(this.institutionalProposalForm.getInstitutionalProposalDocument().getInstitutionalProposal().getUnitNumber());
        for (UnitAdministrator unitAdministrator : unitAdministrators) {
            if (!unitAdministrator.getUnitAdministratorType().getDefaultGroupFlag().equals(DEFAULT_GROUP_CODE_FOR_UNIT_CONTACTS)) continue;
            KcPerson person = this.getKcPersonService().getKcPersonByPersonId(unitAdministrator.getPersonId());
            InstitutionalProposalUnitContact newInstitutionalProposalUnitContact = new InstitutionalProposalUnitContact(UnitContactType.CONTACT);
            newInstitutionalProposalUnitContact.setPerson(person);
            newInstitutionalProposalUnitContact.setInstitutionalProposal(this.institutionalProposalForm.getInstitutionalProposalDocument().getInstitutionalProposal());
            newInstitutionalProposalUnitContact.setUnitAdministratorType(unitAdministrator.getUnitAdministratorType());
            newInstitutionalProposalUnitContact.setUnitAdministratorTypeCode(unitAdministrator.getUnitAdministratorTypeCode());
            newInstitutionalProposalUnitContact.setFullName(person.getFullName());
            this.getInstitutionalProposal().add(newInstitutionalProposalUnitContact);
        }
    }

    public UnitService getUnitService() {
        return (UnitService)KraServiceLocator.getService(UnitService.class);
    }

    public KcPersonService getKcPersonService() {
        return (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
    }

    public InstitutionalProposalUnitContact getUnitContact() {
        return (InstitutionalProposalUnitContact)this.newInstitutionalProposalContact;
    }

    public List<InstitutionalProposalUnitContact> getUnitContacts() {
        return this.institutionalProposalForm.getInstitutionalProposalDocument().getInstitutionalProposal().getInstitutionalProposalUnitContacts();
    }

    public int getUnitContactsCount() {
        return this.getUnitContacts().size();
    }

    protected void deleteUnitContact(List<InstitutionalProposalUnitContact> contacts, int lineToDelete) {
        if (contacts.size() > lineToDelete) {
            InstitutionalProposalUnitContact foundContact = contacts.get(lineToDelete);
            this.getInstitutionalProposal().getInstitutionalProposalUnitContacts().remove(foundContact);
        }
    }

    protected Class<? extends ContactRole> getContactRoleType() {
        return ContactType.class;
    }

    protected InstitutionalProposalContact createNewContact() {
        return new InstitutionalProposalUnitContact(UnitContactType.CONTACT);
    }

    private InstitutionalProposalUnitContact createInstitutionalProposalContactForPerson(UnitAdministrator unitAdministrator) {
        InstitutionalProposalUnitContact institutionalProposalUnitContact = new InstitutionalProposalUnitContact();
        institutionalProposalUnitContact.setInstitutionalProposal(this.getInstitutionalProposal());
        institutionalProposalUnitContact.setPersonId(unitAdministrator.getPerson().getPersonId());
        institutionalProposalUnitContact.setFullName(unitAdministrator.getPerson().getFullName());
        institutionalProposalUnitContact.setPerson(unitAdministrator.getPerson());
        institutionalProposalUnitContact.setUnitContactType(UnitContactType.CONTACT);
        institutionalProposalUnitContact.setUnitAdministratorType(unitAdministrator.getUnitAdministratorType());
        return institutionalProposalUnitContact;
    }
}

