/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.home;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.award.home.AwardType;
import org.kuali.kra.award.home.ValuableItem;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.NoticeOfOpportunity;
import org.kuali.kra.bo.NsfCode;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.ScienceKeyword;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.bo.UnitAdministrator;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.document.KeywordsManager;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.ProposalIpReviewJoin;
import org.kuali.kra.institutionalproposal.ProposalStatus;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonCreditSplit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalUnitContact;
import org.kuali.kra.institutionalproposal.customdata.InstitutionalProposalCustomData;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalComment;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCostShare;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalNotepad;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalScienceKeyword;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalUnrecoveredFandA;
import org.kuali.kra.institutionalproposal.ipreview.IntellectualPropertyReview;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLog;
import org.kuali.kra.institutionalproposal.proposallog.service.ProposalLogService;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReview;
import org.kuali.kra.negotiations.bo.Negotiable;
import org.kuali.kra.negotiations.bo.NegotiationPersonDTO;
import org.kuali.kra.proposaldevelopment.bo.ActivityType;
import org.kuali.kra.proposaldevelopment.bo.ProposalType;
import org.kuali.kra.proposaldevelopment.bo.ProposalUnitCreditSplit;
import org.kuali.kra.service.FiscalYearMonthService;
import org.kuali.kra.service.Sponsorable;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class InstitutionalProposal
extends KraPersistableBusinessObjectBase
implements KeywordsManager<InstitutionalProposalScienceKeyword>,
SequenceOwner<InstitutionalProposal>,
Sponsorable,
Negotiable {
    public static final String PROPOSAL_ID_PROPERTY_STRING = "proposalId";
    public static final String PROPOSAL_NUMBER_PROPERTY_STRING = "proposalNumber";
    public static final String PROPOSAL_SEQUENCE_STATUS_PROPERTY_STRING = "proposalSequenceStatus";
    public static final String PROPOSAL_NUMBER_TEST_DEFAULT_STRING = "1234";
    private static final long serialVersionUID = 1L;
    private static final Integer PROPOSAL_PENDING_STATUS_CODE = 1;
    private static final Integer PROPOSAL_FUNDED_STATUS_CODE = 2;
    private InstitutionalProposalDocument institutionalProposalDocument;
    private Long proposalId;
    private String proposalNumber;
    private String sponsorProposalNumber;
    private Integer sequenceNumber;
    private Integer proposalTypeCode;
    private String currentAccountNumber;
    private String title;
    private String sponsorCode;
    private Integer rolodexId;
    private String noticeOfOpportunityCode;
    private Integer gradStudHeadcount;
    private KualiDecimal gradStudPersonMonths;
    private boolean typeOfAccount;
    private String activityTypeCode;
    private Date requestedStartDateInitial;
    private Date requestedStartDateTotal;
    private Date requestedEndDateInitial;
    private Date requestedEndDateTotal;
    private String fiscalMonth;
    private String fiscalYear;
    private KualiDecimal totalDirectCostInitial;
    private KualiDecimal totalDirectCostTotal;
    private KualiDecimal totalIndirectCostInitial;
    private KualiDecimal totalIndirectCostTotal;
    private String numberOfCopies;
    private Date deadlineDate;
    private String deadlineTime;
    private Date createTimeStamp;
    private String deadlineType;
    private String mailBy;
    private String mailType;
    private String mailAccountNumber;
    private String mailDescription;
    private Boolean subcontractFlag;
    private String costSharingIndicator;
    private String idcRateIndicator;
    private String specialReviewIndicator;
    private Integer statusCode;
    private String unitNumber;
    private String scienceCodeIndicator;
    private String nsfCode;
    private NsfCode nsfCodeBo;
    private String primeSponsorCode;
    private String initialContractAdmin;
    private String ipReviewActivityIndicator;
    private String currentAwardNumber;
    private String cfdaNumber;
    private String opportunity;
    private Integer awardTypeCode;
    private String newDescription;
    private String proposalSequenceStatus;
    private boolean showReturnLink;
    private String instProposalNumber;
    private NoticeOfOpportunity noticeOfOpportunity;
    private ProposalType proposalType;
    private Rolodex rolodex;
    private Sponsor sponsor;
    private Sponsor primeSponsor;
    private String sponsorName;
    private ActivityType activityType;
    private AwardType awardType;
    private ProposalStatus proposalStatus;
    private Unit leadUnit;
    private KcPerson ospAdministrator;
    private InstitutionalProposalScienceKeyword proposalScienceKeyword;
    private InstitutionalProposalCostShare proposalCostSharing;
    private InstitutionalProposalPersonCreditSplit proposalPerCreditSplit;
    private ProposalUnitCreditSplit proposalUnitCreditSplit;
    private List<InstitutionalProposalComment> proposalComments;
    private IntellectualPropertyReview intellectualPropertyReview;
    private List<ProposalIpReviewJoin> proposalIpReviewJoins;
    private List<InstitutionalProposalPerson> projectPersons;
    private List<InstitutionalProposalUnitContact> institutionalProposalUnitContacts;
    private List<InstitutionalProposalCustomData> institutionalProposalCustomDataList;
    private List<InstitutionalProposalNotepad> institutionalProposalNotepads;
    private List<InstitutionalProposalSpecialReview> specialReviews;
    private List<InstitutionalProposalScienceKeyword> institutionalProposalScienceKeywords;
    private List<InstitutionalProposalCostShare> institutionalProposalCostShares;
    private List<InstitutionalProposalUnrecoveredFandA> institutionalProposalUnrecoveredFandAs;
    @SkipVersioning
    private List<AwardFundingProposal> awardFundingProposals;
    private Map<String, InstitutionalProposalComment> commentMap;
    private boolean sponsorNihMultiplePi;
    private transient Unit lookupUnit;
    private transient String lookupUnitName;
    private transient String lookupUnitNumber;
    private transient String lookupPersonNumber;
    private transient FiscalYearMonthService fiscalYearMonthService;
    private transient boolean allowUpdateTimestampToBeReset = true;

    public InstitutionalProposal() {
        this.initializeInstitutionalProposalWithDefaultValues();
        this.initializeCollections();
        this.calculateFiscalMonthAndYearFields();
    }

    private void initializeInstitutionalProposalWithDefaultValues() {
        this.setSequenceNumber(Integer.valueOf(1));
        this.setCostSharingIndicator("0");
        this.setIdcRateIndicator("0");
        this.setSpecialReviewIndicator("0");
        this.setScienceCodeIndicator("0");
        this.ipReviewActivityIndicator = "A";
        Calendar cl = Calendar.getInstance();
        this.setCreateTimeStamp(new Date(cl.getTime().getTime()));
        this.setTotalDirectCostInitial(new KualiDecimal(0));
        this.setTotalDirectCostTotal(new KualiDecimal(0));
        this.setTotalIndirectCostInitial(new KualiDecimal(0));
        this.setTotalIndirectCostTotal(new KualiDecimal(0));
        this.newDescription = this.getDefaultNewDescription();
        this.setProposalSequenceStatus(VersionStatus.PENDING.toString());
        this.setStatusCode(Integer.valueOf(1));
        this.projectPersons = new ArrayList();
        this.showReturnLink = true;
    }

    protected void initializeCollections() {
        this.institutionalProposalCustomDataList = new ArrayList();
        this.institutionalProposalNotepads = new ArrayList();
        this.specialReviews = new ArrayList();
        this.institutionalProposalScienceKeywords = new ArrayList();
        this.institutionalProposalCostShares = new ArrayList();
        this.institutionalProposalUnrecoveredFandAs = new ArrayList();
        this.proposalIpReviewJoins = new ArrayList();
        this.proposalIpReviewJoins.add(new ProposalIpReviewJoin());
        this.awardFundingProposals = new ArrayList();
        this.institutionalProposalUnitContacts = new ArrayList();
        this.proposalComments = new ArrayList();
    }

    public void setDefaultInitialContractAdmin() {
        if (!StringUtils.isBlank((String)this.getUnitNumber())) {
            List unitAdministrators = this.getUnitService().retrieveUnitAdministratorsByUnitNumber(this.getUnitNumber());
            for (UnitAdministrator unitAdministrator : unitAdministrators) {
                if (!"2".equals(unitAdministrator.getUnitAdministratorTypeCode())) continue;
                this.setInitialContractAdmin(unitAdministrator.getPersonId());
            }
        }
    }

    public void deactivateFundingProposals() {
        for (AwardFundingProposal fundingProposal : this.getAwardFundingProposals()) {
            fundingProposal.setActive(false);
        }
    }

    public void activateFundingProposals() {
        for (AwardFundingProposal fundingProposal : this.getAwardFundingProposals()) {
            fundingProposal.setActive(true);
        }
    }

    public boolean isActiveVersion() {
        return this.getProposalSequenceStatus().equals(VersionStatus.ACTIVE.toString());
    }

    public boolean isCancelled() {
        return this.getProposalSequenceStatus().equals(VersionStatus.CANCELED.toString());
    }

    public boolean isFundedByAward(String awardNumber, Integer awardSequence) {
        for (AwardFundingProposal awardFundingProposal : this.getAwardFundingProposals()) {
            if (!awardFundingProposal.getAward().getAwardNumber().equals(awardNumber) || !awardFundingProposal.getAward().getSequenceNumber().equals(awardSequence)) continue;
            return true;
        }
        return false;
    }

    private void calculateFiscalMonthAndYearFields() {
        String monthString = this.getFiscalYearMonthService().getCurrentFiscalMonthForDisplay().toString();
        if (monthString.length() == 1) {
            monthString = "0" + monthString;
        }
        this.setFiscalMonth(monthString);
        this.setFiscalYear(this.getFiscalYearMonthService().getCurrentFiscalYear().toString());
    }

    protected BusinessObjectService getKraBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService((String)"businessObjectService");
    }

    public InstitutionalProposalDocument getInstitutionalProposalDocument() {
        if (this.institutionalProposalDocument == null) {
            this.refreshReferenceObject("institutionalProposalDocument");
        }
        return this.institutionalProposalDocument;
    }

    public void setInstitutionalProposalDocument(InstitutionalProposalDocument institutionalProposalDocument) {
        this.institutionalProposalDocument = institutionalProposalDocument;
    }

    public void add(AwardFundingProposal afp) {
        this.awardFundingProposals.add(afp);
    }

    public void add(InstitutionalProposalNotepad institutionalProposalNotepad) {
        institutionalProposalNotepad.setEntryNumber(Integer.valueOf(this.institutionalProposalNotepads.size() + 1));
        institutionalProposalNotepad.setProposalNumber(this.getProposalNumber());
        this.institutionalProposalNotepads.add(institutionalProposalNotepad);
        institutionalProposalNotepad.setInstitutionalProposal(this);
    }

    public void add(InstitutionalProposalCostShare institutionalProposalCostShare) {
        institutionalProposalCostShare.setInstitutionalProposal(this);
        this.institutionalProposalCostShares.add(institutionalProposalCostShare);
    }

    public void add(InstitutionalProposalUnrecoveredFandA institutionalProposalUnrecoveredFandA) {
        institutionalProposalUnrecoveredFandA.setInstitutionalProposal(this);
        this.institutionalProposalUnrecoveredFandAs.add(institutionalProposalUnrecoveredFandA);
    }

    public KualiDecimal getTotalInitialCost() {
        KualiDecimal returnValue = new KualiDecimal(0);
        returnValue = (KualiDecimal)returnValue.add((AbstractKualiDecimal)this.totalDirectCostInitial);
        returnValue = (KualiDecimal)returnValue.add((AbstractKualiDecimal)this.totalIndirectCostInitial);
        return returnValue;
    }

    public KualiDecimal getTotalCost() {
        KualiDecimal returnValue = new KualiDecimal(0);
        returnValue = (KualiDecimal)returnValue.add((AbstractKualiDecimal)this.totalDirectCostTotal);
        returnValue = (KualiDecimal)returnValue.add((AbstractKualiDecimal)this.totalIndirectCostTotal);
        return returnValue;
    }

    KualiDecimal getTotalAmount(List<? extends ValuableItem> valuableItems) {
        KualiDecimal returnVal = new KualiDecimal(0.0);
        for (ValuableItem valuableItem : valuableItems) {
            KualiDecimal amount = valuableItem.getAmount() != null ? valuableItem.getAmount() : new KualiDecimal(0.0);
            returnVal = (KualiDecimal)returnVal.add((AbstractKualiDecimal)amount);
        }
        return returnVal;
    }

    public KualiDecimal getTotalCostShareAmount() {
        return this.getTotalAmount(this.institutionalProposalCostShares);
    }

    public KualiDecimal getTotalUnrecoveredFandAAmount() {
        return this.getTotalAmount(this.institutionalProposalUnrecoveredFandAs);
    }

    public List<InstitutionalProposalSpecialReview> getSpecialReviews() {
        return this.specialReviews;
    }

    public void setSpecialReviews(List<InstitutionalProposalSpecialReview> specialReviews) {
        this.specialReviews = specialReviews;
    }

    public List<InstitutionalProposalCustomData> getInstitutionalProposalCustomDataList() {
        return this.institutionalProposalCustomDataList;
    }

    public List<InstitutionalProposalNotepad> getInstitutionalProposalNotepads() {
        return this.institutionalProposalNotepads;
    }

    public void setInstitutionalProposalNotepads(List<InstitutionalProposalNotepad> institutionalProposalNotepads) {
        this.institutionalProposalNotepads = institutionalProposalNotepads;
    }

    public void setInstitutionalProposalCustomDataList(List<InstitutionalProposalCustomData> institutionalProposalCustomDataList) {
        this.institutionalProposalCustomDataList = institutionalProposalCustomDataList;
    }

    public List<InstitutionalProposalScienceKeyword> getInstitutionalProposalScienceKeywords() {
        return this.institutionalProposalScienceKeywords;
    }

    public void setInstitutionalProposalScienceKeywords(List<InstitutionalProposalScienceKeyword> institutionalProposalScienceKeywords) {
        this.institutionalProposalScienceKeywords = institutionalProposalScienceKeywords;
    }

    public void add(InstitutionalProposalPerson projectPerson) {
        this.projectPersons.add(projectPerson);
        projectPerson.setInstitutionalProposal(this);
    }

    public void add(InstitutionalProposalUnitContact institutionalProposalUnitContact) {
        this.institutionalProposalUnitContacts.add(institutionalProposalUnitContact);
        institutionalProposalUnitContact.setInstitutionalProposal(this);
    }

    public KcPerson getOspAdministrator() {
        for (InstitutionalProposalUnitContact contact : this.getInstitutionalProposalUnitContacts()) {
            if (!contact.isOspAdministrator()) continue;
            this.ospAdministrator = contact.getPerson();
            break;
        }
        return this.ospAdministrator;
    }

    public void setInstitutionalProposalUnitContacts(List<InstitutionalProposalUnitContact> institutionalProposalUnitContacts) {
        this.institutionalProposalUnitContacts = institutionalProposalUnitContacts;
    }

    public List<InstitutionalProposalUnitContact> getInstitutionalProposalUnitContacts() {
        return this.institutionalProposalUnitContacts;
    }

    public int getInstitutionalProposalContactsCount() {
        return this.institutionalProposalUnitContacts.size();
    }

    public Long getProposalId() {
        return this.proposalId;
    }

    public void setProposalId(Long proposalId) {
        this.proposalId = proposalId;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getSponsorProposalNumber() {
        return this.sponsorProposalNumber;
    }

    public void setSponsorProposalNumber(String sponsorProposalNumber) {
        this.sponsorProposalNumber = sponsorProposalNumber;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public Integer getProposalTypeCode() {
        return this.proposalTypeCode;
    }

    public void setProposalTypeCode(Integer proposalTypeCode) {
        this.proposalTypeCode = proposalTypeCode;
    }

    public String getCurrentAccountNumber() {
        return this.currentAccountNumber;
    }

    public void setCurrentAccountNumber(String currentAccountNumber) {
        this.currentAccountNumber = currentAccountNumber;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSponsorCode() {
        return this.sponsorCode;
    }

    public void setSponsorCode(String sponsorCode) {
        this.sponsorCode = sponsorCode;
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public String getNoticeOfOpportunityCode() {
        return this.noticeOfOpportunityCode;
    }

    public void setNoticeOfOpportunityCode(String noticeOfOpportunityCode) {
        this.noticeOfOpportunityCode = noticeOfOpportunityCode;
    }

    public Integer getGradStudHeadcount() {
        return this.gradStudHeadcount;
    }

    public void setGradStudHeadcount(Integer gradStudHeadcount) {
        this.gradStudHeadcount = gradStudHeadcount;
    }

    public KualiDecimal getGradStudPersonMonths() {
        return this.gradStudPersonMonths;
    }

    public void setGradStudPersonMonths(KualiDecimal gradStudPersonMonths) {
        this.gradStudPersonMonths = gradStudPersonMonths;
    }

    public boolean getTypeOfAccount() {
        return this.typeOfAccount;
    }

    public void setTypeOfAccount(boolean typeOfAccount) {
        this.typeOfAccount = typeOfAccount;
    }

    public String getActivityTypeCode() {
        return this.activityTypeCode;
    }

    public void setActivityTypeCode(String activityTypeCode) {
        this.activityTypeCode = activityTypeCode;
    }

    public void setLeadUnit(Unit leadUnit) {
        this.leadUnit = leadUnit;
    }

    public Date getRequestedStartDateInitial() {
        return this.requestedStartDateInitial;
    }

    public void setRequestedStartDateInitial(Date requestedStartDateInitial) {
        this.requestedStartDateInitial = requestedStartDateInitial;
    }

    public Date getRequestedStartDateTotal() {
        return this.requestedStartDateTotal;
    }

    public void setRequestedStartDateTotal(Date requestedStartDateTotal) {
        this.requestedStartDateTotal = requestedStartDateTotal;
    }

    public Date getRequestedEndDateInitial() {
        return this.requestedEndDateInitial;
    }

    public void setRequestedEndDateInitial(Date requestedEndDateInitial) {
        this.requestedEndDateInitial = requestedEndDateInitial;
    }

    public Date getRequestedEndDateTotal() {
        return this.requestedEndDateTotal;
    }

    public void setRequestedEndDateTotal(Date requestedEndDateTotal) {
        this.requestedEndDateTotal = requestedEndDateTotal;
    }

    public KualiDecimal getTotalDirectCostInitial() {
        return this.totalDirectCostInitial;
    }

    public void setTotalDirectCostInitial(KualiDecimal totalDirectCostInitial) {
        this.totalDirectCostInitial = totalDirectCostInitial == null ? KualiDecimal.ZERO : totalDirectCostInitial;
    }

    public KualiDecimal getTotalDirectCostTotal() {
        return this.totalDirectCostTotal;
    }

    public void setTotalDirectCostTotal(KualiDecimal totalDirectCostTotal) {
        this.totalDirectCostTotal = totalDirectCostTotal == null ? KualiDecimal.ZERO : totalDirectCostTotal;
    }

    public KualiDecimal getTotalIndirectCostInitial() {
        return this.totalIndirectCostInitial;
    }

    public void setTotalIndirectCostInitial(KualiDecimal totalIndirectCostInitial) {
        this.totalIndirectCostInitial = totalIndirectCostInitial == null ? KualiDecimal.ZERO : totalIndirectCostInitial;
    }

    public KualiDecimal getTotalIndirectCostTotal() {
        return this.totalIndirectCostTotal;
    }

    public void setTotalIndirectCostTotal(KualiDecimal totalIndirectCostTotal) {
        this.totalIndirectCostTotal = totalIndirectCostTotal == null ? KualiDecimal.ZERO : totalIndirectCostTotal;
    }

    public String getNumberOfCopies() {
        return this.numberOfCopies;
    }

    public void setNumberOfCopies(String numberOfCopies) {
        this.numberOfCopies = numberOfCopies;
    }

    public Date getDeadlineDate() {
        return this.deadlineDate;
    }

    public void setDeadlineDate(Date deadlineDate) {
        this.deadlineDate = deadlineDate;
    }

    public String getDeadlineTime() {
        return this.deadlineTime;
    }

    public void setDeadlineTime(String deadlineTime) {
        this.deadlineTime = deadlineTime;
    }

    public String getDeadlineType() {
        return this.deadlineType;
    }

    public void setDeadlineType(String deadlineType) {
        this.deadlineType = deadlineType;
    }

    public String getMailBy() {
        return this.mailBy;
    }

    public void setMailBy(String mailBy) {
        this.mailBy = mailBy;
    }

    public String getMailType() {
        return this.mailType;
    }

    public void setMailType(String mailType) {
        this.mailType = mailType;
    }

    public Unit getLeadUnit() {
        return this.leadUnit;
    }

    public String getMailAccountNumber() {
        return this.mailAccountNumber;
    }

    public void setMailAccountNumber(String mailAccountNumber) {
        this.mailAccountNumber = mailAccountNumber;
    }

    public String getMailDescription() {
        return this.mailDescription;
    }

    public void setMailDescription(String mailDescription) {
        this.mailDescription = mailDescription;
    }

    public boolean getSubcontractFlag() {
        return this.subcontractFlag;
    }

    public void setSubcontractFlag(boolean subcontractFlag) {
        this.subcontractFlag = subcontractFlag;
    }

    public String getCostSharingIndicator() {
        return this.costSharingIndicator;
    }

    public void setCostSharingIndicator(String costSharingIndicator) {
        this.costSharingIndicator = costSharingIndicator;
    }

    public String getIdcRateIndicator() {
        return this.idcRateIndicator;
    }

    public void setIdcRateIndicator(String idcRateIndicator) {
        this.idcRateIndicator = idcRateIndicator;
    }

    public String getSpecialReviewIndicator() {
        return this.specialReviewIndicator;
    }

    public void setSpecialReviewIndicator(String specialReviewIndicator) {
        this.specialReviewIndicator = specialReviewIndicator;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public String getScienceCodeIndicator() {
        return this.scienceCodeIndicator;
    }

    public void setScienceCodeIndicator(String scienceCodeIndicator) {
        this.scienceCodeIndicator = scienceCodeIndicator;
    }

    public String getNsfCode() {
        return this.nsfCode;
    }

    public void setNsfCode(String nsfCode) {
        this.nsfCode = nsfCode;
    }

    public String getPrimeSponsorCode() {
        return this.primeSponsorCode;
    }

    public void setPrimeSponsorCode(String primeSponsorCode) {
        this.primeSponsorCode = primeSponsorCode;
    }

    public String getInitialContractAdmin() {
        return this.initialContractAdmin;
    }

    public void setInitialContractAdmin(String initialContractAdmin) {
        this.initialContractAdmin = initialContractAdmin;
    }

    public String getIpReviewActivityIndicator() {
        return this.ipReviewActivityIndicator;
    }

    public void setIpReviewActivityIndicator(String ipReviewActivityIndicator) {
        this.ipReviewActivityIndicator = ipReviewActivityIndicator;
    }

    public String getCurrentAwardNumber() {
        return this.currentAwardNumber;
    }

    public void setCurrentAwardNumber(String currentAwardNumber) {
        this.currentAwardNumber = currentAwardNumber;
    }

    public String getCfdaNumber() {
        return this.cfdaNumber;
    }

    public void setCfdaNumber(String cfdaNumber) {
        this.cfdaNumber = cfdaNumber;
    }

    public String getOpportunity() {
        return this.opportunity;
    }

    public void setOpportunity(String opportunity) {
        this.opportunity = opportunity;
    }

    public Integer getAwardTypeCode() {
        return this.awardTypeCode;
    }

    public void setAwardTypeCode(Integer awardTypeCode) {
        this.awardTypeCode = awardTypeCode;
    }

    public ProposalStatus getProposalStatus() {
        if (this.proposalStatus == null && this.statusCode != null) {
            this.refreshReferenceObject("proposalStatus");
        }
        return this.proposalStatus;
    }

    public void setProposalStatus(ProposalStatus proposalStatus) {
        this.proposalStatus = proposalStatus;
    }

    public NoticeOfOpportunity getNoticeOfOpportunity() {
        return this.noticeOfOpportunity;
    }

    public void setNoticeOfOpportunity(NoticeOfOpportunity noticeOfOpportunity) {
        this.noticeOfOpportunity = noticeOfOpportunity;
    }

    public ProposalType getProposalType() {
        if (this.proposalType == null && this.proposalTypeCode != null) {
            this.refreshReferenceObject("proposalType");
        }
        return this.proposalType;
    }

    public void setProposalType(ProposalType proposalType) {
        this.proposalType = proposalType;
    }

    public Rolodex getRolodex() {
        return this.rolodex;
    }

    public void setRolodex(Rolodex rolodex) {
        this.rolodex = rolodex;
    }

    public Sponsor getSponsor() {
        if (InstitutionalProposal.outOfSync((String)this.sponsorCode, (Sponsor)this.sponsor)) {
            this.refreshReferenceObject("sponsor");
        }
        return this.sponsor;
    }

    public void setSponsor(Sponsor sponsor) {
        this.sponsor = sponsor;
        this.sponsorCode = sponsor != null ? sponsor.getSponsorCode() : null;
    }

    public Sponsor getPrimeSponsor() {
        if (InstitutionalProposal.outOfSync((String)this.primeSponsorCode, (Sponsor)this.primeSponsor)) {
            this.refreshReferenceObject("primeSponsor");
        }
        return this.primeSponsor;
    }

    private static boolean outOfSync(String code, Sponsor spon) {
        return spon == null && !StringUtils.isEmpty((String)code) || spon != null && !StringUtils.equals((String)spon.getSponsorCode(), (String)code) && !StringUtils.isEmpty((String)code);
    }

    public void setPrimeSponsor(Sponsor primeSponsor) {
        this.primeSponsor = primeSponsor;
        this.primeSponsorCode = primeSponsor != null ? primeSponsor.getSponsorCode() : null;
    }

    public InstitutionalProposalPerson getPrincipalInvestigator() {
        for (InstitutionalProposalPerson proposalPerson : this.getProjectPersons()) {
            if (!proposalPerson.isPrincipalInvestigator()) continue;
            return proposalPerson;
        }
        return null;
    }

    public void setPrincipalInvestigator(InstitutionalProposalPerson proposalPerson) {
        proposalPerson.setRoleCode("PI");
        this.getProjectPersons().add(proposalPerson);
    }

    public String getSponsorName() {
        Sponsor tempSponsor = this.getSponsor();
        this.sponsorName = tempSponsor != null ? tempSponsor.getSponsorName() : null;
        return this.sponsorName;
    }

    public ActivityType getActivityType() {
        if (this.activityType == null && this.activityTypeCode != null) {
            this.refreshReferenceObject("activityType");
        }
        return this.activityType;
    }

    public void setActivityType(ActivityType activityType) {
        this.activityType = activityType;
    }

    public AwardType getAwardType() {
        return this.awardType;
    }

    public List<AwardFundingProposal> getAwardFundingProposals() {
        return this.awardFundingProposals;
    }

    public AwardFundingProposal getAwardFundingProposal(int index) {
        return (AwardFundingProposal)this.getAwardFundingProposals().get(index);
    }

    public boolean getAwardFundingProposalsExist() {
        return this.getAwardFundingProposals().size() > 0;
    }

    public List<AwardFundingProposal> getActiveAwardFundingProposals() {
        ArrayList<AwardFundingProposal> activeAfps = new ArrayList<AwardFundingProposal>();
        for (AwardFundingProposal awardFundingProposal : this.getAwardFundingProposals()) {
            if (!awardFundingProposal.isActive()) continue;
            activeAfps.add(awardFundingProposal);
        }
        return activeAfps;
    }

    public void setAwardType(AwardType awardType) {
        this.awardType = awardType;
    }

    public String getFiscalMonth() {
        return this.fiscalMonth;
    }

    public void setFiscalMonth(String fiscalMonth) {
        this.fiscalMonth = fiscalMonth;
    }

    public String getFiscalYear() {
        return this.fiscalYear;
    }

    public void setFiscalYear(String fiscalYear) {
        this.fiscalYear = fiscalYear;
    }

    public String getUnitNumber() {
        return this.unitNumber;
    }

    public void setUnitNumber(String unitNumber) {
        this.unitNumber = unitNumber;
    }

    public String getLeadUnitNumber() {
        return this.getUnitNumber();
    }

    public void setLeadUnitNumber(String unitNumber) {
        this.unitNumber = unitNumber;
    }

    public void setAwardFundingProposals(List<AwardFundingProposal> awardFundingProposals) {
        this.awardFundingProposals = awardFundingProposals;
    }

    public InstitutionalProposalScienceKeyword getProposalScienceKeyword() {
        return this.proposalScienceKeyword;
    }

    public void setProposalScienceKeyword(InstitutionalProposalScienceKeyword proposalScienceKeyword) {
        this.proposalScienceKeyword = proposalScienceKeyword;
    }

    public InstitutionalProposalCostShare getProposalCostSharing() {
        return this.proposalCostSharing;
    }

    public void setProposalCostSharing(InstitutionalProposalCostShare proposalCostSharing) {
        this.proposalCostSharing = proposalCostSharing;
    }

    public List<InstitutionalProposalPerson> getProjectPersons() {
        if (CollectionUtils.isNotEmpty((Collection)this.projectPersons)) {
            Collections.sort(this.projectPersons, new ProjectPersonComparator(this));
        }
        return this.projectPersons;
    }

    public void setProjectPersons(List<InstitutionalProposalPerson> projectPersons) {
        this.projectPersons = projectPersons;
    }

    public InstitutionalProposalPersonCreditSplit getProposalPerCreditSplit() {
        return this.proposalPerCreditSplit;
    }

    public void setProposalPerCreditSplit(InstitutionalProposalPersonCreditSplit proposalPerCreditSplit) {
        this.proposalPerCreditSplit = proposalPerCreditSplit;
    }

    public ProposalUnitCreditSplit getProposalUnitCreditSplit() {
        return this.proposalUnitCreditSplit;
    }

    public void setProposalUnitCreditSplit(ProposalUnitCreditSplit proposalUnitCreditSplit) {
        this.proposalUnitCreditSplit = proposalUnitCreditSplit;
    }

    public List<InstitutionalProposalComment> getProposalComments() {
        return this.proposalComments;
    }

    public void setProposalComments(List<InstitutionalProposalComment> proposalComments) {
        this.proposalComments = proposalComments;
    }

    public IntellectualPropertyReview getIntellectualPropertyReview() {
        return this.intellectualPropertyReview;
    }

    public void setIntellectualPropertyReview(IntellectualPropertyReview intellectualPropertyReview) {
        this.intellectualPropertyReview = intellectualPropertyReview;
    }

    public List<ProposalIpReviewJoin> getProposalIpReviewJoins() {
        return this.proposalIpReviewJoins;
    }

    public void setProposalIpReviewJoins(List<ProposalIpReviewJoin> proposalIpReviewJoins) {
        this.proposalIpReviewJoins = proposalIpReviewJoins;
    }

    public ProposalIpReviewJoin getProposalIpReviewJoin() {
        if (ObjectUtils.isNotNull((Object)(this.proposalIpReviewJoins != null ? 1 : 0))) {
            return (ProposalIpReviewJoin)this.proposalIpReviewJoins.get(0);
        }
        return null;
    }

    public void setProposalIpReviewJoin(ProposalIpReviewJoin proposalIpReviewJoin) {
        this.proposalIpReviewJoins.add(0, proposalIpReviewJoin);
    }

    public List<InstitutionalProposalCostShare> getInstitutionalProposalCostShares() {
        return this.institutionalProposalCostShares;
    }

    public void setInstitutionalProposalCostShares(List<InstitutionalProposalCostShare> institutionalProposalCostShares) {
        this.institutionalProposalCostShares = institutionalProposalCostShares;
    }

    public List<InstitutionalProposalUnrecoveredFandA> getInstitutionalProposalUnrecoveredFandAs() {
        return this.institutionalProposalUnrecoveredFandAs;
    }

    public void setInstitutionalProposalUnrecoveredFandAs(List<InstitutionalProposalUnrecoveredFandA> institutionalProposalUnrecoveredFandAs) {
        this.institutionalProposalUnrecoveredFandAs = institutionalProposalUnrecoveredFandAs;
    }

    public Date getCreateTimeStamp() {
        return this.createTimeStamp;
    }

    public void setCreateTimeStamp(Date createTimeStamp) {
        this.createTimeStamp = createTimeStamp;
    }

    public String getDefaultNewDescription() {
        return "(select)";
    }

    public String getNewDescription() {
        return this.newDescription;
    }

    public void setNewDescription(String newDescription) {
        this.newDescription = newDescription;
    }

    public String getProposalSequenceStatus() {
        return this.proposalSequenceStatus;
    }

    public void setProposalSequenceStatus(String proposalSequenceStatus) {
        this.proposalSequenceStatus = proposalSequenceStatus;
    }

    public void addSpecialReview(InstitutionalProposalSpecialReview specialReview) {
        specialReview.setSequenceOwner(this);
        this.getSpecialReviews().add(specialReview);
    }

    public InstitutionalProposalSpecialReview getSpecialReview(int index) {
        return (InstitutionalProposalSpecialReview)this.getSpecialReviews().get(index);
    }

    public List<InstitutionalProposalScienceKeyword> getKeywords() {
        return this.institutionalProposalScienceKeywords;
    }

    public void setKeywords(List<InstitutionalProposalScienceKeyword> institutionalProposalScienceKeywords) {
        this.institutionalProposalScienceKeywords = institutionalProposalScienceKeywords;
    }

    public void addKeyword(ScienceKeyword scienceKeyword) {
        InstitutionalProposalScienceKeyword institutionalProposalScienceKeyword = new InstitutionalProposalScienceKeyword(this, scienceKeyword);
        this.getKeywords().add(institutionalProposalScienceKeyword);
    }

    public InstitutionalProposalScienceKeyword getKeyword(int index) {
        return (InstitutionalProposalScienceKeyword)this.getKeywords().get(index);
    }

    public Integer getOwnerSequenceNumber() {
        return null;
    }

    public void incrementSequenceNumber() {
        InstitutionalProposal institutionalProposal = this;
        Integer n = institutionalProposal.sequenceNumber;
        Integer n2 = institutionalProposal.sequenceNumber = Integer.valueOf(institutionalProposal.sequenceNumber + 1);
    }

    public InstitutionalProposal getSequenceOwner() {
        return this;
    }

    public void setSequenceOwner(InstitutionalProposal newOwner) {
    }

    public void remove(AwardFundingProposal afp) {
        this.awardFundingProposals.remove(afp);
        this.updateFundingStatus();
    }

    public void resetPersistenceState() {
        this.proposalId = null;
    }

    public String getVersionNameField() {
        return "proposalNumber";
    }

    protected void postPersist() {
        super.postPersist();
        this.updateProposalIpReviewJoin();
        if (this.proposalId != null && this.proposalNumber != null) {
            ((ProposalLogService)KraServiceLocator.getService(ProposalLogService.class)).updateMergedInstProposal(this.proposalId, this.proposalNumber);
        }
    }

    protected void postLoad() {
        super.postLoad();
    }

    protected void updateProposalIpReviewJoin() {
        ProposalIpReviewJoin proposalIpReviewJoin = this.getProposalIpReviewJoin();
        if (ObjectUtils.isNotNull((Object)proposalIpReviewJoin.getProposalIpReviewJoinId())) {
            proposalIpReviewJoin.setProposalIpReviewJoinId(null);
        } else {
            IntellectualPropertyReview ipReview = new IntellectualPropertyReview();
            ipReview.setSequenceNumber(Integer.valueOf(0));
            ipReview.setProposalNumber(this.getProposalNumber());
            ipReview.setIpReviewSequenceStatus(VersionStatus.ACTIVE.toString());
            this.getBusinessObjectService().save((PersistableBusinessObject)ipReview);
            proposalIpReviewJoin = new ProposalIpReviewJoin();
            proposalIpReviewJoin.setIpReviewId(ipReview.getIpReviewId());
        }
        proposalIpReviewJoin.setProposalId(this.getProposalId());
        this.getBusinessObjectService().save((PersistableBusinessObject)proposalIpReviewJoin);
        this.setProposalIpReviewJoin(proposalIpReviewJoin);
    }

    public ActivityType getActivityTypeFromCode() {
        if (this.activityType == null && this.activityTypeCode != null) {
            HashMap<String, String> identifiers = new HashMap<String, String>();
            identifiers.put("activityTypeCode", this.activityTypeCode);
            this.activityType = (ActivityType)this.getBusinessObjectService().findByPrimaryKey(ActivityType.class, identifiers);
        }
        return this.activityType;
    }

    public ProposalType getProposalTypeFromCode() {
        if (this.proposalType == null && this.proposalTypeCode != null) {
            HashMap<String, Integer> identifiers = new HashMap<String, Integer>();
            identifiers.put("proposalTypeCode", this.proposalTypeCode);
            this.proposalType = (ProposalType)this.getBusinessObjectService().findByPrimaryKey(ProposalType.class, identifiers);
        }
        return this.proposalType;
    }

    public void doProposalLogDataFeed(ProposalLog proposalLog) {
        this.setProposalNumber(proposalLog.getProposalNumber());
        this.setDeadlineDate(proposalLog.getDeadlineDate());
        this.setDeadlineTime(proposalLog.getDeadlineTime());
        this.calculateFiscalMonthAndYearFields();
        this.setProposalTypeCode(Integer.valueOf(Integer.parseInt(proposalLog.getProposalTypeCode())));
        this.setStatusCode(Integer.valueOf(1));
        this.setSponsorCode(proposalLog.getSponsorCode());
        this.setTitle(proposalLog.getTitle());
        this.setLeadUnit(this.getUnitService().getUnit(proposalLog.getLeadUnit()));
        this.setLeadUnitNumber(proposalLog.getLeadUnit());
        this.setDefaultInitialContractAdmin();
        InstitutionalProposalPerson ipPerson = new InstitutionalProposalPerson();
        if (StringUtils.isNotBlank((String)proposalLog.getPiId()) && proposalLog.getPerson() != null) {
            ipPerson.setPerson(proposalLog.getPerson());
        } else if (proposalLog.getRolodexId() != null && proposalLog.getRolodex() != null) {
            ipPerson.setRolodex(proposalLog.getRolodex());
        }
        this.initializeDefaultPrincipalInvestigator(ipPerson);
        this.setPrincipalInvestigator(ipPerson);
    }

    private void initializeDefaultPrincipalInvestigator(InstitutionalProposalPerson ipPerson) {
        ipPerson.setProposalNumber(this.getProposalNumber());
        ipPerson.setSequenceNumber(this.getSequenceNumber());
        ipPerson.initializeDefaultCreditSplits();
        InstitutionalProposalPersonUnit ipPersonUnit = new InstitutionalProposalPersonUnit();
        ipPersonUnit.setUnit(this.getLeadUnit());
        ipPersonUnit.setLeadUnit(true);
        ipPersonUnit.initializeDefaultCreditSplits();
        ipPerson.add(ipPersonUnit);
        ipPerson.setInstitutionalProposal(this);
    }

    public UnitService getUnitService() {
        return (UnitService)KraServiceLocator.getService(UnitService.class);
    }

    protected BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    private void updateFundingStatus() {
        this.setStatusCode(this.awardFundingProposals.size() > 0 ? PROPOSAL_FUNDED_STATUS_CODE : PROPOSAL_PENDING_STATUS_CODE);
    }

    public NsfCode getNsfCodeBo() {
        return this.nsfCodeBo;
    }

    public void setNsfCodeBo(NsfCode nsfCodeBo) {
        this.nsfCodeBo = nsfCodeBo;
    }

    public KcPerson getInitialContractAdminUser() {
        if (!StringUtils.isBlank((String)this.getInitialContractAdmin())) {
            try {
                return this.getKcPersonService().getKcPersonByPersonId(this.getInitialContractAdmin());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public InstitutionalProposalComment getSummaryComment() {
        return this.getInstitutionalProposalCommentByType("12", true);
    }

    public InstitutionalProposalComment getDeliveryComment() {
        return this.getInstitutionalProposalCommentByType("13", true);
    }

    public InstitutionalProposalComment getCostShareComment() {
        return this.getInstitutionalProposalCommentByType("9", true);
    }

    public InstitutionalProposalComment getUnrecoveredFandAComment() {
        return this.getInstitutionalProposalCommentByType("8", true);
    }

    public InstitutionalProposalComment getGeneralComment() {
        return this.getInstitutionalProposalCommentByType("16", true);
    }

    public InstitutionalProposalComment getInstitutionalProposalCommentByType(String commentTypeCode, boolean createNew) {
        InstitutionalProposalComment ipComment = (InstitutionalProposalComment)this.getCommentMap().get(commentTypeCode);
        if (ipComment == null && createNew) {
            ipComment = new InstitutionalProposalComment(commentTypeCode);
            ipComment.refreshReferenceObject("commentType");
            this.add(ipComment);
            this.commentMap.put(ipComment.getCommentType().getCommentTypeCode(), ipComment);
        }
        return ipComment;
    }

    public void add(InstitutionalProposalComment ipComment) {
        this.proposalComments.add(ipComment);
        ipComment.setInstitutionalProposal(this);
    }

    private Map<String, InstitutionalProposalComment> getCommentMap() {
        if (this.commentMap == null) {
            this.commentMap = new HashMap();
            for (InstitutionalProposalComment ipc : this.proposalComments) {
                this.commentMap.put(ipc.getCommentType().getCommentTypeCode(), ipc);
            }
        }
        return this.commentMap;
    }

    void retrieveInstProposalNumberFromDB() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("proposalNumber", this.proposalNumber);
        ProposalLog proposalLog = (ProposalLog)this.getBusinessObjectService().findByPrimaryKey(ProposalLog.class, criteria);
        this.instProposalNumber = proposalLog == null ? null : proposalLog.getInstProposalNumber();
    }

    public void setLookupUnit(Unit lookupUnit) {
        this.lookupUnit = lookupUnit;
    }

    public Unit getLookupUnit() {
        return this.lookupUnit;
    }

    public void setLookupUnitName(String lookupUnitName) {
        this.lookupUnitName = lookupUnitName;
    }

    public String getLookupUnitName() {
        return this.lookupUnitName;
    }

    public void setLookupUnitNumber(String lookupUnitNumber) {
        this.lookupUnitNumber = lookupUnitNumber;
    }

    public String getLookupUnitNumber() {
        return this.lookupUnitNumber;
    }

    public void setLookupPersonNumber(String lookupPersonNumber) {
        this.lookupPersonNumber = lookupPersonNumber;
    }

    public String getLookupPersonNumber() {
        return this.lookupPersonNumber;
    }

    public void setShowReturnLink(boolean val) {
        this.showReturnLink = val;
    }

    public boolean getShowReturnLink() {
        return this.showReturnLink;
    }

    public String getInstProposalNumber() {
        if (this.instProposalNumber == null) {
            this.instProposalNumber = this.proposalNumber;
        }
        return this.instProposalNumber;
    }

    public void setInstProposalNumber(String instProposalNumber) {
        this.instProposalNumber = instProposalNumber;
    }

    public int getTotalUnitCount() {
        int count = 0;
        for (InstitutionalProposalPerson person : this.projectPersons) {
            count += person.getUnits().size();
        }
        return count;
    }

    public boolean isSponsorNihMultiplePi() {
        return this.sponsorNihMultiplePi;
    }

    public void setSponsorNihMultiplePi(boolean sponsorNihMultiplePi) {
        this.sponsorNihMultiplePi = sponsorNihMultiplePi;
    }

    public String getLeadUnitName() {
        String name = this.getLeadUnit() == null ? "" : this.getLeadUnit().getUnitName();
        return name;
    }

    public String getPiName() {
        return this.getPiEmployeeName();
    }

    public String getPiEmployeeName() {
        String name = this.getPrincipalInvestigator() == null ? "" : this.getPrincipalInvestigator().getFullName();
        return name;
    }

    public String getPiNonEmployeeName() {
        return "";
    }

    public String getAdminPersonName() {
        return "";
    }

    public String getPrimeSponsorName() {
        String name = this.getPrimeSponsor() == null ? "" : this.getPrimeSponsor().getSponsorName();
        return name;
    }

    public String getSponsorAwardNumber() {
        return "";
    }

    public String getSubAwardOrganizationName() {
        return "";
    }

    public List<NegotiationPersonDTO> getProjectPeople() {
        ArrayList<NegotiationPersonDTO> kcPeople = new ArrayList<NegotiationPersonDTO>();
        for (InstitutionalProposalPerson person : this.getProjectPersons()) {
            kcPeople.add(new NegotiationPersonDTO(person.getPerson(), person.getRoleCode()));
        }
        return kcPeople;
    }

    public String getAssociatedDocumentId() {
        return this.getProposalNumber();
    }

    public String getNegotiableProposalTypeCode() {
        if (this.getProposalTypeCode() != null) {
            return this.getProposalTypeCode().toString();
        }
        return "";
    }

    public ProposalType getNegotiableProposalType() {
        return this.getProposalType();
    }

    public String getSubAwardRequisitionerName() {
        return "";
    }

    public String getSubAwardRequisitionerUnitNumber() {
        return "";
    }

    public String getSubAwardRequisitionerUnitName() {
        return "";
    }

    public String getSubAwardRequisitionerId() {
        return "";
    }

    public FiscalYearMonthService getFiscalYearMonthService() {
        if (this.fiscalYearMonthService == null) {
            this.fiscalYearMonthService = (FiscalYearMonthService)KraServiceLocator.getService(FiscalYearMonthService.class);
        }
        return this.fiscalYearMonthService;
    }

    public boolean isAllowUpdateTimestampToBeReset() {
        return this.allowUpdateTimestampToBeReset;
    }

    public void setAllowUpdateTimestampToBeReset(boolean allowUpdateTimestampToBeReset) {
        this.allowUpdateTimestampToBeReset = allowUpdateTimestampToBeReset;
    }

    public void setUpdateTimestamp(Timestamp updateTimestamp) {
        if (this.isAllowUpdateTimestampToBeReset()) {
            super.setUpdateTimestamp(updateTimestamp);
        } else {
            this.setAllowUpdateTimestampToBeReset(true);
        }
    }
}

