/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.notification;

import java.util.List;
import org.kuali.kra.common.notification.NotificationContextBase;
import org.kuali.kra.common.notification.NotificationRenderer;
import org.kuali.kra.common.notification.service.KcNotificationModuleRoleService;
import org.kuali.kra.common.notification.service.KcNotificationRoleQualifierService;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.notification.InstitutionalProposalNotificationRenderer;
import org.kuali.kra.institutionalproposal.notification.InstitutionalProposalNotificationRoleQualifierService;
import org.kuali.kra.util.EmailAttachment;

public class InstitutionalProposalNotificationContext
extends NotificationContextBase {
    private static final long serialVersionUID = 2192183278537033594L;
    private InstitutionalProposal proposal;
    private String documentNumber;
    private String actionTypeCode;
    private String contextName;
    private List<EmailAttachment> emailAttachments;
    private String forwardName;

    public InstitutionalProposalNotificationContext(InstitutionalProposal institutionalProposal, String actionTypeCode, String contextName, NotificationRenderer renderer, String forwardName) {
        super(renderer);
        this.proposal = institutionalProposal;
        this.documentNumber = institutionalProposal.getInstitutionalProposalDocument().getDocumentNumber();
        this.actionTypeCode = actionTypeCode;
        this.contextName = contextName;
        this.forwardName = forwardName;
        this.setNotificationService((KcNotificationService)KraServiceLocator.getService(KcNotificationService.class));
        this.setNotificationModuleRoleService((KcNotificationModuleRoleService)KraServiceLocator.getService(KcNotificationModuleRoleService.class));
        InstitutionalProposalNotificationRoleQualifierService roleQualifier = (InstitutionalProposalNotificationRoleQualifierService)KraServiceLocator.getService(InstitutionalProposalNotificationRoleQualifierService.class);
        roleQualifier.setInstitutionalProposal(institutionalProposal);
        this.setNotificationRoleQualifierService((KcNotificationRoleQualifierService)roleQualifier);
    }

    public InstitutionalProposalNotificationContext(InstitutionalProposal institutionalProposal, String actionTypeCode, String contextName, String forwardName) {
        this(institutionalProposal, actionTypeCode, contextName, (NotificationRenderer)KraServiceLocator.getService(InstitutionalProposalNotificationRenderer.class), forwardName);
        ((InstitutionalProposalNotificationRenderer)this.getRenderer()).setInstitutionalProposal(institutionalProposal);
    }

    public String getModuleCode() {
        return "2";
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public String getActionTypeCode() {
        return this.actionTypeCode;
    }

    public String getContextName() {
        return this.contextName;
    }

    public List<EmailAttachment> getEmailAttachments() {
        return this.emailAttachments;
    }

    public void setEmailAttachments(List<EmailAttachment> emailAttachments) {
        this.emailAttachments = emailAttachments;
    }

    public String getForwardName() {
        return this.forwardName;
    }

    public void setForwardName(String forwardName) {
        this.forwardName = forwardName;
    }
}

