/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.printing.xmlstream;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import noNamespace.ActivityType;
import noNamespace.AnticipatedAwardType;
import noNamespace.BudgetDataType;
import noNamespace.CostSharingType;
import noNamespace.IDCRateType;
import noNamespace.IPDisclosureItemType;
import noNamespace.IPKeyPersonType;
import noNamespace.IPSchoolInfoType;
import noNamespace.IPsponsorType;
import noNamespace.InstProposalMasterData;
import noNamespace.InstituteProposalDocument;
import noNamespace.InvestigatorType2;
import noNamespace.MailingInfoType;
import noNamespace.NSFcodeType;
import noNamespace.NoticeOfOppType;
import noNamespace.OtherGroupDetailsTypes;
import noNamespace.OtherGroupTypes;
import noNamespace.PersonType;
import noNamespace.ProposalStatusType;
import noNamespace.ProposalType;
import noNamespace.ScienceCodeType;
import noNamespace.SpecialReviewType2;
import noNamespace.UnitType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.award.home.AwardType;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.NoticeOfOpportunity;
import org.kuali.kra.bo.NsfCode;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.SpecialReviewApprovalType;
import org.kuali.kra.bo.SpecialReviewType;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.costshare.CostShareService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.ProposalStatus;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.kra.institutionalproposal.customdata.InstitutionalProposalCustomData;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalComment;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCostShare;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalScienceKeyword;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalUnrecoveredFandA;
import org.kuali.kra.institutionalproposal.printing.InstitutionalProposalPrintType;
import org.kuali.kra.institutionalproposal.printing.service.InstitutionalProposalPersonService;
import org.kuali.kra.institutionalproposal.printing.xmlstream.InstitutionalProposalBaseStream;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReview;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.printing.util.PrintingUtils;
import org.kuali.kra.proposaldevelopment.bo.ActivityType;
import org.kuali.kra.service.CustomAttributeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class InstitutionalProposalXmlStream
extends InstitutionalProposalBaseStream {
    private static final Log LOG = LogFactory.getLog(InstitutionalProposalXmlStream.class);
    private static final String PROPOSAL_SUMMARY_COMMENT_CODE = "21";
    private static final String COST_SHARING_COMMENT_CODE = "22";
    private static final String INDIRECT_COST_COMMENT_CODE = "23";
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    private static final String SPECIAL_REVIEW_APPROVAL_CODE = "5";
    private static final String SPONSOR_CODE = "sponsorCode";
    private static final String NSF_CODE = "nsfCode";
    private static final String NOTICE_OF_OPPORTUNITY_CODE = "noticeOfOpportunityCode";
    private static final String PROPOSAL_TYPE_CODE = "proposalTypeCode";
    private static final String PROPOSAL_STATUS_CODE = "proposalStatusCode";
    private static final String SCHOOL_NAME = "SCHOOL_NAME";
    private static final String SCHOOL_ACRONYM = "SCHOOL_ACRONYM";
    private InstitutionalProposalPersonService institutionalProposalPersonService;

    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, XmlObject> xmlObjectList = new LinkedHashMap<String, XmlObject>();
        InstitutionalProposal institutionalProposal = (InstitutionalProposal)printableBusinessObject;
        InstituteProposalDocument instituteProposalDocument = InstituteProposalDocument.Factory.newInstance();
        InstituteProposalDocument.InstituteProposal instituteProposalXmlObject = this.getInstituteProposal(institutionalProposal);
        instituteProposalDocument.setInstituteProposal(instituteProposalXmlObject);
        xmlObjectList.put(InstitutionalProposalPrintType.INSTITUTIONAL_PROPOSAL_REPORT.getInstitutionalProposalPrintType(), (XmlObject)instituteProposalDocument);
        return xmlObjectList;
    }

    private InstituteProposalDocument.InstituteProposal getInstituteProposal(InstitutionalProposal institutionalProposal) {
        InstituteProposalDocument.InstituteProposal instituteProposalXmlObject = InstituteProposalDocument.InstituteProposal.Factory.newInstance();
        List proposalPersons = this.institutionalProposalPersonService.getInvestigatorsFromDevelopmentProposal(institutionalProposal.getProposalNumber());
        instituteProposalXmlObject.setInstProposalMaster(this.getInstProposalMasterData(institutionalProposal));
        instituteProposalXmlObject.setInvestigatorsArray(this.getInvestigatorTypes(institutionalProposal));
        instituteProposalXmlObject.setBudgetData(this.getBudgetDataType(institutionalProposal));
        instituteProposalXmlObject.setMailingInfo(this.getMailingInfoType(institutionalProposal));
        instituteProposalXmlObject.setIDCRatesArray(this.getIdcRateTypes(institutionalProposal));
        if (institutionalProposal.getUnrecoveredFandAComment() != null) {
            instituteProposalXmlObject.setIDCRatesComments(institutionalProposal.getUnrecoveredFandAComment().getComments());
        }
        if (institutionalProposal.getCostShareComment() != null) {
            instituteProposalXmlObject.setCostSharingComments(institutionalProposal.getCostShareComment().getComments());
        }
        instituteProposalXmlObject.setSpecialReviewsArray(this.getSpecialReviewTypes(institutionalProposal));
        instituteProposalXmlObject.setCostSharingInfoArray(this.getCostSharingTypes(institutionalProposal));
        instituteProposalXmlObject.setScienceCodeArray(this.getScienceCodes(institutionalProposal));
        instituteProposalXmlObject.setSchoolInfo(this.getSchoolInfoType());
        IPDisclosureItemType[] disclosureItemTypes = this.getDisclosureItems(institutionalProposal);
        instituteProposalXmlObject.setDisclosureItemArray(disclosureItemTypes);
        instituteProposalXmlObject.setKeyPersonsArray(this.getKeyPersons(institutionalProposal));
        instituteProposalXmlObject.setCostSharingProjectPeriodFieldDescription(this.getProjectPeriodFieldDescription());
        instituteProposalXmlObject.setCFDANum(institutionalProposal.getCfdaNumber());
        instituteProposalXmlObject.setOpportunityID(institutionalProposal.getOpportunity());
        instituteProposalXmlObject.setOtherData(this.getCustomData(institutionalProposal));
        return instituteProposalXmlObject;
    }

    private String getProjectPeriodFieldDescription() {
        String retVal = ((CostShareService)KraServiceLocator.getService(CostShareService.class)).getCostShareLabel();
        return retVal;
    }

    private OtherGroupTypes getCustomData(InstitutionalProposal institutionalProposal) {
        CustomAttributeService customAttributeService = (CustomAttributeService)KraServiceLocator.getService(CustomAttributeService.class);
        Map customAttributeDocuments = customAttributeService.getDefaultCustomAttributeDocuments(institutionalProposal.getInstitutionalProposalDocument().getDocumentTypeCode(), institutionalProposal.getInstitutionalProposalCustomDataList());
        OtherGroupTypes otherGroup = OtherGroupTypes.Factory.newInstance();
        LinkedList<OtherGroupDetailsTypes> otherGroupDetailsTypesList = new LinkedList<OtherGroupDetailsTypes>();
        block0: for (Map.Entry customAttributeDocumentEntry : customAttributeDocuments.entrySet()) {
            OtherGroupDetailsTypes otherGroupDetails = OtherGroupDetailsTypes.Factory.newInstance();
            for (InstitutionalProposalCustomData custData : institutionalProposal.getInstitutionalProposalCustomDataList()) {
                if (custData.getCustomAttributeId() != (long)((CustomAttributeDocument)customAttributeDocumentEntry.getValue()).getCustomAttribute().getId().intValue() || !((CustomAttributeDocument)customAttributeDocuments.get(custData.getCustomAttributeId().toString())).getCustomAttribute().getGroupName().equalsIgnoreCase(((ParameterService)KraServiceLocator.getService(ParameterService.class)).getParameterValueAsString("KC-IP", "Document", "INSTITUTE_PROPOSAL_OTHER_GROUP"))) continue;
                otherGroup.setGroupName(((CustomAttributeDocument)customAttributeDocuments.get(custData.getCustomAttributeId().toString())).getCustomAttribute().getGroupName());
                otherGroupDetails.setColumnValue(custData.getValue());
                otherGroupDetails.setColumnName(((CustomAttributeDocument)customAttributeDocuments.get(custData.getCustomAttributeId().toString())).getCustomAttribute().getLabel());
                otherGroupDetailsTypesList.add(otherGroupDetails);
                continue block0;
            }
        }
        otherGroup.setOtherGroupDetailsArray(otherGroupDetailsTypesList.toArray(new OtherGroupDetailsTypes[0]));
        return otherGroup;
    }

    private IPKeyPersonType[] getKeyPersons(InstitutionalProposal institutionalProposal) {
        ArrayList keyPersonTypes = new ArrayList();
        IPKeyPersonType keyPersonType = null;
        for (InstitutionalProposalPerson proposalPerson : institutionalProposal.getProjectPersons()) {
            ContactRole role;
            KcPerson person;
            if (!proposalPerson.isPrincipalInvestigator() && !proposalPerson.isCoInvestigator() && !proposalPerson.isKeyPerson()) continue;
            keyPersonType = IPKeyPersonType.Factory.newInstance();
            if (institutionalProposal.getProposalNumber() != null) {
                keyPersonType.setProposalNumber(institutionalProposal.getProposalNumber());
            }
            if (proposalPerson.getPersonId() != null) {
                keyPersonType.setPersonId(proposalPerson.getPersonId());
            }
            if ((person = proposalPerson.getPerson()) != null && person.getFullName() != null) {
                keyPersonType.setPersonName(person.getFullName());
            }
            if ((role = proposalPerson.getContactRole()) != null && role.getRoleDescription() != null) {
                keyPersonType.setRoleName(role.getRoleDescription());
            }
            if (proposalPerson.getPerson().getAddressLine1() != null) {
                keyPersonType.setPersonAddress(proposalPerson.getPerson().getAddressLine1());
            }
            if (proposalPerson.getTotalEffort() != null) {
                keyPersonType.setPercentEffort(proposalPerson.getTotalEffort().bigDecimalValue());
            }
            keyPersonType.setFaculty(proposalPerson.isFaculty());
            if (proposalPerson.getRolodexId() == null) continue;
            keyPersonType.setNonEmployee(true);
        }
        return keyPersonTypes.toArray(new IPKeyPersonType[0]);
    }

    private InvestigatorType2[] getInvestigatorTypes(InstitutionalProposal institutionalProposal) {
        ArrayList<InvestigatorType2> investigatorTypesList = new ArrayList<InvestigatorType2>();
        InvestigatorType2 investigatorType = null;
        for (InstitutionalProposalPerson proposalPerson : institutionalProposal.getProjectPersons()) {
            if (!proposalPerson.isPrincipalInvestigator() && !proposalPerson.isCoInvestigator() && !proposalPerson.isKeyPerson()) continue;
            investigatorType = InvestigatorType2.Factory.newInstance();
            PersonType personType = PersonType.Factory.newInstance();
            if (proposalPerson.getPerson().getAddressLine1() != null) {
                personType.setAddress(proposalPerson.getPerson().getAddressLine1());
            }
            if (proposalPerson.getPerson().getCity() != null) {
                personType.setCity(proposalPerson.getPerson().getCity());
            }
            if (proposalPerson.getPerson().getFirstName() != null) {
                personType.setFirstName(proposalPerson.getPerson().getFirstName());
            }
            if (proposalPerson.getFullName() != null) {
                personType.setFullName(proposalPerson.getFullName());
            }
            if (proposalPerson.getPerson().getLastName() != null) {
                personType.setLastName(proposalPerson.getPerson().getLastName());
            }
            if (proposalPerson.getPerson().getMiddleName() != null) {
                personType.setMiddleName(proposalPerson.getPerson().getMiddleName());
            }
            if (proposalPerson.getPhoneNumber() != null) {
                personType.setPhone(proposalPerson.getPhoneNumber());
            }
            if (proposalPerson.getPerson().getState() != null) {
                personType.setState(proposalPerson.getPerson().getState());
            }
            if (proposalPerson.getPerson().getPostalCode() != null) {
                personType.setZip(proposalPerson.getPerson().getPostalCode());
            }
            investigatorType.setPIName(personType);
            investigatorType.setFacultyFlag(proposalPerson.isFaculty());
            investigatorType.setPrincipalInvFlag(proposalPerson.isPrincipalInvestigator());
            List unitTypes = this.getUnitTypes(proposalPerson);
            investigatorType.setUnitArray(unitTypes.toArray(new UnitType[0]));
            investigatorTypesList.add(investigatorType);
        }
        return investigatorTypesList.toArray(new InvestigatorType2[0]);
    }

    private List<UnitType> getUnitTypes(InstitutionalProposalPerson proposalPerson) {
        ArrayList<UnitType> unitTypes = new ArrayList<UnitType>();
        UnitType unitType = null;
        for (InstitutionalProposalPersonUnit proposalPersonUnit : proposalPerson.getUnits()) {
            unitType = UnitType.Factory.newInstance();
            unitType.setLeadUnitFlag(proposalPersonUnit.isLeadUnit());
            Unit unit = proposalPersonUnit.getUnit();
            if (unit != null) {
                if (unit.getUnitName() != null) {
                    unitType.setUnitName(unit.getUnitName());
                }
                if (unit.getUnitNumber() != null) {
                    unitType.setUnitNumber(unit.getUnitNumber());
                }
            }
            unitTypes.add(unitType);
        }
        return unitTypes;
    }

    private IPDisclosureItemType[] getDisclosureItems(InstitutionalProposal institutionalProposal) {
        ArrayList<IPDisclosureItemType> disclosureItemTypesList = new ArrayList<IPDisclosureItemType>();
        IPDisclosureItemType disclosureItemType = IPDisclosureItemType.Factory.newInstance();
        disclosureItemTypesList.add(disclosureItemType);
        return disclosureItemTypesList.toArray(new IPDisclosureItemType[0]);
    }

    private IPSchoolInfoType getSchoolInfoType() {
        IPSchoolInfoType schoolInfoType = IPSchoolInfoType.Factory.newInstance();
        String schoolName = this.getIPParameterValue(SCHOOL_NAME);
        String schoolAcronym = this.getIPParameterValue(SCHOOL_ACRONYM);
        if (schoolName != null) {
            schoolInfoType.setSchoolName(schoolName);
        }
        if (schoolAcronym != null) {
            schoolInfoType.setAcronym(schoolAcronym);
        }
        return schoolInfoType;
    }

    private ScienceCodeType[] getScienceCodes(InstitutionalProposal institutionalProposal) {
        ScienceCodeType scienceCodeType = null;
        ArrayList<ScienceCodeType> scienceCodeTypelist = new ArrayList<ScienceCodeType>();
        for (InstitutionalProposalScienceKeyword institutionalProposalScienceKeyword : institutionalProposal.getInstitutionalProposalScienceKeywords()) {
            scienceCodeType = ScienceCodeType.Factory.newInstance();
            if (institutionalProposalScienceKeyword.getScienceKeywordCode() != null) {
                scienceCodeType.setScienceCode(institutionalProposalScienceKeyword.getScienceKeywordCode());
            }
            if (institutionalProposalScienceKeyword.getScienceKeyword().getDescription() != null) {
                scienceCodeType.setScienceCodeDesc(institutionalProposalScienceKeyword.getScienceKeyword().getDescription());
            }
            scienceCodeTypelist.add(scienceCodeType);
        }
        return scienceCodeTypelist.toArray(new ScienceCodeType[0]);
    }

    private CostSharingType[] getCostSharingTypes(InstitutionalProposal institutionalProposal) {
        ArrayList<CostSharingType> costSharingTypes = new ArrayList<CostSharingType>();
        for (InstitutionalProposalCostShare institutionalProposalCostShare : institutionalProposal.getInstitutionalProposalCostShares()) {
            CostSharingType costSharingType = CostSharingType.Factory.newInstance();
            if (institutionalProposalCostShare.getAmount() != null) {
                costSharingType.setAmount(institutionalProposalCostShare.getAmount().doubleValue());
            }
            institutionalProposalCostShare.refreshReferenceObject("costShareType");
            if (institutionalProposalCostShare.getCostShareType() != null) {
                costSharingType.setCostSharingType(institutionalProposalCostShare.getCostShareTypeCode() + " - " + institutionalProposalCostShare.getCostShareType().getDescription());
            }
            if (institutionalProposalCostShare.getProjectPeriod() != null) {
                costSharingType.setFY(institutionalProposalCostShare.getProjectPeriod());
            }
            if (institutionalProposalCostShare.getSourceAccount() != null) {
                costSharingType.setSourceAccount(institutionalProposalCostShare.getSourceAccount());
            }
            if (institutionalProposalCostShare.getCostSharePercentage() != null) {
                costSharingType.setPercentage(institutionalProposalCostShare.getCostSharePercentage().doubleValue());
            }
            costSharingTypes.add(costSharingType);
        }
        return costSharingTypes.toArray(new CostSharingType[0]);
    }

    private SpecialReviewType2[] getSpecialReviewTypes(InstitutionalProposal institutionalProposal) {
        ArrayList<SpecialReviewType2> specialReviewTypes = new ArrayList<SpecialReviewType2>();
        SpecialReviewType2 specialReviewType = null;
        for (InstitutionalProposalSpecialReview institutionalProposalSpecialReview : institutionalProposal.getSpecialReviews()) {
            SpecialReviewType specialReview;
            specialReviewType = SpecialReviewType2.Factory.newInstance();
            Protocol protocol = null;
            String protocolNumber = institutionalProposalSpecialReview.getProtocolNumber();
            institutionalProposalSpecialReview.refreshNonUpdateableReferences();
            SpecialReviewApprovalType specialReviewApprovalType = institutionalProposalSpecialReview.getApprovalType();
            if (protocolNumber != null && (protocol = this.getProtocolInfo(protocolNumber)) != null) {
                specialReviewType.setProtocolNumber(protocolNumber);
                if (specialReviewApprovalType.getApprovalTypeCode() != null && specialReviewApprovalType.getApprovalTypeCode().equals(SPECIAL_REVIEW_APPROVAL_CODE)) {
                    specialReviewType.setSpecialReviewStatus(protocol.getDescription());
                } else if (specialReviewApprovalType != null) {
                    specialReviewType.setSpecialReviewStatus(specialReviewApprovalType.getDescription());
                }
                if (protocol.getSubmissionDate() != null) {
                    specialReviewType.setApplicationDate(this.dateTimeService.getCalendar((Date)protocol.getInitialSubmissionDate()));
                }
                if (protocol.getApprovalDate() != null) {
                    specialReviewType.setApprovalDate(this.dateTimeService.getCalendar((Date)protocol.getApprovalDate()));
                }
            } else {
                if (institutionalProposalSpecialReview.getApplicationDate() != null) {
                    specialReviewType.setApplicationDate(this.dateTimeService.getCalendar((Date)institutionalProposalSpecialReview.getApplicationDate()));
                }
                if (institutionalProposalSpecialReview.getApprovalDate() != null) {
                    specialReviewType.setApprovalDate(this.dateTimeService.getCalendar((Date)institutionalProposalSpecialReview.getApprovalDate()));
                }
                if (specialReviewApprovalType != null) {
                    specialReviewType.setSpecialReviewStatus(specialReviewApprovalType.getDescription());
                }
                specialReviewType.setProtocolNumber(institutionalProposalSpecialReview.getProtocolNumber());
            }
            if ((specialReview = institutionalProposalSpecialReview.getSpecialReviewType()) != null && specialReview.getDescription() != null) {
                specialReviewType.setSpecialReviewType(specialReview.getDescription());
            }
            if (institutionalProposalSpecialReview.getComments() != null) {
                specialReviewType.setComments(institutionalProposalSpecialReview.getComments());
            }
            specialReviewTypes.add(specialReviewType);
        }
        return specialReviewTypes.toArray(new SpecialReviewType2[0]);
    }

    private Protocol getProtocolInfo(String protocolNumber) {
        Protocol protocol = null;
        HashMap<String, String> protocolMap = new HashMap<String, String>();
        protocolMap.put(PROTOCOL_NUMBER, String.valueOf(protocolNumber));
        List protocolList = (List)this.businessObjectService.findMatching(Protocol.class, protocolMap);
        if (protocolList != null && !protocolList.isEmpty()) {
            protocol = (Protocol)protocolList.get(0);
        }
        return protocol;
    }

    private IDCRateType[] getIdcRateTypes(InstitutionalProposal institutionalProposal) {
        ArrayList<IDCRateType> idcRateTypes = new ArrayList<IDCRateType>();
        IDCRateType idcRateType = null;
        for (InstitutionalProposalUnrecoveredFandA institutionalProposalUnrecoveredFandA : institutionalProposal.getInstitutionalProposalUnrecoveredFandAs()) {
            idcRateType = IDCRateType.Factory.newInstance();
            if (institutionalProposalUnrecoveredFandA.getFiscalYear() != null) {
                idcRateType.setFY(institutionalProposalUnrecoveredFandA.getFiscalYear());
            }
            idcRateType.setOnCampus(institutionalProposalUnrecoveredFandA.getOnCampusFlag());
            if (institutionalProposalUnrecoveredFandA.getSourceAccount() != null) {
                idcRateType.setSourceAccount(institutionalProposalUnrecoveredFandA.getSourceAccount());
            }
            if (institutionalProposalUnrecoveredFandA.getUnderrecoveryOfIndirectcost() != null) {
                idcRateType.setUnderRecovery(institutionalProposalUnrecoveredFandA.getUnderrecoveryOfIndirectcost().doubleValue());
            }
            institutionalProposalUnrecoveredFandA.refreshReferenceObject("indirectcostRateType");
            if (institutionalProposalUnrecoveredFandA.getIndirectcostRateType() != null) {
                idcRateType.setRateType(institutionalProposalUnrecoveredFandA.getIndirectcostRateTypeCode() + " - " + institutionalProposalUnrecoveredFandA.getIndirectcostRateType().getDescription());
            }
            if (institutionalProposalUnrecoveredFandA.getApplicableIndirectcostRate() != null) {
                idcRateType.setRate(institutionalProposalUnrecoveredFandA.getApplicableIndirectcostRate().doubleValue());
            }
            idcRateTypes.add(idcRateType);
        }
        return idcRateTypes.toArray(new IDCRateType[0]);
    }

    private MailingInfoType getMailingInfoType(InstitutionalProposal institutionalProposal) {
        Rolodex rolodex;
        MailingInfoType mailingInfoType = MailingInfoType.Factory.newInstance();
        if (institutionalProposal.getDeadlineDate() != null) {
            mailingInfoType.setDeadlineDate(this.dateTimeService.getCalendar((Date)institutionalProposal.getDeadlineDate()));
        }
        mailingInfoType.setDeadlineType(institutionalProposal.getDeadlineType());
        mailingInfoType.setMailByOSP(institutionalProposal.getMailBy());
        mailingInfoType.setMailType(institutionalProposal.getMailType());
        if (institutionalProposal.getMailAccountNumber() != null) {
            mailingInfoType.setMailAccount(institutionalProposal.getMailAccountNumber());
        }
        if (institutionalProposal.getNumberOfCopies() != null) {
            mailingInfoType.setNumberCopies(Integer.valueOf(institutionalProposal.getNumberOfCopies()).intValue());
        }
        if ((rolodex = institutionalProposal.getRolodex()) != null) {
            PersonType personType = PersonType.Factory.newInstance();
            if (rolodex.getFirstName() != null) {
                personType.setFirstName(rolodex.getFirstName());
            }
            if (rolodex.getLastName() != null) {
                personType.setLastName(rolodex.getLastName());
            }
            if (rolodex.getCity() != null) {
                personType.setCity(rolodex.getCity());
            }
            if (rolodex.getMiddleName() != null) {
                personType.setMiddleName(rolodex.getMiddleName());
            }
            if (rolodex.getPhoneNumber() != null) {
                personType.setPhone(rolodex.getPhoneNumber());
            }
            if (rolodex.getState() != null) {
                personType.setState(rolodex.getState());
            }
            if (rolodex.getFullName() != null) {
                personType.setFullName(rolodex.getFullName());
            }
            if (rolodex.getPostalCode() != null) {
                personType.setZip(rolodex.getPostalCode());
            }
            if (rolodex.getAddressLine1() != null) {
                personType.setAddress(rolodex.getAddressLine1());
            }
            mailingInfoType.setMailToPerson(personType);
        }
        if (institutionalProposal.getProposalComments() != null && institutionalProposal.getDeliveryComment().getComments() != null) {
            mailingInfoType.setComments(institutionalProposal.getDeliveryComment().getComments());
        }
        return mailingInfoType;
    }

    private BudgetDataType getBudgetDataType(InstitutionalProposal institutionalProposal) {
        BudgetDataType budgetDataType = BudgetDataType.Factory.newInstance();
        budgetDataType.setAccountType(String.valueOf(institutionalProposal.getTypeOfAccount()));
        if (institutionalProposal.getRequestedStartDateInitial() != null) {
            budgetDataType.setRequestedStartDateInitial(this.dateTimeService.getCalendar((Date)institutionalProposal.getRequestedStartDateInitial()));
        }
        if (institutionalProposal.getRequestedEndDateInitial() != null) {
            budgetDataType.setRequestedEndDateInitial(this.dateTimeService.getCalendar((Date)institutionalProposal.getRequestedEndDateInitial()));
        }
        if (institutionalProposal.getRequestedStartDateTotal() != null) {
            budgetDataType.setRequestedStartDateTotal(this.dateTimeService.getCalendar((Date)institutionalProposal.getRequestedStartDateTotal()));
        }
        if (institutionalProposal.getRequestedEndDateTotal() != null) {
            budgetDataType.setRequestedEndDateTotal(this.dateTimeService.getCalendar((Date)institutionalProposal.getRequestedEndDateTotal()));
        }
        if (institutionalProposal.getTotalDirectCostInitial() != null) {
            budgetDataType.setTotalDirectCostInitial(institutionalProposal.getTotalDirectCostInitial().bigDecimalValue());
        }
        if (institutionalProposal.getTotalDirectCostTotal() != null) {
            budgetDataType.setTotalDirectCostTotal(institutionalProposal.getTotalDirectCostTotal().bigDecimalValue());
        }
        if (institutionalProposal.getTotalIndirectCostInitial() != null) {
            budgetDataType.setTotalIndirectCostInitial(institutionalProposal.getTotalIndirectCostInitial().bigDecimalValue());
        }
        if (institutionalProposal.getTotalIndirectCostTotal() != null) {
            budgetDataType.setTotalIndirectCostTotal(institutionalProposal.getTotalIndirectCostTotal().bigDecimalValue());
        }
        if (institutionalProposal.getTotalInitialCost() != null) {
            budgetDataType.setTotalCostInitial(institutionalProposal.getTotalInitialCost().bigDecimalValue());
        }
        if (institutionalProposal.getTotalCost() != null) {
            budgetDataType.setTotalCostTotal(institutionalProposal.getTotalCost().bigDecimalValue());
        }
        return budgetDataType;
    }

    private InstProposalMasterData getInstProposalMasterData(InstitutionalProposal institutionalProposal) {
        InstProposalMasterData instProposalMasterData = InstProposalMasterData.Factory.newInstance();
        instProposalMasterData.setProposalNumber(institutionalProposal.getProposalNumber());
        if (institutionalProposal.getCurrentAccountNumber() != null) {
            instProposalMasterData.setAccountNumber(institutionalProposal.getCurrentAccountNumber());
        }
        if (institutionalProposal.getCurrentAwardNumber() != null) {
            instProposalMasterData.setAwardNumber(institutionalProposal.getCurrentAwardNumber());
        }
        this.setProposalStatus(institutionalProposal, instProposalMasterData);
        this.setProposalType(institutionalProposal, instProposalMasterData);
        instProposalMasterData.setTitle(institutionalProposal.getTitle());
        this.setActivityType(institutionalProposal, instProposalMasterData);
        if (institutionalProposal.getSponsorProposalNumber() != null) {
            instProposalMasterData.setSponsorProposalNumber(institutionalProposal.getSponsorProposalNumber());
        }
        this.setNoticeOfOpportunity(institutionalProposal, instProposalMasterData);
        this.setNSFCode(institutionalProposal, instProposalMasterData);
        this.setSponsor(institutionalProposal, instProposalMasterData);
        this.setPrimeSponsor(institutionalProposal, instProposalMasterData);
        instProposalMasterData.setHasSubcontracts(institutionalProposal.getSubcontractFlag());
        if (institutionalProposal.getGradStudHeadcount() != null) {
            instProposalMasterData.setGradStudentCount(institutionalProposal.getGradStudHeadcount().intValue());
        }
        if (institutionalProposal.getGradStudPersonMonths() != null) {
            instProposalMasterData.setGradStudentmonths(institutionalProposal.getGradStudPersonMonths().doubleValue());
        }
        instProposalMasterData.setAccountType(String.valueOf(institutionalProposal.getTypeOfAccount()));
        if (institutionalProposal.getSequenceNumber() != null) {
            instProposalMasterData.setSequenceNumber(institutionalProposal.getSequenceNumber().intValue());
        }
        this.setComments(institutionalProposal, instProposalMasterData);
        this.setAnticipatedAwardType(institutionalProposal, instProposalMasterData);
        return instProposalMasterData;
    }

    private void setAnticipatedAwardType(InstitutionalProposal institutionalProposal, InstProposalMasterData instProposalMasterData) {
        AwardType awardType;
        AnticipatedAwardType anticipatedAwardType = AnticipatedAwardType.Factory.newInstance();
        if (institutionalProposal.getAwardTypeCode() != null) {
            anticipatedAwardType.setAnticipatedAwardTypeCode(institutionalProposal.getAwardTypeCode().intValue());
        }
        if ((awardType = institutionalProposal.getAwardType()) != null && awardType.getDescription() != null) {
            anticipatedAwardType.setAnticipatedAwardTypeDesc(awardType.getDescription());
        }
        instProposalMasterData.setAnticipatedAwardType(anticipatedAwardType);
    }

    private void setComments(InstitutionalProposal institutionalProposal, InstProposalMasterData instProposalMasterData) {
        InstitutionalProposalComment institutionalProposalComments;
        if (institutionalProposal.getProposalComments() != null && (institutionalProposalComments = institutionalProposal.getSummaryComment()) != null && institutionalProposalComments.getCommentTypeCode().equals(PROPOSAL_SUMMARY_COMMENT_CODE)) {
            instProposalMasterData.setComments(institutionalProposalComments.getComments());
        }
    }

    private void setPrimeSponsor(InstitutionalProposal institutionalProposal, InstProposalMasterData instProposalMasterData) {
        if (institutionalProposal.getPrimeSponsorCode() != null) {
            IPsponsorType primeSponsorType = IPsponsorType.Factory.newInstance();
            String primeSponsorCode = institutionalProposal.getPrimeSponsorCode();
            primeSponsorType.setSponsorCode(primeSponsorCode);
            String primeSponsorName = this.getPrimeSponsorName(primeSponsorCode);
            if (primeSponsorName != null) {
                primeSponsorType.setSponsorName(primeSponsorName);
            }
            instProposalMasterData.setPrimeSponsor(primeSponsorType);
        }
    }

    private void setSponsor(InstitutionalProposal institutionalProposal, InstProposalMasterData instProposalMasterData) {
        if (institutionalProposal.getSponsor() != null) {
            Sponsor sponsor = institutionalProposal.getSponsor();
            IPsponsorType sponsorType = IPsponsorType.Factory.newInstance();
            if (sponsor.getSponsorCode() != null) {
                sponsorType.setSponsorCode(sponsor.getSponsorCode());
            }
            if (sponsor.getSponsorName() != null) {
                sponsorType.setSponsorName(sponsor.getSponsorName());
            }
            instProposalMasterData.setSponsor(sponsorType);
        }
    }

    private void setNSFCode(InstitutionalProposal institutionalProposal, InstProposalMasterData instProposalMasterData) {
        if (institutionalProposal.getNsfCode() != null) {
            NSFcodeType nsfCodeType = NSFcodeType.Factory.newInstance();
            String nsfCode = institutionalProposal.getNsfCode();
            nsfCodeType.setNSFcode(nsfCode);
            String nsfDesc = this.getNsfDesc(nsfCode);
            if (nsfDesc != null) {
                nsfCodeType.setNSFcodeDesc(nsfDesc);
            }
            instProposalMasterData.setNSFcode(nsfCodeType);
        }
    }

    private void setNoticeOfOpportunity(InstitutionalProposal institutionalProposal, InstProposalMasterData instProposalMasterData) {
        if (institutionalProposal.getNoticeOfOpportunityCode() != null) {
            NoticeOfOppType noticeOfOppType = NoticeOfOppType.Factory.newInstance();
            String noticeOfOpportunityCode = institutionalProposal.getNoticeOfOpportunityCode();
            noticeOfOppType.setNoticeOfOppcode(noticeOfOpportunityCode);
            String noticeOfOpportunityDesc = this.getNoticeOfOpportunityDesc(noticeOfOpportunityCode);
            if (noticeOfOpportunityDesc != null) {
                noticeOfOppType.setNoticeOfOppDesc(noticeOfOpportunityDesc);
            }
            instProposalMasterData.setNoticeOfOpportunity(noticeOfOppType);
        }
    }

    private void setActivityType(InstitutionalProposal institutionalProposal, InstProposalMasterData instProposalMasterData) {
        if (institutionalProposal.getActivityType() != null) {
            ActivityType activityType = institutionalProposal.getActivityType();
            noNamespace.ActivityType activityTypeXmlObject = ActivityType.Factory.newInstance();
            if (activityType.getActivityTypeCode() != null) {
                activityTypeXmlObject.setActivityTypeCode(Integer.valueOf(activityType.getActivityTypeCode()).intValue());
            }
            if (activityType.getDescription() != null) {
                activityTypeXmlObject.setActivityTypeDesc(activityType.getDescription());
            }
            instProposalMasterData.setActivityType(activityTypeXmlObject);
        }
    }

    private void setProposalType(InstitutionalProposal institutionalProposal, InstProposalMasterData instProposalMasterData) {
        if (institutionalProposal.getProposalTypeCode() != null) {
            ProposalType proposalType = ProposalType.Factory.newInstance();
            int proposalTypeCode = institutionalProposal.getProposalTypeCode();
            proposalType.setProposalTypeCode(proposalTypeCode);
            String proposalTypeDescription = this.getProposalTypeDescription(proposalTypeCode);
            if (proposalTypeDescription != null) {
                proposalType.setProposalTypeDesc(proposalTypeDescription);
            }
            instProposalMasterData.setProposalType(proposalType);
        }
    }

    private void setProposalStatus(InstitutionalProposal institutionalProposal, InstProposalMasterData instProposalMasterData) {
        if (institutionalProposal.getStatusCode() != null) {
            ProposalStatusType proposalStatusType = ProposalStatusType.Factory.newInstance();
            int proposalStatusCode = institutionalProposal.getStatusCode();
            proposalStatusType.setStatusCode(proposalStatusCode);
            String proposalDescription = this.getProposalDescription(proposalStatusCode);
            if (proposalDescription != null) {
                proposalStatusType.setStatusDesc(proposalDescription);
            }
            instProposalMasterData.setProposalStatus(proposalStatusType);
        }
    }

    private String getPrimeSponsorName(String primeSponsorCode) {
        String primeSponsorName = null;
        HashMap<String, String> sponsorMap = new HashMap<String, String>();
        sponsorMap.put(SPONSOR_CODE, primeSponsorCode);
        List sponsorList = (List)this.businessObjectService.findMatching(Sponsor.class, sponsorMap);
        if (sponsorList != null && !sponsorList.isEmpty()) {
            Sponsor sponsor = (Sponsor)sponsorList.get(0);
            primeSponsorName = sponsor.getSponsorName();
        }
        return primeSponsorName;
    }

    private String getNsfDesc(String nsfCode) {
        String nsfDesc = null;
        HashMap<String, String> nsfCodeMap = new HashMap<String, String>();
        nsfCodeMap.put(NSF_CODE, nsfCode);
        List nsfCodeTypeList = (List)this.businessObjectService.findMatching(NsfCode.class, nsfCodeMap);
        if (nsfCodeTypeList != null && !nsfCodeTypeList.isEmpty()) {
            NsfCode noticeOfOpportunity = (NsfCode)nsfCodeTypeList.get(0);
            nsfDesc = noticeOfOpportunity.getDescription();
        }
        return nsfDesc;
    }

    private String getNoticeOfOpportunityDesc(String noticeOfOpportunityCode) {
        String noticeOfOpportunityDesc = null;
        HashMap<String, String> noticeOfOppMap = new HashMap<String, String>();
        noticeOfOppMap.put(NOTICE_OF_OPPORTUNITY_CODE, noticeOfOpportunityCode);
        List noticeOfOppList = (List)this.businessObjectService.findMatching(NoticeOfOpportunity.class, noticeOfOppMap);
        if (noticeOfOppList != null && !noticeOfOppList.isEmpty()) {
            NoticeOfOpportunity noticeOfOpportunity = (NoticeOfOpportunity)noticeOfOppList.get(0);
            noticeOfOpportunityDesc = noticeOfOpportunity.getDescription();
        }
        return noticeOfOpportunityDesc;
    }

    private String getProposalTypeDescription(int proposalTypeCode) {
        String proposalTypeDescription = null;
        HashMap<String, String> proposalTypeDescMap = new HashMap<String, String>();
        proposalTypeDescMap.put(PROPOSAL_TYPE_CODE, String.valueOf(proposalTypeCode));
        List proposalTypeList = null;
        proposalTypeList = (List)this.businessObjectService.findMatching(org.kuali.kra.proposaldevelopment.bo.ProposalType.class, proposalTypeDescMap);
        if (proposalTypeList != null && !proposalTypeList.isEmpty()) {
            org.kuali.kra.proposaldevelopment.bo.ProposalType proposalType = (org.kuali.kra.proposaldevelopment.bo.ProposalType)proposalTypeList.get(0);
            proposalTypeDescription = proposalType.getDescription();
        }
        return proposalTypeDescription;
    }

    private String getProposalDescription(int proposalStatusCode) {
        String proposalDescription = null;
        HashMap<String, String> proposalStatusMap = new HashMap<String, String>();
        proposalStatusMap.put(PROPOSAL_STATUS_CODE, String.valueOf(proposalStatusCode));
        List proposalStatusList = (List)this.businessObjectService.findMatching(ProposalStatus.class, proposalStatusMap);
        if (proposalStatusList != null && !proposalStatusList.isEmpty()) {
            ProposalStatus proposalStatus = (ProposalStatus)proposalStatusList.get(0);
            proposalDescription = proposalStatus.getDescription();
        }
        return proposalDescription;
    }

    public InstitutionalProposalPersonService getInstitutionalProposalPersonService() {
        return this.institutionalProposalPersonService;
    }

    public void setInstitutionalProposalPersonService(InstitutionalProposalPersonService institutionalProposalPersonService) {
        this.institutionalProposalPersonService = institutionalProposalPersonService;
    }

    private String getIPParameterValue(String param) {
        String value = null;
        try {
            value = PrintingUtils.getParameterValue((String)param);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }
}

