/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.proposallog;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLogStatus;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLogType;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLogUtils;
import org.kuali.kra.institutionalproposal.proposallog.service.ProposalLogService;
import org.kuali.kra.negotiations.bo.Negotiable;
import org.kuali.kra.negotiations.bo.NegotiationPersonDTO;
import org.kuali.kra.proposaldevelopment.bo.ProposalType;
import org.kuali.kra.service.KcPersonService;

public class ProposalLog
extends KraPersistableBusinessObjectBase
implements Negotiable {
    static final String LOG_STATUS = "logStatus";
    static final String PROPOSAL_LOG_TYPE_CODE = "proposalLogTypeCode";
    private static final long serialVersionUID = 1L;
    private String proposalNumber;
    private String proposalTypeCode;
    private String title;
    private String piId;
    private Integer rolodexId;
    private String piName;
    private String leadUnit;
    private String sponsorCode;
    private String sponsorName;
    private String logStatus;
    private String comments;
    private Date deadlineDate;
    private String deadlineTime;
    private String proposalLogTypeCode;
    private Integer fiscalMonth;
    private Integer fiscalYear;
    private String createUser;
    private Timestamp createTimestamp;
    private ProposalType proposalType;
    private NonOrganizationalRolodex rolodex;
    private Sponsor sponsor;
    private ProposalLogStatus proposalLogStatus;
    private Unit unit;
    private ProposalLogType proposalLogType;
    private String mergedWith;
    private ProposalLog mergedWithProposal;
    private String instProposalNumber;
    private transient KcPersonService kcPersonService;

    public boolean isPersisted() {
        return this.getVersionNumber() != null;
    }

    public boolean isSubmitted() {
        return ProposalLogUtils.getProposalLogSubmittedStatusCode().equals(this.getLogStatus());
    }

    public boolean isLogTypeTemporary() {
        return ProposalLogUtils.getProposalLogTemporaryTypeCode().equals(this.getProposalLogTypeCode());
    }

    public boolean isMergeCandidate() {
        return ProposalLogUtils.getProposalLogTemporaryTypeCode().equals(this.getProposalLogTypeCode()) && !ProposalLogUtils.getProposalLogMergedStatusCode().equals(this.getLogStatus());
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getProposalTypeCode() {
        return this.proposalTypeCode;
    }

    public void setProposalTypeCode(String proposalTypeCode) {
        this.proposalTypeCode = proposalTypeCode;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPiId() {
        return this.piId;
    }

    public void setPiId(String piId) {
        this.piId = piId;
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public String getPiName() {
        return this.piName;
    }

    public void setPiName(String piName) {
        this.piName = piName;
    }

    public String getLeadUnit() {
        return this.leadUnit;
    }

    public void setLeadUnit(String leadUnit) {
        this.leadUnit = leadUnit;
    }

    public String getSponsorCode() {
        return this.sponsorCode;
    }

    public void setSponsorCode(String sponsorCode) {
        this.sponsorCode = sponsorCode;
        if (!this.isEmpty(sponsorCode)) {
            this.setSponsorName();
        }
    }

    public String getSponsorName() {
        return this.sponsorName;
    }

    public void setSponsorName(String sponsorName) {
        this.sponsorName = sponsorName;
    }

    public String getLogStatus() {
        return this.logStatus;
    }

    public void setLogStatus(String logStatus) {
        this.logStatus = logStatus;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Date getDeadlineDate() {
        return this.deadlineDate;
    }

    public void setDeadlineDate(Date deadlineDate) {
        this.deadlineDate = deadlineDate;
    }

    public String getDeadlineTime() {
        return this.deadlineTime;
    }

    public void setDeadlineTime(String deadlineTime) {
        this.deadlineTime = deadlineTime;
    }

    public String getProposalLogTypeCode() {
        return this.proposalLogTypeCode;
    }

    public void setProposalLogTypeCode(String proposalLogTypeCode) {
        this.proposalLogTypeCode = proposalLogTypeCode;
    }

    public ProposalType getProposalType() {
        return this.proposalType;
    }

    public void setProposalType(ProposalType proposalType) {
        this.proposalType = proposalType;
    }

    public KcPerson getPerson() {
        if (this.piId != null) {
            return this.getKcPersonService().getKcPersonByPersonId(this.piId);
        }
        return new KcPerson();
    }

    public NonOrganizationalRolodex getRolodex() {
        return this.rolodex;
    }

    public void setRolodex(NonOrganizationalRolodex rolodex) {
        this.rolodex = rolodex;
    }

    public Sponsor getSponsor() {
        return this.sponsor;
    }

    public void setSponsor(Sponsor sponsor) {
        this.sponsor = sponsor;
    }

    public ProposalLogStatus getProposalLogStatus() {
        return this.proposalLogStatus;
    }

    public void setProposalLogStatus(ProposalLogStatus proposalLogStatus) {
        this.proposalLogStatus = proposalLogStatus;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public ProposalLogType getProposalLogType() {
        return this.proposalLogType;
    }

    public void setProposalLogType(ProposalLogType proposalLogType) {
        this.proposalLogType = proposalLogType;
    }

    public Integer getFiscalMonth() {
        return this.fiscalMonth;
    }

    public void setFiscalMonth(Integer fiscalMonth) {
        this.fiscalMonth = fiscalMonth;
    }

    public Integer getFiscalYear() {
        return this.fiscalYear;
    }

    public void setFiscalYear(Integer fiscalYear) {
        this.fiscalYear = fiscalYear;
    }

    public String getFiscalMonthYear() {
        if (this.getFiscalMonth() != null && this.getFiscalYear() != null) {
            return this.getFiscalMonth().toString() + " / " + this.getFiscalYear().toString();
        }
        return "";
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Timestamp getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(Timestamp createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public String getMergedWith() {
        return this.mergedWith;
    }

    public void setMergedWith(String mergedWith) {
        this.mergedWith = mergedWith;
    }

    public String getInstProposalNumber() {
        return this.instProposalNumber;
    }

    public void setInstProposalNumber(String instProposalNumber) {
        this.instProposalNumber = instProposalNumber;
    }

    protected void prePersist() {
        super.prePersist();
        this.setSponsorName();
        this.mergeTemporaryLog();
    }

    protected void preUpdate() {
        super.preUpdate();
        this.setSponsorName();
    }

    private void setSponsorName() {
        if (!this.isEmpty(this.getSponsorCode())) {
            this.refreshReferenceObject("sponsor");
            this.sponsorName = this.getSponsor() != null ? this.getSponsor().getSponsorName() : null;
        }
    }

    private void mergeTemporaryLog() {
        if (StringUtils.isNotBlank((String)this.getMergedWith()) && StringUtils.equals((String)this.getProposalLogTypeCode(), (String)ProposalLogUtils.getProposalLogPermanentTypeCode())) {
            ((ProposalLogService)KraServiceLocator.getService(ProposalLogService.class)).mergeProposalLog(this, this.getMergedWith());
        }
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public String getLeadUnitNumber() {
        this.refreshReferenceObject("unit");
        String number = this.getUnit() == null ? "" : this.getUnit().getUnitNumber();
        return number;
    }

    public String getLeadUnitName() {
        this.refreshReferenceObject("unit");
        String name = this.getUnit() == null ? "" : this.getUnit().getUnitName();
        return name;
    }

    public String getPiEmployeeName() {
        String name = this.getPerson() == null ? "" : this.getPerson().getFullName();
        return name;
    }

    public String getPiNonEmployeeName() {
        String name = this.getRolodex() == null ? "" : this.getRolodex().getFullName();
        return name;
    }

    public String getAdminPersonName() {
        return "";
    }

    public String getPrimeSponsorCode() {
        return "";
    }

    public String getPrimeSponsorName() {
        return "";
    }

    public String getSponsorAwardNumber() {
        return "";
    }

    public String getSubAwardOrganizationName() {
        return "";
    }

    public List<NegotiationPersonDTO> getProjectPeople() {
        ArrayList<NegotiationPersonDTO> kcPeople = new ArrayList<NegotiationPersonDTO>();
        if (this.getPerson() != null) {
            kcPeople.add(new NegotiationPersonDTO(this.getPerson(), "PI"));
        }
        return kcPeople;
    }

    public String getAssociatedDocumentId() {
        return this.getProposalNumber();
    }

    public String getNegotiableProposalTypeCode() {
        return this.getProposalTypeCode();
    }

    public ProposalType getNegotiableProposalType() {
        return this.getProposalType();
    }

    public String getSubAwardRequisitionerName() {
        return "";
    }

    public String getSubAwardRequisitionerUnitNumber() {
        return "";
    }

    public String getSubAwardRequisitionerUnitName() {
        return "";
    }

    public String getSubAwardRequisitionerId() {
        return "";
    }

    public ProposalLog getMergedWithProposal() {
        return this.mergedWithProposal;
    }

    public void setMergedWithProposal(ProposalLog mergedWithProposal) {
        this.mergedWithProposal = mergedWithProposal;
    }
}

