/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.proposallog.printing;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import noNamespace.ProposalLogDocument;
import noNamespace.ProposalLogLeadUnit;
import noNamespace.ProposalLogPrincipalInvestigator;
import noNamespace.ProposalLogProposalType;
import noNamespace.ProposalLogSponsor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLog;
import org.kuali.kra.printing.xmlstream.XmlStream;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProposalLogXmlStream
implements XmlStream {
    private static final Log LOG = LogFactory.getLog(ProposalLogXmlStream.class);
    private DateTimeService dateTimeService;
    private BusinessObjectService businessObjectService = null;

    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, XmlObject> xmlObjectList = new LinkedHashMap<String, XmlObject>();
        ProposalLog proposalLog = (ProposalLog)reportParameters.get("proposalLogToPrint");
        proposalLog.refreshNonUpdateableReferences();
        ProposalLogDocument proposalLogDocument = ProposalLogDocument.Factory.newInstance();
        ProposalLogDocument.ProposalLog printProposalLog = ProposalLogDocument.ProposalLog.Factory.newInstance();
        printProposalLog.setProposalNumber(proposalLog.getProposalNumber());
        printProposalLog.setProposalTitle(proposalLog.getTitle());
        printProposalLog.setStatus(proposalLog.getProposalLogStatus().getDescription());
        printProposalLog.setComments(proposalLog.getComments());
        printProposalLog.setUpdateUser(proposalLog.getUpdateUser());
        printProposalLog.setUpdateTimeStamp(this.dateTimeService.toDateString((Date)proposalLog.getUpdateTimestamp()));
        printProposalLog.setPI(this.getPrincipalInvestigator(proposalLog));
        ProposalLogLeadUnit unit = ProposalLogLeadUnit.Factory.newInstance();
        unit.setUnitNumber(proposalLog.getLeadUnit());
        if (proposalLog.getUnit() != null) {
            unit.setUnitName(proposalLog.getUnit().getUnitName());
        }
        printProposalLog.setLeadUnit(unit);
        ProposalLogSponsor sponsor = ProposalLogSponsor.Factory.newInstance();
        sponsor.setSponsorCode(proposalLog.getSponsorCode());
        sponsor.setSponsorName(proposalLog.getSponsorName());
        printProposalLog.setSponsor(sponsor);
        ProposalLogProposalType type = ProposalLogProposalType.Factory.newInstance();
        type.setProposalTypeCode(proposalLog.getProposalTypeCode());
        if (proposalLog.getProposalType() != null) {
            type.setProposalTypeDesc(proposalLog.getProposalType().getDescription());
        }
        printProposalLog.setProposalType(type);
        proposalLogDocument.setProposalLog(printProposalLog);
        xmlObjectList.put("proposalLog", (XmlObject)proposalLogDocument);
        return xmlObjectList;
    }

    private ProposalLogPrincipalInvestigator getPrincipalInvestigator(ProposalLog proposalLog) {
        ProposalLogPrincipalInvestigator pi = ProposalLogPrincipalInvestigator.Factory.newInstance();
        KcPerson person = proposalLog.getPerson();
        pi.setFirstName(person.getFirstName());
        pi.setMiddleName(person.getMiddleName());
        pi.setLastName(person.getLastName());
        pi.setFullName(person.getFullName());
        pi.setPersonID(person.getPersonId());
        return pi;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

