/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.rules;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.CostShareType;
import org.kuali.kra.costshare.CostShareRuleResearchDocumentBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCostShare;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalAddCostShareRule;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalAddCostShareRuleEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.service.BusinessObjectService;

public class InstitutionalProposalAddCostShareRuleImpl
extends CostShareRuleResearchDocumentBase
implements InstitutionalProposalAddCostShareRule {
    private InstitutionalProposalCostShare institutionalProposalCostShare;
    private String fieldStarter = "";
    private boolean displayNullFieldErrors = true;

    public boolean processAddInstitutionalProposalCostShareBusinessRules(InstitutionalProposalAddCostShareRuleEvent institutionalProposalAddCostShareRuleEvent) {
        this.fieldStarter = "institutionalProposalCostShareBean.newInstitutionalProposalCostShare";
        this.displayNullFieldErrors = true;
        return this.proccessRules(institutionalProposalAddCostShareRuleEvent);
    }

    public boolean processInstitutionalProposalCostShareBusinessRules(InstitutionalProposalAddCostShareRuleEvent institutionalProposalAddCostShareRuleEvent, int i) {
        this.fieldStarter = "document.institutionalProposalList[0].institutionalProposalCostShares[" + i + "]";
        this.displayNullFieldErrors = false;
        return this.proccessRules(institutionalProposalAddCostShareRuleEvent);
    }

    private boolean proccessRules(InstitutionalProposalAddCostShareRuleEvent institutionalProposalAddCostShareRuleEvent) {
        this.institutionalProposalCostShare = institutionalProposalAddCostShareRuleEvent.getCostShareForValidation();
        boolean isValid = this.processCommonValidations(this.institutionalProposalCostShare);
        isValid &= this.validatePercentage(this.institutionalProposalCostShare.getCostSharePercentage());
        isValid &= this.validateCostShareType(this.institutionalProposalCostShare.getCostShareTypeCode());
        isValid &= this.validateAmount(this.institutionalProposalCostShare.getAmount());
        return isValid &= this.validateSourceAccount(this.institutionalProposalCostShare.getSourceAccount());
    }

    public boolean processCommonValidations(InstitutionalProposalCostShare institutionalProposalCostShare) {
        boolean validFiscalYearRange = this.validateCostShareFiscalYearRange(institutionalProposalCostShare);
        return validFiscalYearRange;
    }

    public boolean validateCostShareFiscalYearRange(InstitutionalProposalCostShare institutionalProposalCostShare) {
        String projectPeriodField = this.fieldStarter + ".projectPeriod";
        return this.validateProjectPeriod((Object)institutionalProposalCostShare.getProjectPeriod(), projectPeriodField);
    }

    private boolean validatePercentage(KualiDecimal percentage) {
        boolean isValid = true;
        String costSharePercentageField = this.fieldStarter + ".costSharePercentage";
        if (percentage != null && percentage.isLessThan((AbstractKualiDecimal)new KualiDecimal(0))) {
            isValid = false;
            this.reportError(costSharePercentageField, "error.awardCostShare.percentage.range", new String[0]);
        }
        return isValid;
    }

    private boolean validateCostShareType(Integer costShareTypeCode) {
        boolean isValid = true;
        String costShareTypeCodeField = this.fieldStarter + ".costShareTypeCode";
        if (costShareTypeCode == null) {
            isValid = false;
            if (this.displayNullFieldErrors) {
                this.reportError(costShareTypeCodeField, "error.institutionalProposalCostShare.costShareTypeCode.required", new String[0]);
            }
        } else {
            BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
            HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
            fieldValues.put("costShareTypeCode", costShareTypeCode);
            if (businessObjectService.countMatching(CostShareType.class, fieldValues) != 1) {
                isValid = false;
                this.reportError(costShareTypeCodeField, "error.institutionalProposalCostShare.costShareTypeCode.invalid", new String[]{costShareTypeCode.toString()});
            }
        }
        return isValid;
    }

    private boolean validateAmount(KualiDecimal commitmentAmount) {
        boolean isValid = true;
        String commitmentAmountField = this.fieldStarter + ".amount";
        if (commitmentAmount == null) {
            isValid = false;
            if (this.displayNullFieldErrors) {
                this.reportError(commitmentAmountField, "error.institutionalProposalCostShare.amount.required", new String[0]);
            }
        } else if (commitmentAmount.isLessThan((AbstractKualiDecimal)new KualiDecimal(0))) {
            isValid = false;
            this.reportError(commitmentAmountField, "error.institutionalProposalCostShare.amount.invalid", new String[]{commitmentAmount.toString()});
        }
        return isValid;
    }

    private boolean validateSourceAccount(String sourceAccount) {
        boolean isValid = true;
        String sourceAccountField = this.fieldStarter + ".sourceAccount";
        if (StringUtils.isEmpty((String)sourceAccount)) {
            isValid = false;
            if (this.displayNullFieldErrors) {
                this.reportError(sourceAccountField, "error.institutionalProposalCostShare.sourceAccount.required", new String[0]);
            }
        }
        return isValid;
    }
}

