/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.rules;

import java.sql.Date;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalFinancialRule;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalFinancialRuleEvent;
import org.kuali.kra.rules.ResearchDocumentRuleBase;

public class InstitutionalProposalFinancialRuleImpl
extends ResearchDocumentRuleBase
implements InstitutionalProposalFinancialRule {
    private static final String REQUESTED_INITIAL_START_DATE = "Requested Initial Start Date";
    private static final String REQUESTED_INITIAL_END_DATE = "Requested Initial End Date";
    private static final String REQUESTED_TOTAL_START_DATE = "Requested Total Start Date";
    private static final String REQUESTED_TOTAL_END_DATE = "Requested Total End Date";
    private static final String DIRECT_COST_INITIAL_PERIOD = "Direct Cost Initial Period";
    private static final String DIRECT_COST_TOTAL_PERIOD = "Direct Cost Total Period";
    private static final String INDIRECT_COST_INITIAL_PERIOD = "Indirect Cost Initial Period";
    private static final String INDIRECT_COST_TOTAL_PERIOD = "Indirect Cost Total Period";

    public boolean processInstitutionalProposalFinancialRules(InstitutionalProposalFinancialRuleEvent institutionalProposalFinancialRuleEvent) {
        boolean valid = true;
        InstitutionalProposal institutionalProposal = institutionalProposalFinancialRuleEvent.getInstitutionalProposalForValidation();
        if (institutionalProposal.getRequestedStartDateInitial() != null && institutionalProposal.getRequestedEndDateInitial() != null && !this.validateFirstDatePriorToSecondDate(institutionalProposal.getRequestedStartDateInitial(), institutionalProposal.getRequestedEndDateInitial())) {
            this.reportError("document.institutionalProposalList[0].requestedStartDateInitial", "error.financial.dates", new String[]{REQUESTED_INITIAL_START_DATE, REQUESTED_INITIAL_END_DATE});
            valid = false;
        }
        if (institutionalProposal.getRequestedStartDateTotal() != null && institutionalProposal.getRequestedEndDateTotal() != null && !this.validateFirstDatePriorToSecondDate(institutionalProposal.getRequestedStartDateTotal(), institutionalProposal.getRequestedEndDateTotal())) {
            this.reportError("document.institutionalProposalList[0].requestedStartDateTotal", "error.financial.dates", new String[]{REQUESTED_TOTAL_START_DATE, REQUESTED_TOTAL_END_DATE});
            valid = false;
        }
        if (institutionalProposal.getRequestedStartDateTotal() != null && institutionalProposal.getRequestedStartDateInitial() != null && !this.validateFirstDatePriorToSecondDate(institutionalProposal.getRequestedStartDateTotal(), institutionalProposal.getRequestedStartDateInitial())) {
            this.reportError("document.institutionalProposalList[0].requestedStartDateTotal", "error.financial.dates", new String[]{REQUESTED_TOTAL_START_DATE, REQUESTED_INITIAL_START_DATE});
            valid = false;
        }
        if (institutionalProposal.getRequestedEndDateTotal() != null && institutionalProposal.getRequestedEndDateInitial() != null && !this.validateFirstDatePriorToSecondDate(institutionalProposal.getRequestedEndDateInitial(), institutionalProposal.getRequestedEndDateTotal())) {
            this.reportError("document.institutionalProposalList[0].requestedEndDateInitial", "error.financial.dates", new String[]{REQUESTED_INITIAL_END_DATE, REQUESTED_TOTAL_END_DATE});
            valid = false;
        }
        valid = this.testFinancialCostFields(institutionalProposal);
        return valid;
    }

    private boolean validateFirstDatePriorToSecondDate(Date firstDate, Date secondDate) {
        return firstDate.before(secondDate) || firstDate.equals(secondDate);
    }

    private boolean testFinancialCostFields(InstitutionalProposal institutionalProposal) {
        boolean valid = true;
        if (institutionalProposal.getTotalDirectCostInitial().isNegative()) {
            this.reportError("document.institutionalProposalList[0].totalDirectCostInitial", "error.financial.costs", new String[]{DIRECT_COST_INITIAL_PERIOD});
            valid = false;
        }
        if (institutionalProposal.getTotalDirectCostTotal().isNegative()) {
            this.reportError("document.institutionalProposalList[0].totalDirectCostTotal", "error.financial.costs", new String[]{DIRECT_COST_TOTAL_PERIOD});
            valid = false;
        }
        if (institutionalProposal.getTotalIndirectCostInitial().isNegative()) {
            this.reportError("document.institutionalProposalList[0].totalIndirectCostInitial", "error.financial.costs", new String[]{INDIRECT_COST_INITIAL_PERIOD});
            valid = false;
        }
        if (institutionalProposal.getTotalIndirectCostTotal().isNegative()) {
            this.reportError("document.institutionalProposalList[0].totalIndirectCostTotal", "error.financial.costs", new String[]{INDIRECT_COST_TOTAL_PERIOD});
            valid = false;
        }
        return valid;
    }
}

