/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.rules;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.infrastructure.Constants;
import org.kuali.kra.institutionalproposal.IndirectcostRateType;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCostShare;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalUnrecoveredFandA;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalAddUnrecoveredFandARuleEvent;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalSaveUnrecoveredFandARuleEvent;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalUnrecoveredFandARule;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.service.BusinessObjectService;

public class InstitutionalProposalUnrecoveredFandARuleImpl
extends ResearchDocumentRuleBase
implements InstitutionalProposalUnrecoveredFandARule {
    private static final long serialVersionUID = 8573006511997627073L;
    BusinessObjectService businessObjectService;
    private static final String NEW_PROPOSAL_UNRECOVERED_FNA = "newInstitutionalProposalUnrecoveredFandA";
    InstitutionalProposalCostShare institutionalProposalCostShare;

    public boolean processAddInstitutionalProposalUnrecoveredFandABusinessRules(InstitutionalProposalAddUnrecoveredFandARuleEvent institutionalProposalAddUnrecoveredFandARuleEvent) {
        return this.processCommonValidations(institutionalProposalAddUnrecoveredFandARuleEvent.getUnrecoveredFandAForValidation(), institutionalProposalAddUnrecoveredFandARuleEvent.getInstitutionalProposalUnrecoveredFandAs());
    }

    public boolean processSaveInstitutionalProposalUnrecoveredFandABusinessRules(InstitutionalProposalSaveUnrecoveredFandARuleEvent institutionalProposalAddUnrecoveredFandARuleEvent) {
        return this.processCommonValidations(institutionalProposalAddUnrecoveredFandARuleEvent.getUnrecoveredFandAForValidation(), institutionalProposalAddUnrecoveredFandARuleEvent.getInstitutionalProposalUnrecoveredFandAs());
    }

    public boolean processCommonValidations(InstitutionalProposalUnrecoveredFandA institutionalProposalUnrecoveredFandA, List<InstitutionalProposalUnrecoveredFandA> institutionalProposalUnrecoveredFandAs) {
        boolean validFiscalYearRange = this.validateUnrecoveredFandAFiscalYearRange(institutionalProposalUnrecoveredFandA);
        boolean validPercentage = this.validatePercentage(institutionalProposalUnrecoveredFandA.getApplicableIndirectcostRate());
        boolean validRateType = this.validateRateType(institutionalProposalUnrecoveredFandA.getIndirectcostRateTypeCode());
        boolean validSourceAccount = this.validateSourceAccount(institutionalProposalUnrecoveredFandA.getSourceAccount());
        boolean validAmount = this.validateAmount(institutionalProposalUnrecoveredFandA.getAmount());
        boolean validRows = this.checkNoDuplicates(institutionalProposalUnrecoveredFandA, institutionalProposalUnrecoveredFandAs);
        return validFiscalYearRange && validPercentage && validRateType && validSourceAccount && validAmount && validRows;
    }

    public boolean validateUnrecoveredFandAFiscalYearRange(InstitutionalProposalUnrecoveredFandA institutionalProposalUnrecoveredFandA) {
        boolean valid = true;
        if (institutionalProposalUnrecoveredFandA.getFiscalYear() != null) {
            try {
                int fiscalYear = Integer.parseInt(institutionalProposalUnrecoveredFandA.getFiscalYear());
                if (fiscalYear < Constants.MIN_FISCAL_YEAR || fiscalYear > Constants.MAX_FISCAL_YEAR) {
                    valid = false;
                    this.reportError("newInstitutionalProposalUnrecoveredFandA.fiscalYear", "error.institutionalProposalUnrecoveredFandA.fiscalYear.range", new String[0]);
                }
            }
            catch (NumberFormatException e) {
                valid = false;
                this.reportError("newInstitutionalProposalUnrecoveredFandA.fiscalYear", "error.institutionalProposalUnrecoveredFandA.fiscalYear.IncorrectFormat", new String[0]);
            }
        } else {
            valid = false;
            this.reportError("newInstitutionalProposalUnrecoveredFandA.fiscalYear", "error.institutionalProposalUnrecoveredFandA.fiscalYear.required", new String[0]);
        }
        return valid;
    }

    private boolean validatePercentage(KualiDecimal percentage) {
        boolean isValid = true;
        if (percentage != null && percentage.isLessThan((AbstractKualiDecimal)new KualiDecimal(0))) {
            isValid = false;
            this.reportError("newInstitutionalProposalUnrecoveredFandA.costSharePercentage", "error.institutionalProposalUnrecoveredFandA.percentage.range", new String[0]);
        }
        return isValid;
    }

    private boolean validateRateType(Integer rateTypeCode) {
        boolean isValid = true;
        if (rateTypeCode == null) {
            isValid = false;
            this.reportError("newInstitutionalProposalUnrecoveredFandA.rateTypeCode", "error.institutionalProposalUnrecoveredFandA.rateTypeCode.required", new String[0]);
        } else {
            BusinessObjectService thisBusinessObjectService = this.businessObjectService == null ? this.getBusinessObjectService() : this.businessObjectService;
            HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
            fieldValues.put("indirectcostRateTypeCode", rateTypeCode);
            if (thisBusinessObjectService.countMatching(IndirectcostRateType.class, fieldValues) != 1) {
                isValid = false;
                this.reportError("newInstitutionalProposalUnrecoveredFandA.rateTypeCode", "error.institutionalProposalUnrecoveredFandA.rateTypeCode.invalid", new String[]{rateTypeCode.toString()});
            }
        }
        return isValid;
    }

    private boolean validateSourceAccount(String a) {
        boolean isValid = true;
        if (StringUtils.isBlank((String)a)) {
            isValid = false;
            this.reportError("newInstitutionalProposalUnrecoveredFandA.sourceAccount", "error.institutionalProposalUnrecoveredFandA.sourceAccount.required", new String[0]);
        }
        return isValid;
    }

    private boolean validateAmount(KualiDecimal amount) {
        boolean isValid = true;
        if (amount == null) {
            isValid = false;
            this.reportError("newInstitutionalProposalUnrecoveredFandA.commitmentAmount", "error.institutionalProposalUnrecoveredFandA.amount.required", new String[0]);
        } else if (amount.isLessThan((AbstractKualiDecimal)new KualiDecimal(0))) {
            isValid = false;
            this.reportError("newInstitutionalProposalUnrecoveredFandA.commitmentAmount", "error.institutionalProposalUnrecoveredFandA.amount.invalid", new String[]{amount.toString()});
        }
        return isValid;
    }

    private boolean checkNoDuplicates(InstitutionalProposalUnrecoveredFandA institutionalProposalUnrecoveredFandA, List<InstitutionalProposalUnrecoveredFandA> institutionalProposalUnrecoveredFandAs) {
        boolean noDuplicates = true;
        for (InstitutionalProposalUnrecoveredFandA a : institutionalProposalUnrecoveredFandAs) {
            if (a == institutionalProposalUnrecoveredFandA || !StringUtils.equals((String)a.getFiscalYear(), (String)institutionalProposalUnrecoveredFandA.getFiscalYear()) || !ObjectUtils.equals((Object)a.getIndirectcostRateTypeCode(), (Object)institutionalProposalUnrecoveredFandA.getIndirectcostRateTypeCode()) || !ObjectUtils.equals((Object)a.getApplicableIndirectcostRate(), (Object)institutionalProposalUnrecoveredFandA.getApplicableIndirectcostRate()) || !ObjectUtils.equals((Object)a.getOnCampusFlag(), (Object)institutionalProposalUnrecoveredFandA.getOnCampusFlag()) || !StringUtils.equals((String)a.getSourceAccount(), (String)institutionalProposalUnrecoveredFandA.getSourceAccount()) || !ObjectUtils.equals((Object)a.getAmount(), (Object)institutionalProposalUnrecoveredFandA.getAmount())) continue;
            noDuplicates = false;
            this.reportError("newInstitutionalProposalUnrecoveredFandA.fiscalYear", "error.institutionalProposalUnrecoveredFandA.duplicate.row", new String[0]);
        }
        return noDuplicates;
    }

    public void setBusinessObjectService(BusinessObjectService bos) {
        this.businessObjectService = bos;
    }
}

