/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.ipreview.IntellectualPropertyReview;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalVersioningService;
import org.kuali.kra.service.VersionException;
import org.kuali.kra.service.VersioningService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class InstitutionalProposalVersioningServiceImpl
implements InstitutionalProposalVersioningService {
    private BusinessObjectService businessObjectService;
    private VersioningService versioningService;

    public IntellectualPropertyReview createNewIntellectualPropertyReviewVersion(IntellectualPropertyReview intellectualPropertyReview) throws VersionException {
        return (IntellectualPropertyReview)this.versioningService.createNewVersion((SequenceOwner)intellectualPropertyReview);
    }

    public void updateInstitutionalProposalVersionStatus(InstitutionalProposal proposalToUpdate, VersionStatus versionStatus) {
        if (versionStatus.equals((Object)VersionStatus.ACTIVE)) {
            this.archiveCurrentActiveProposal(proposalToUpdate.getProposalNumber());
            proposalToUpdate.activateFundingProposals();
        }
        proposalToUpdate.setProposalSequenceStatus(versionStatus.toString());
        this.businessObjectService.save((PersistableBusinessObject)proposalToUpdate);
    }

    public InstitutionalProposal getPendingInstitutionalProposalVersion(String proposalNumber) {
        List results = this.findProposalsByStatus(proposalNumber, VersionStatus.PENDING);
        if (!results.isEmpty()) {
            return (InstitutionalProposal)results.get(0);
        }
        return null;
    }

    public InstitutionalProposal getActiveInstitutionalProposalVersion(String proposalNumber) {
        List results = this.findProposalsByStatus(proposalNumber, VersionStatus.ACTIVE);
        if (!results.isEmpty()) {
            return (InstitutionalProposal)results.get(0);
        }
        return null;
    }

    protected void archiveCurrentActiveProposal(String proposalNumber) {
        List results = this.findProposalsByStatus(proposalNumber, VersionStatus.ACTIVE);
        if (!results.isEmpty()) {
            InstitutionalProposal proposalToArchive = (InstitutionalProposal)results.get(0);
            proposalToArchive.setProposalSequenceStatus(VersionStatus.ARCHIVED.toString());
            proposalToArchive.deactivateFundingProposals();
            proposalToArchive.setAllowUpdateTimestampToBeReset(false);
            this.businessObjectService.save((PersistableBusinessObject)proposalToArchive);
        }
    }

    protected List<InstitutionalProposal> findProposalsByStatus(String proposalNumber, VersionStatus versionStatus) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("proposalNumber", proposalNumber);
        criteria.put("proposalSequenceStatus", versionStatus.toString());
        ArrayList<InstitutionalProposal> results = new ArrayList<InstitutionalProposal>(this.businessObjectService.findMatching(InstitutionalProposal.class, criteria));
        return results;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public VersioningService getVersioningService() {
        return this.versioningService;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }
}

