/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.web.struts.action;

import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.common.web.struts.form.ReportHelperBean;
import org.kuali.kra.common.web.struts.form.ReportHelperBeanContainer;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.fundedawards.FundedAwardsBean;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.notification.InstitutionalProposalNotificationContext;
import org.kuali.kra.institutionalproposal.printing.InstitutionalProposalPrintType;
import org.kuali.kra.institutionalproposal.printing.service.InstitutionalProposalPrintingService;
import org.kuali.kra.institutionalproposal.web.struts.action.InstitutionalProposalAction;
import org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm;
import org.kuali.kra.printing.service.CurrentAndPendingReportService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.web.struts.action.AuditActionHelper;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.action.AuditModeAction;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class InstitutionalProposalActionsAction
extends InstitutionalProposalAction
implements AuditModeAction {
    private static final int ERROR = 2;
    private static final int OK = 0;
    private static final int WARNING = 1;
    private static final String CONFIRM_UNLOCK_SELECTED = "confirmUnlockSelected";
    private static final String CONFIRM_UNLOCK_SELECTED_KEY = "confirmUnlockSelectedKey";
    private static final String ERROR_SELECTING_FUNDING_PROPS = "error.fundingproposal.unlockNoSelection";

    public ActionForward activate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new AuditActionHelper().setAuditMode(mapping, (KualiDocumentFormBase)((InstitutionalProposalForm)form), true);
    }

    public ActionForward deactivate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new AuditActionHelper().setAuditMode(mapping, (KualiDocumentFormBase)((InstitutionalProposalForm)form), false);
    }

    public ActionForward unlockSelected(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm iForm = (InstitutionalProposalForm)form;
        if (iForm.getSelectedAwardFundingProposals() == null || iForm.getSelectedAwardFundingProposals().length == 0) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("selectedAwardFundingProposals", ERROR_SELECTING_FUNDING_PROPS, new String[0]);
            return mapping.findForward("institutionalProposalActions");
        }
        return this.confirm(this.buildUnlockSelectedConfirmationQuestion(mapping, form, request, response), CONFIRM_UNLOCK_SELECTED, "");
    }

    public ActionForward confirmUnlockSelected(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        new FundedAwardsBean((InstitutionalProposalForm)form).removeUnlockedAwards();
        return mapping.findForward("basic");
    }

    public ActionForward selectAllFundedAwards(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        new FundedAwardsBean((InstitutionalProposalForm)form).selectAllFundedAwards();
        return mapping.findForward("basic");
    }

    public ActionForward deselectAllFundedAwards(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((InstitutionalProposalForm)form).setSelectedAwardFundingProposals(new String[0]);
        return mapping.findForward("basic");
    }

    public ActionForward printProposalSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm ipForm = (InstitutionalProposalForm)form;
        InstitutionalProposalPrintingService ipPrintingService = (InstitutionalProposalPrintingService)KraServiceLocator.getService(InstitutionalProposalPrintingService.class);
        AttachmentDataSource dataStream = ipPrintingService.printInstitutionalProposalReport((KraPersistableBusinessObjectBase)ipForm.getInstitutionalProposalDocument().getInstitutionalProposal(), InstitutionalProposalPrintType.INSTITUTIONAL_PROPOSAL_REPORT.getInstitutionalProposalPrintType(), new HashMap());
        this.streamToResponse(dataStream, response);
        return null;
    }

    public ActionForward prepareCurrentReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportHelperBean helper = ((ReportHelperBeanContainer)form).getReportHelperBean();
        request.setAttribute("currentReportRows", (Object)helper.prepareCurrentReport());
        request.setAttribute("reportPersonName", (Object)helper.getTargetPersonName());
        return mapping.findForward("basic");
    }

    public ActionForward preparePendingReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportHelperBean helper = ((ReportHelperBeanContainer)form).getReportHelperBean();
        request.setAttribute("pendingReportRows", (Object)helper.preparePendingReport());
        request.setAttribute("reportPersonName", (Object)helper.getTargetPersonName());
        return mapping.findForward("basic");
    }

    public ActionForward printCurrentReportPdf(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CurrentAndPendingReportService currentAndPendingReportService = (CurrentAndPendingReportService)KraServiceLocator.getService(CurrentAndPendingReportService.class);
        ReportHelperBean helper = ((ReportHelperBeanContainer)form).getReportHelperBean();
        HashMap<String, String> reportParameters = new HashMap<String, String>();
        reportParameters.put("personId", helper.getPersonId());
        reportParameters.put("reportPersonName", helper.getTargetPersonName());
        AttachmentDataSource dataStream = currentAndPendingReportService.printCurrentAndPendingSupportReport("Current Report", reportParameters);
        this.streamToResponse(dataStream.getContent(), dataStream.getFileName(), null, response);
        return null;
    }

    public ActionForward printPendingReportPdf(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CurrentAndPendingReportService currentAndPendingReportService = (CurrentAndPendingReportService)KraServiceLocator.getService(CurrentAndPendingReportService.class);
        ReportHelperBean helper = ((ReportHelperBeanContainer)form).getReportHelperBean();
        HashMap<String, String> reportParameters = new HashMap<String, String>();
        reportParameters.put("personId", helper.getPersonId());
        reportParameters.put("reportPersonName", helper.getTargetPersonName());
        AttachmentDataSource dataStream = currentAndPendingReportService.printCurrentAndPendingSupportReport("Pending Report", reportParameters);
        this.streamToResponse(dataStream.getContent(), dataStream.getFileName(), null, response);
        return null;
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm proposalForm = (InstitutionalProposalForm)form;
        ActionForward forward = super.approve(mapping, form, request, response);
        String routeHeaderId = proposalForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "institutionalProposalActions", "InstitutionalProposalDocument");
        ActionForward basicForward = mapping.findForward("portal");
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        return this.routeToHoldingPage(basicForward, forward, holdingPageForward, returnLocation);
    }

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm proposalForm = (InstitutionalProposalForm)form;
        ActionForward forward = mapping.findForward("basic");
        proposalForm.setAuditActivated(true);
        if (this.submissionStatus(proposalForm.getInstitutionalProposalDocument()) == 2) {
            return mapping.findForward("basic");
        }
        forward = super.blanketApprove(mapping, form, request, response);
        String routeHeaderId = proposalForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "institutionalProposalActions", "InstitutionalProposalDocument");
        ActionForward basicForward = mapping.findForward("portal");
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        return this.routeToHoldingPage(basicForward, forward, holdingPageForward, returnLocation);
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm proposalForm = (InstitutionalProposalForm)form;
        ActionForward forward = mapping.findForward("basic");
        proposalForm.setAuditActivated(true);
        if (this.submissionStatus(proposalForm.getInstitutionalProposalDocument()) == 2) {
            return mapping.findForward("basic");
        }
        forward = super.route(mapping, form, request, response);
        String routeHeaderId = proposalForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "institutionalProposalActions", "InstitutionalProposalDocument");
        ActionForward basicForward = mapping.findForward("portal");
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        return this.routeToHoldingPage(basicForward, forward, holdingPageForward, returnLocation);
    }

    private int submissionStatus(InstitutionalProposalDocument institutionalProposalDocument) {
        int state = 0;
        boolean auditPassed = new AuditActionHelper().auditUnconditionally((Document)institutionalProposalDocument);
        if (!auditPassed) {
            state = 1;
            Iterator iter = KNSGlobalVariables.getAuditErrorMap().keySet().iterator();
            while (iter.hasNext()) {
                AuditCluster auditCluster = (AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(iter.next());
                if (StringUtils.equalsIgnoreCase((String)auditCluster.getCategory(), (String)"Warnings")) continue;
                state = 2;
                GlobalVariables.getMessageMap().putError("noKey", "error.institutionalproposal.validationFailed", new String[0]);
                break;
            }
        }
        return state;
    }

    public ActionForward acknowledge(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((InstitutionalProposalForm)form).getDocument().prepareForSave();
        return super.acknowledge(mapping, form, request, response);
    }

    public ActionForward fyi(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((InstitutionalProposalForm)form).getDocument().prepareForSave();
        return super.fyi(mapping, form, request, response);
    }

    public ActionForward sendNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        InstitutionalProposal institutionalProposal = institutionalProposalForm.getInstitutionalProposalDocument().getInstitutionalProposal();
        InstitutionalProposalNotificationContext context = new InstitutionalProposalNotificationContext(institutionalProposal, null, "Ad-Hoc Notification", "institutionalProposalActions");
        institutionalProposalForm.getNotificationHelper().initializeDefaultValues((NotificationContext)context);
        return mapping.findForward("notificationEditor");
    }

    private StrutsConfirmation buildUnlockSelectedConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_UNLOCK_SELECTED_KEY, "question.unlock.fundedAwards", new String[0]);
    }
}

