/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.web.struts.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.upload.FormFile;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.bo.CommentType;
import org.kuali.kra.document.KeywordsManager;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalComment;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalNotepad;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalNotepadBean;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalScienceKeyword;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLog;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLogUtils;
import org.kuali.kra.institutionalproposal.proposallog.service.ProposalLogService;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalNoteAddEvent;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalNoteEventBase;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalVersioningService;
import org.kuali.kra.institutionalproposal.web.struts.action.InstitutionalProposalAction;
import org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm;
import org.kuali.kra.negotiations.service.NegotiationService;
import org.kuali.kra.service.KcAttachmentService;
import org.kuali.kra.service.KeywordsService;
import org.kuali.kra.service.Sponsorable;
import org.kuali.kra.service.VersionException;
import org.kuali.kra.service.VersioningService;
import org.kuali.kra.web.struts.form.MultiLookupFormBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.datadictionary.BusinessObjectEntry;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.bo.Attachment;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.NoteType;

public class InstitutionalProposalHomeAction
extends InstitutionalProposalAction {
    private static final Log LOG = LogFactory.getLog(InstitutionalProposalHomeAction.class);
    private static final String VERSION_EDITPENDING_PROMPT_KEY = "message.award.version.editpending.prompt";
    private InstitutionalProposalNotepadBean institutionalProposalNotepadBean = new InstitutionalProposalNotepadBean();
    private KcAttachmentService kcAttachmentService;
    private ParameterService parameterService;
    private InstitutionalProposalService institutionalProposalService;

    public ActionForward addNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        if (this.applyRules((KualiDocumentEvent)new InstitutionalProposalNoteAddEvent("", ((InstitutionalProposalForm)form).getDocument(), institutionalProposalForm.getInstitutionalProposalNotepadBean().getNewInstitutionalProposalNotepad(), InstitutionalProposalNoteEventBase.ErrorType.HARDERROR))) {
            InstitutionalProposalNotepad notepad = institutionalProposalForm.getInstitutionalProposalNotepadBean().getNewInstitutionalProposalNotepad();
            BusinessObjectEntry businessObjectEntry = (BusinessObjectEntry)KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry("org.kuali.kra.institutionalproposal.home.InstitutionalProposalNotepad");
            if (institutionalProposalForm.getAttachmentFile() != null) {
                if (!businessObjectEntry.isBoNotesEnabled()) {
                    throw new RuntimeException("to add attachments, the DD file for InstitutionalProposalNotepad must be configured for boNotesEnabled=true");
                }
                FormFile attachmentFile = institutionalProposalForm.getAttachmentFile();
                if (attachmentFile == null) {
                    GlobalVariables.getMessageMap().putError(String.format("%s.%s", "newNote", "attachmentFile"), "error.uploadFile.null", new String[0]);
                }
                Note newNote = new Note();
                newNote.setNoteText("Default text, will never be shown to user.");
                newNote.setNoteTypeCode(NoteType.BUSINESS_OBJECT.getCode());
                newNote.setNotePostedTimestampToCurrent();
                Attachment attachment = null;
                if (attachmentFile != null && !StringUtils.isBlank((String)attachmentFile.getFileName())) {
                    if (attachmentFile.getFileSize() == 0) {
                        GlobalVariables.getMessageMap().putError(String.format("%s.%s", "newNote", "attachmentFile"), "error.uploadFile.empty", new String[]{attachmentFile.getFileName()});
                    } else {
                        String attachmentType = null;
                        attachment = this.getAttachmentService().createAttachment((PersistableBusinessObject)notepad, attachmentFile.getFileName(), attachmentFile.getContentType(), attachmentFile.getFileSize(), attachmentFile.getInputStream(), attachmentType);
                    }
                    Note tmpNote = this.getNoteService().createNote(newNote, (PersistableBusinessObject)notepad, GlobalVariables.getUserSession().getPrincipalId());
                    tmpNote.addAttachment(attachment);
                    notepad.getAttachments().add(tmpNote);
                }
            }
            this.institutionalProposalNotepadBean.addNote(((InstitutionalProposalForm)form).getInstitutionalProposalNotepadBean());
        }
        return mapping.findForward("basic");
    }

    public ActionForward updateNotes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward selectAllScienceKeyword(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        InstitutionalProposalDocument institutionalProposalDocument = institutionalProposalForm.getInstitutionalProposalDocument();
        List keywords = institutionalProposalDocument.getInstitutionalProposal().getKeywords();
        for (InstitutionalProposalScienceKeyword institutionalProposalScienceKeyword : keywords) {
            institutionalProposalScienceKeyword.setSelectKeyword(Boolean.valueOf(true));
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteSelectedScienceKeyword(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        InstitutionalProposalDocument institutionalProposalDocument = institutionalProposalForm.getInstitutionalProposalDocument();
        KeywordsService keywordsService = (KeywordsService)KraServiceLocator.getService(KeywordsService.class);
        keywordsService.deleteKeyword((KeywordsManager)institutionalProposalDocument.getInstitutionalProposal());
        return mapping.findForward("basic");
    }

    public ActionForward recalculateTotals(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.refresh(mapping, form, request, response);
        InstitutionalProposalForm propMultiLookupForm = (InstitutionalProposalForm)form;
        String lookupResultsBOClassName = request.getParameter("lookupResultsBOClassName");
        String lookupResultsSequenceNumber = request.getParameter("lookupResultsSequenceNumber");
        propMultiLookupForm.setLookupResultsBOClassName(lookupResultsBOClassName);
        propMultiLookupForm.setLookupResultsSequenceNumber(lookupResultsSequenceNumber);
        InstitutionalProposal prop = propMultiLookupForm.getInstitutionalProposalDocument().getInstitutionalProposal();
        this.getKeywordService().addKeywords((KeywordsManager)prop, (MultiLookupFormBase)propMultiLookupForm);
        if (prop.getRolodexId() != null) {
            prop.refreshReferenceObject("rolodex");
        }
        return mapping.findForward("basic");
    }

    protected KeywordsService getKeywordService() {
        return (KeywordsService)KraServiceLocator.getService(KeywordsService.class);
    }

    public ActionForward clearMailingNameAddress(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        if (institutionalProposalForm.getInstitutionalProposalDocument().getInstitutionalProposal().getRolodex() != null) {
            institutionalProposalForm.getInstitutionalProposalDocument().getInstitutionalProposal().setRolodexId(null);
            institutionalProposalForm.getInstitutionalProposalDocument().getInstitutionalProposal().setRolodex(null);
        }
        return mapping.findForward("basic");
    }

    public ActionForward editOrVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question;
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        InstitutionalProposalDocument institutionalProposalDocument = institutionalProposalForm.getInstitutionalProposalDocument();
        InstitutionalProposal institutionalProposal = institutionalProposalDocument.getInstitutionalProposal();
        InstitutionalProposal pendingProposal = this.findPendingVersion(institutionalProposal.getProposalNumber());
        ActionForward forward = pendingProposal != null ? ((question = request.getParameter("buttonClicked")) == null ? this.showPromptForEditingPendingVersion(mapping, institutionalProposalForm, request, response) : this.processPromptForEditingPendingVersionResponse(mapping, request, response, institutionalProposalForm, pendingProposal)) : this.createAndSaveNewVersion(response, institutionalProposalForm, institutionalProposalDocument, institutionalProposal);
        return forward;
    }

    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.createDocument(kualiDocumentFormBase);
        InstitutionalProposalForm ipForm = (InstitutionalProposalForm)kualiDocumentFormBase;
        ProposalLog proposalLog = this.retrieveProposalLog(ipForm.getProposalNumber());
        CommentType ct = new CommentType();
        ct.setCommentTypeCode("12");
        ct.setDescription("description");
        ct.setChecklistFlag(Boolean.valueOf(false));
        ct.setTemplateFlag(Boolean.valueOf(false));
        ct.setAwardCommentScreenFlag(Boolean.valueOf(false));
        ipForm.getInstitutionalProposalDocument().getInstitutionalProposal().setDeadlineDate(proposalLog.getDeadlineDate());
        ipForm.getInstitutionalProposalDocument().getInstitutionalProposal().setDeadlineTime(proposalLog.getDeadlineTime());
        InstitutionalProposalComment ipCmt = new InstitutionalProposalComment("12");
        ipCmt.setCommentType(ct);
        ipCmt.setComments(proposalLog.getComments());
        ipCmt.setProposalNumber(proposalLog.getProposalNumber());
        ipCmt.setProposalId(ipForm.getInstitutionalProposalDocument().getInstitutionalProposal().getProposalId());
        ipCmt.setInstitutionalProposal(ipForm.getInstitutionalProposalDocument().getInstitutionalProposal());
        ipCmt.getInstitutionalProposal().setProposalNumber(proposalLog.getProposalNumber());
        ipForm.getInstitutionalProposalDocument().getInstitutionalProposal().add(ipCmt);
        ipForm.getInstitutionalProposalDocument().getInstitutionalProposal().setProposalNumber(proposalLog.getProposalNumber());
        if (proposalLog != null) {
            ipForm.getInstitutionalProposalDocument().getInstitutionalProposal().doProposalLogDataFeed(proposalLog);
        }
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm ipForm = (InstitutionalProposalForm)form;
        InstitutionalProposal ip = ipForm.getInstitutionalProposalDocument().getInstitutionalProposal();
        if (!ip.getInstitutionalProposalScienceKeywords().isEmpty()) {
            ip.setScienceCodeIndicator("1");
        } else {
            ip.setScienceCodeIndicator("0");
        }
        ActionForward forward = super.save(mapping, form, request, response);
        ProposalLog proposalLog = this.retrieveProposalLog(ipForm.getProposalNumber());
        if (proposalLog != null && !proposalLog.getLogStatus().equals(ProposalLogUtils.getProposalLogSubmittedStatusCode())) {
            this.getProposalLogService().promoteProposalLog(proposalLog.getProposalNumber());
            this.getNegotationService().promoteProposalLogNegotiation(proposalLog.getProposalNumber(), ip.getProposalNumber());
        }
        ip.setSponsorNihMultiplePi(this.getSponsorService().isSponsorNihMultiplePi((Sponsorable)ip));
        return forward;
    }

    private NegotiationService getNegotationService() {
        return (NegotiationService)KraServiceLocator.getService(NegotiationService.class);
    }

    private ProposalLog retrieveProposalLog(String proposalNumber) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("proposalNumber", proposalNumber);
        return (ProposalLog)this.getBusinessObjectService().findByPrimaryKey(ProposalLog.class, criteria);
    }

    private InstitutionalProposal findPendingVersion(String proposalNumber) {
        return this.getInstitutionalProposalVersioningService().getPendingInstitutionalProposalVersion(proposalNumber);
    }

    private ActionForward createAndSaveNewVersion(HttpServletResponse response, InstitutionalProposalForm institutionalProposalForm, InstitutionalProposalDocument institutionalProposalDocument, InstitutionalProposal institutionalProposal) throws VersionException, WorkflowException, IOException {
        InstitutionalProposalDocument newInstitutionalProposalDocument = this.getInstitutionalProposalService().createAndSaveNewVersion(institutionalProposal, institutionalProposalDocument);
        this.reinitializeForm(institutionalProposalForm, newInstitutionalProposalDocument);
        return new ActionRedirect(this.makeDocumentOpenUrl(newInstitutionalProposalDocument));
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        if (this.institutionalProposalService == null) {
            this.institutionalProposalService = (InstitutionalProposalService)KraServiceLocator.getService(InstitutionalProposalService.class);
        }
        return this.institutionalProposalService;
    }

    private void reinitializeForm(InstitutionalProposalForm institutionalProposalForm, InstitutionalProposalDocument document) throws WorkflowException {
        institutionalProposalForm.populateHeaderFields(document.getDocumentHeader().getWorkflowDocument());
        institutionalProposalForm.setDocument((Document)document);
        institutionalProposalForm.initialize();
    }

    private String makeDocumentOpenUrl(InstitutionalProposalDocument newInstitutionalProposalDocument) {
        String workflowUrl = this.getKualiConfigurationService().getPropertyValueAsString("workflow.url");
        String url = String.format("%s/DocHandler.do?command=displayDocSearchView&docId=%s", workflowUrl, newInstitutionalProposalDocument.getDocumentNumber());
        return url;
    }

    private ActionForward showPromptForEditingPendingVersion(ActionMapping mapping, InstitutionalProposalForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.performQuestionWithoutInput(mapping, (ActionForm)form, request, response, "EDIT_OR_VERSION_QUESTION_ID", this.getResources(request).getMessage(VERSION_EDITPENDING_PROMPT_KEY), "confirmationQuestion", "cancel", "");
    }

    private ActionForward processPromptForEditingPendingVersionResponse(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, InstitutionalProposalForm institutionalProposalForm, InstitutionalProposal institutionalProposal) throws WorkflowException, IOException {
        ActionForward forward;
        String buttonClicked = request.getParameter("buttonClicked");
        if ("1".equals(buttonClicked)) {
            forward = mapping.findForward("basic");
        } else {
            this.initializeFormWithInstutitionalProposal(institutionalProposalForm, institutionalProposal);
            response.sendRedirect(this.makeDocumentOpenUrl(institutionalProposalForm.getInstitutionalProposalDocument()));
            forward = null;
        }
        return forward;
    }

    private void initializeFormWithInstutitionalProposal(InstitutionalProposalForm institutionalProposalForm, InstitutionalProposal institutionalProposal) throws WorkflowException {
        this.reinitializeForm(institutionalProposalForm, this.findDocumentForInstitutionalProposal(institutionalProposal));
    }

    private InstitutionalProposalDocument findDocumentForInstitutionalProposal(InstitutionalProposal institutionalProposal) throws WorkflowException {
        InstitutionalProposalDocument document = (InstitutionalProposalDocument)this.getDocumentService().getByDocumentHeaderId(institutionalProposal.getInstitutionalProposalDocument().getDocumentNumber());
        document.setInstitutionalProposal(institutionalProposal);
        return document;
    }

    protected VersioningService getVersioningService() {
        return (VersioningService)KraServiceLocator.getService(VersioningService.class);
    }

    protected InstitutionalProposalVersioningService getInstitutionalProposalVersioningService() {
        return (InstitutionalProposalVersioningService)KraServiceLocator.getService(InstitutionalProposalVersioningService.class);
    }

    protected ProposalLogService getProposalLogService() {
        return (ProposalLogService)KraServiceLocator.getService(ProposalLogService.class);
    }

    protected KcAttachmentService getKcAttachmentService() {
        if (this.kcAttachmentService == null) {
            this.kcAttachmentService = (KcAttachmentService)KraServiceLocator.getService(KcAttachmentService.class);
        }
        return this.kcAttachmentService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public ActionForward downloadBOAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int attachmentIndex = this.selectedAttachmentIndex(request);
        InstitutionalProposalForm ipForm = (InstitutionalProposalForm)form;
        InstitutionalProposalDocument institutionalProposalDocument = ipForm.getInstitutionalProposalDocument();
        if (!WebUtils.canViewNoteAttachment((Document)institutionalProposalDocument, null)) {
            throw new AuthenticationException("Unable to view attachment.");
        }
        List notepads = institutionalProposalDocument.getInstitutionalProposal().getInstitutionalProposalNotepads();
        InstitutionalProposalNotepad noteParent = (InstitutionalProposalNotepad)notepads.get(attachmentIndex);
        if (attachmentIndex >= 0) {
            Attachment attachment = ((Note)noteParent.getAttachments().get(0)).getAttachment();
            KualiDocumentFormBase documentForm = (KualiDocumentFormBase)form;
            documentForm.copyPopulateEditablePropertiesToActionEditableProperties();
            WebUtils.saveMimeInputStreamAsFile((HttpServletResponse)response, (String)attachment.getAttachmentMimeTypeCode(), (InputStream)attachment.getAttachmentContents(), (String)attachment.getAttachmentFileName(), (int)attachment.getAttachmentFileSize().intValue());
            return null;
        }
        return mapping.findForward("basic");
    }

    private ArrayList<AwardFundingProposal> transferFundingProposals(InstitutionalProposal oldIP, InstitutionalProposal newIP) {
        ArrayList<AwardFundingProposal> newFundingProposals = new ArrayList<AwardFundingProposal>();
        for (AwardFundingProposal afpp : oldIP.getAwardFundingProposals()) {
            newFundingProposals.add(new AwardFundingProposal(afpp.getAward(), newIP));
            afpp.setActive(false);
        }
        this.getBusinessObjectService().save(oldIP.getAwardFundingProposals());
        return newFundingProposals;
    }
}

