/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.web.struts.action;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.common.specialreview.bo.SpecialReview;
import org.kuali.kra.common.specialreview.rule.event.AddSpecialReviewEvent;
import org.kuali.kra.common.specialreview.rule.event.SaveSpecialReviewEvent;
import org.kuali.kra.common.specialreview.rule.event.SaveSpecialReviewLinkEvent;
import org.kuali.kra.common.specialreview.service.SpecialReviewService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.notification.InstitutionalProposalNotificationContext;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReview;
import org.kuali.kra.institutionalproposal.web.struts.action.InstitutionalProposalAction;
import org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;

public class InstitutionalProposalSpecialReviewAction
extends InstitutionalProposalAction {
    private static final String SAVE_SPECIAL_REVIEW_FIELD = "document.institutionalProposalList[0].specialReviews";
    private static final String CONFIRM_DELETE_SPECIAL_REVIEW_KEY = "confirmDeleteSpecialReview";
    private SpecialReviewService specialReviewService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        institutionalProposalForm.getSpecialReviewHelper().prepareView();
        return forward;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.refresh(mapping, form, request, response);
        String prefix = this.getSpecialReviewService().getProtocolSaveLocationPrefix(request.getParameterMap());
        InstitutionalProposalForm proposalForm = (InstitutionalProposalForm)form;
        InstitutionalProposalSpecialReview proposalSpecialReview = null;
        if (StringUtils.startsWith((String)prefix, (String)"specialReviewHelper.newSpecialReview")) {
            proposalSpecialReview = (InstitutionalProposalSpecialReview)proposalForm.getSpecialReviewHelper().getNewSpecialReview();
        } else {
            int index = this.getSpecialReviewService().getProtocolIndex(prefix);
            if (index != -1) {
                proposalSpecialReview = (InstitutionalProposalSpecialReview)proposalForm.getInstitutionalProposalDocument().getInstitutionalProposal().getSpecialReviews().get(index);
            }
        }
        proposalForm.getSpecialReviewHelper().prepareProtocolLinkViewFields((SpecialReview)proposalSpecialReview);
        return forward;
    }

    public ActionForward addSpecialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        InstitutionalProposalDocument document = institutionalProposalForm.getInstitutionalProposalDocument();
        InstitutionalProposalSpecialReview specialReview = (InstitutionalProposalSpecialReview)institutionalProposalForm.getSpecialReviewHelper().getNewSpecialReview();
        List specialReviews = document.getInstitutionalProposal().getSpecialReviews();
        boolean isProtocolLinkingEnabled = false;
        if ("1".equals(specialReview.getSpecialReviewTypeCode())) {
            isProtocolLinkingEnabled = institutionalProposalForm.getSpecialReviewHelper().getIsIrbProtocolLinkingEnabled();
        } else if ("2".equals(specialReview.getSpecialReviewTypeCode())) {
            isProtocolLinkingEnabled = institutionalProposalForm.getSpecialReviewHelper().getIsIacucProtocolLinkingEnabled();
        }
        institutionalProposalForm.getSpecialReviewHelper().prepareProtocolLinkViewFields((SpecialReview)specialReview);
        ActionForward forward = mapping.findForward("basic");
        if (this.applyRules((KualiDocumentEvent)new AddSpecialReviewEvent((Document)document, (SpecialReview)specialReview, specialReviews, isProtocolLinkingEnabled))) {
            specialReview.setSpecialReviewNumber(document.getDocumentNextValue("SPECIAL_REVIEW_NUMBER"));
            document.getInstitutionalProposal().getSpecialReviews().add(specialReview);
            institutionalProposalForm.getSpecialReviewHelper().setNewSpecialReview((SpecialReview)new InstitutionalProposalSpecialReview());
            if (specialReview.getSpecialReviewType() == null) {
                specialReview.refreshReferenceObject("specialReviewType");
            }
            if (StringUtils.equals((String)specialReview.getSpecialReviewType().getSpecialReviewTypeCode(), (String)"1")) {
                InstitutionalProposalNotificationContext context = new InstitutionalProposalNotificationContext(document.getInstitutionalProposal(), "552", "Special Review Inserted", "specialReview");
                if (institutionalProposalForm.getNotificationHelper().getPromptUserForNotificationEditor((NotificationContext)context)) {
                    institutionalProposalForm.getNotificationHelper().initializeDefaultValues((NotificationContext)context);
                    forward = mapping.findForward("notificationEditor");
                } else {
                    this.getNotificationService().sendNotification((NotificationContext)context);
                }
            }
        }
        return forward;
    }

    public ActionForward deleteSpecialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_SPECIAL_REVIEW_KEY, "question.special.review.delete.confirmation", new String[0]), CONFIRM_DELETE_SPECIAL_REVIEW_KEY, "");
    }

    public ActionForward confirmDeleteSpecialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_SPECIAL_REVIEW_KEY.equals(question)) {
            InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
            InstitutionalProposalDocument document = institutionalProposalForm.getInstitutionalProposalDocument();
            InstitutionalProposalSpecialReview specialReview = (InstitutionalProposalSpecialReview)document.getInstitutionalProposal().getSpecialReviews().get(this.getLineToDelete(request));
            document.getInstitutionalProposal().getSpecialReviews().remove(specialReview);
            if (StringUtils.equals((String)specialReview.getSpecialReviewType().getSpecialReviewTypeCode(), (String)"1")) {
                InstitutionalProposalNotificationContext context = new InstitutionalProposalNotificationContext(document.getInstitutionalProposal(), "553", "Special Review Deleted", "specialReview");
                if (institutionalProposalForm.getNotificationHelper().getPromptUserForNotificationEditor((NotificationContext)context)) {
                    institutionalProposalForm.getNotificationHelper().initializeDefaultValues((NotificationContext)context);
                    forward = mapping.findForward("notificationEditor");
                } else {
                    this.getNotificationService().sendNotification((NotificationContext)context);
                }
            }
        }
        return forward;
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        InstitutionalProposalDocument document = institutionalProposalForm.getInstitutionalProposalDocument();
        List specialReviews = document.getInstitutionalProposal().getSpecialReviews();
        List linkedProtocolNumbers = institutionalProposalForm.getSpecialReviewHelper().getLinkedProtocolNumbers();
        boolean isIPIrbProtocolLinkingEnabled = institutionalProposalForm.getSpecialReviewHelper().getIsIrbProtocolLinkingEnabled();
        boolean isIPIacucProtocolLinkingEnabled = institutionalProposalForm.getSpecialReviewHelper().getIsIacucProtocolLinkingEnabled();
        if ((isIPIrbProtocolLinkingEnabled || isIPIacucProtocolLinkingEnabled) && this.applyRules((KualiDocumentEvent)new SaveSpecialReviewLinkEvent((Document)document, specialReviews, linkedProtocolNumbers))) {
            institutionalProposalForm.getSpecialReviewHelper().syncProtocolFundingSourcesWithSpecialReviews();
        }
        if (this.applyRules((KualiDocumentEvent)new SaveSpecialReviewEvent(SAVE_SPECIAL_REVIEW_FIELD, (Document)document, specialReviews, isIPIrbProtocolLinkingEnabled, isIPIacucProtocolLinkingEnabled))) {
            this.getDocumentService().saveDocument((Document)document);
            if (!document.getInstitutionalProposal().getSpecialReviews().isEmpty()) {
                document.getInstitutionalProposal().setSpecialReviewIndicator("1");
            } else {
                document.getInstitutionalProposal().setSpecialReviewIndicator("0");
            }
            forward = super.save(mapping, form, request, response);
        }
        return forward;
    }

    public ActionForward viewNewSpecialReviewProtocolLink(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String viewProtocolUrl = "";
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        InstitutionalProposalSpecialReview institutionalProposalSpecialReview = (InstitutionalProposalSpecialReview)institutionalProposalForm.getSpecialReviewHelper().getNewSpecialReview();
        viewProtocolUrl = this.getViewProtocolUrl(institutionalProposalSpecialReview);
        return new ActionForward(viewProtocolUrl, true);
    }

    public ActionForward viewSpecialReviewProtocolLink(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String viewProtocolUrl = "";
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        String lineNumber = request.getParameter("line");
        if (NumberUtils.isNumber((String)lineNumber)) {
            int index = Integer.parseInt(lineNumber);
            InstitutionalProposalSpecialReview institutionalProposalSpecialReview = (InstitutionalProposalSpecialReview)institutionalProposalForm.getInstitutionalProposalDocument().getInstitutionalProposal().getSpecialReviews().get(index);
            viewProtocolUrl = this.getViewProtocolUrl(institutionalProposalSpecialReview);
        }
        return new ActionForward(viewProtocolUrl, true);
    }

    private String getViewProtocolUrl(InstitutionalProposalSpecialReview specialReview) throws Exception {
        String viewProtocolUrl = "";
        String protocolNumber = specialReview.getProtocolNumber();
        String routeHeaderId = this.getSpecialReviewService().getViewSpecialReviewProtocolRouteHeaderId(protocolNumber, specialReview.getSpecialReviewTypeCode());
        if (StringUtils.isNotEmpty((String)routeHeaderId)) {
            viewProtocolUrl = this.buildForwardUrl(routeHeaderId) + "&viewDocument=true";
        }
        return viewProtocolUrl;
    }

    public SpecialReviewService getSpecialReviewService() {
        if (this.specialReviewService == null) {
            this.specialReviewService = (SpecialReviewService)KraServiceLocator.getService(SpecialReviewService.class);
        }
        return this.specialReviewService;
    }

    public void setSpecialReviewService(SpecialReviewService specialReviewService) {
        this.specialReviewService = specialReviewService;
    }
}

