/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.notification.bo.KcNotification;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.ProtocolStatus;
import org.kuali.kra.irb.actions.risklevel.ProtocolRiskLevel;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionStatus;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionType;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentFilter;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentProtocol;
import org.kuali.kra.irb.personnel.ProtocolPersonnelService;
import org.kuali.kra.irb.protocol.participant.ProtocolParticipant;
import org.kuali.kra.irb.protocol.research.ProtocolResearchArea;
import org.kuali.kra.irb.questionnaire.ProtocolModuleQuestionnaireBean;
import org.kuali.kra.irb.summary.ParticipantSummary;
import org.kuali.kra.irb.summary.ProtocolSummary;
import org.kuali.kra.krms.KrmsRulesContext;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.ProtocolStatusBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionStatusBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionTypeBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentFilterBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaBase;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.ModuleQuestionnaireBean;

public class Protocol
extends ProtocolBase {
    private static final long serialVersionUID = 4396393806439396971L;
    private static final String DEFAULT_PROTOCOL_TYPE_CODE = "1";
    private String vulnerableSubjectIndicator;
    private List<ProtocolRiskLevel> protocolRiskLevels = new ArrayList();
    private List<ProtocolParticipant> protocolParticipants = new ArrayList();
    private transient boolean lookupActionNotifyIRBProtocol;

    public String getVulnerableSubjectIndicator() {
        return this.vulnerableSubjectIndicator;
    }

    public void setVulnerableSubjectIndicator(String vulnerableSubjectIndicator) {
        this.vulnerableSubjectIndicator = vulnerableSubjectIndicator;
    }

    public List<ProtocolRiskLevel> getProtocolRiskLevels() {
        return this.protocolRiskLevels;
    }

    public void setProtocolRiskLevels(List<ProtocolRiskLevel> protocolRiskLevels) {
        this.protocolRiskLevels = protocolRiskLevels;
        for (ProtocolRiskLevel riskLevel : protocolRiskLevels) {
            riskLevel.init((ProtocolBase)this);
        }
    }

    public List<ProtocolParticipant> getProtocolParticipants() {
        return this.protocolParticipants;
    }

    public void setProtocolParticipants(List<ProtocolParticipant> protocolParticipants) {
        this.protocolParticipants = protocolParticipants;
        for (ProtocolParticipant participant : protocolParticipants) {
            participant.init((ProtocolBase)this);
        }
    }

    public ProtocolParticipant getProtocolParticipant(int index) {
        return (ProtocolParticipant)this.getProtocolParticipants().get(index);
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getProtocolRiskLevels());
        managedLists.add(this.getProtocolParticipants());
        return managedLists;
    }

    protected ProtocolPersonnelService getProtocolPersonnelService() {
        ProtocolPersonnelService protocolPersonnelService = (ProtocolPersonnelService)KraServiceLocator.getService(ProtocolPersonnelService.class);
        return protocolPersonnelService;
    }

    public ProtocolSubmission getProtocolSubmission() {
        return (ProtocolSubmission)super.getProtocolSubmission();
    }

    public ProtocolAction getLastProtocolAction() {
        return (ProtocolAction)super.getLastProtocolAction();
    }

    public void merge(ProtocolBase amendment, String protocolModuleTypeCode) {
        if (StringUtils.equals((String)protocolModuleTypeCode, (String)"001")) {
            this.mergeGeneralInfo(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"004")) {
            this.mergeResearchAreas(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"024")) {
            this.mergeFundingSources(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"017")) {
            this.mergeOrganizations(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"002")) {
            this.mergePersonnel(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"008")) {
            if (amendment.isAmendment() || amendment.isRenewal() || !amendment.getAttachmentProtocols().isEmpty() && this.getAttachmentProtocols().isEmpty()) {
                this.mergeAttachments(amendment);
            } else {
                this.restoreAttachments((ProtocolBase)this);
            }
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"016")) {
            this.mergeReferences(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"007")) {
            this.mergeSpecialReview(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"006")) {
            this.mergeSubjects((Protocol)amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"023")) {
            this.mergeOthers(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"025")) {
            this.mergeProtocolPermissions(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"026")) {
            this.mergeProtocolQuestionnaire(amendment);
        }
    }

    protected List<AnswerHeader> getAnswerHeaderForProtocol(ProtocolBase protocol) {
        ProtocolModuleQuestionnaireBean moduleQuestionnaireBean = new ProtocolModuleQuestionnaireBean((Protocol)protocol);
        moduleQuestionnaireBean.setModuleSubItemCode("0");
        ArrayList<AnswerHeader> answerHeaders = new ArrayList();
        answerHeaders = this.getQuestionnaireAnswerService().getQuestionnaireAnswer((ModuleQuestionnaireBean)moduleQuestionnaireBean);
        return answerHeaders;
    }

    protected void mergeProtocolAction(ProtocolBase amendment) {
        List protocolActions = (List)this.deepCopy((Object)amendment.getProtocolActions());
        Collections.sort(protocolActions, new /* Unavailable Anonymous Inner Class!! */);
        protocolActions.remove(0);
        protocolActions.remove(protocolActions.size() - 1);
        for (ProtocolAction protocolAction : protocolActions) {
            protocolAction.setProtocolNumber(this.getProtocolNumber());
            protocolAction.setProtocolActionId(null);
            protocolAction.setSequenceNumber(this.getSequenceNumber());
            protocolAction.setProtocolId(this.getProtocolId());
            String index = amendment.getProtocolNumber().substring(11);
            protocolAction.setActionId(this.getNextValue("actionId"));
            String type = "Amendment";
            if (amendment.isRenewal()) {
                type = "Renewal";
            }
            if (StringUtils.isNotBlank((String)protocolAction.getComments())) {
                protocolAction.setComments(type + "-" + index + ": " + protocolAction.getComments());
            } else {
                protocolAction.setComments(type + "-" + index + ": ");
            }
            for (KcNotification notification : protocolAction.getProtocolNotifications()) {
                notification.setDocumentNumber(this.getProtocolDocument().getDocumentNumber());
                notification.resetPersistenceState();
                notification.setOwningDocumentIdFk(null);
            }
            for (KcNotification notification : protocolAction.getProtocolNotifications()) {
                notification.setDocumentNumber(this.getProtocolDocument().getDocumentNumber());
                notification.resetPersistenceState();
            }
            this.getProtocolActions().add(protocolAction);
        }
    }

    private void mergeSubjects(Protocol amendment) {
        this.setProtocolParticipants((List)this.deepCopy((Object)amendment.getProtocolParticipants()));
    }

    public ProtocolSummary getProtocolSummary() {
        ProtocolSummary protocolSummary = this.createProtocolSummary();
        this.addPersonnelSummaries((org.kuali.kra.protocol.summary.ProtocolSummary)protocolSummary);
        this.addResearchAreaSummaries((org.kuali.kra.protocol.summary.ProtocolSummary)protocolSummary);
        this.addAttachmentSummaries((org.kuali.kra.protocol.summary.ProtocolSummary)protocolSummary);
        this.addFundingSourceSummaries((org.kuali.kra.protocol.summary.ProtocolSummary)protocolSummary);
        this.addParticipantSummaries(protocolSummary);
        this.addOrganizationSummaries((org.kuali.kra.protocol.summary.ProtocolSummary)protocolSummary);
        this.addSpecialReviewSummaries((org.kuali.kra.protocol.summary.ProtocolSummary)protocolSummary);
        this.addAdditionalInfoSummary((org.kuali.kra.protocol.summary.ProtocolSummary)protocolSummary);
        return protocolSummary;
    }

    private void addParticipantSummaries(ProtocolSummary protocolSummary) {
        for (ProtocolParticipant participant : this.getProtocolParticipants()) {
            ParticipantSummary participantSummary = new ParticipantSummary();
            participantSummary.setDescription(participant.getParticipantType().getDescription());
            participantSummary.setCount(participant.getParticipantCount());
            protocolSummary.add(participantSummary);
        }
    }

    protected ProtocolSummary createProtocolSummary() {
        ProtocolSummary summary = new ProtocolSummary();
        summary.setLastProtocolAction((ProtocolActionBase)this.getLastProtocolAction());
        summary.setProtocolNumber(this.getProtocolNumber().toString());
        summary.setPiName(this.getPrincipalInvestigator().getPersonName());
        summary.setPiProtocolPersonId(this.getPrincipalInvestigator().getProtocolPersonId());
        summary.setInitialSubmissionDate(this.getInitialSubmissionDate());
        summary.setApprovalDate(this.getApprovalDate());
        summary.setLastApprovalDate(this.getLastApprovalDate());
        summary.setExpirationDate(this.getExpirationDate());
        if (this.getProtocolType() == null) {
            this.refreshReferenceObject("protocolType");
        }
        summary.setType(this.getProtocolType().getDescription());
        if (this.getProtocolStatus() == null) {
            this.refreshReferenceObject("protocolStatus");
        }
        summary.setStatus(this.getProtocolStatus().getDescription());
        summary.setTitle(this.getTitle());
        return summary;
    }

    public String getDocumentKey() {
        return "protocol";
    }

    public List<String> getRoleNames() {
        ArrayList<String> roleNames = new ArrayList<String>();
        roleNames.add("Protocol Aggregator");
        roleNames.add("Protocol Viewer");
        return roleNames;
    }

    public String getNamespace() {
        return "KC-PROTOCOL";
    }

    public String getDocumentRoleTypeCode() {
        return "KC-PROTOCOL";
    }

    public void initializeProtocolAttachmentFilter() {
        ProtocolAttachmentFilter protocolAttachmentFilter = new ProtocolAttachmentFilter();
        try {
            String defaultSortBy = this.getParameterService().getParameterValueAsString(ProtocolDocument.class, "protocolAttachmentDefaultSort");
            if (StringUtils.isNotBlank((String)defaultSortBy)) {
                protocolAttachmentFilter.setSortBy(defaultSortBy);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setProtocolAttachmentFilter((ProtocolAttachmentFilterBase)protocolAttachmentFilter);
    }

    public KrmsRulesContext getKrmsRulesContext() {
        return this.getProtocolDocument();
    }

    protected ProtocolStatusBase getProtocolStatusNewInstanceHook() {
        return new ProtocolStatus();
    }

    protected String getDefaultProtocolStatusCodeHook() {
        return "100";
    }

    protected String getDefaultProtocolTypeCodeHook() {
        return DEFAULT_PROTOCOL_TYPE_CODE;
    }

    protected ProtocolResearchAreaBase getNewProtocolResearchAreaInstance() {
        return new ProtocolResearchArea();
    }

    protected ProtocolSubmissionStatusBase getProtocolSubmissionStatusNewInstanceHook() {
        return new ProtocolSubmissionStatus();
    }

    protected ProtocolSubmissionTypeBase getProtocolSubmissionTypeNewInstanceHook() {
        return new ProtocolSubmissionType();
    }

    protected ProtocolSubmissionBase getProtocolSubmissionNewInstanceHook() {
        return new ProtocolSubmission();
    }

    protected String getProtocolModuleAddModifyAttachmentCodeHook() {
        return "008";
    }

    protected Class<? extends ProtocolAttachmentProtocolBase> getProtocolAttachmentProtocolClassHook() {
        return ProtocolAttachmentProtocol.class;
    }

    public boolean isLookupActionNotifyIRBProtocol() {
        return this.lookupActionNotifyIRBProtocol;
    }

    public void setLookupActionNotifyIRBProtocol(boolean lookupActionNotifyIRBProtocol) {
        this.lookupActionNotifyIRBProtocol = lookupActionNotifyIRBProtocol;
    }
}

