/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.committee.bo.CommitteeBatchCorrespondenceDetail;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.common.notification.NotificationRenderer;
import org.kuali.kra.common.notification.bo.KcNotification;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolFinderDao;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.actions.ProtocolSubmissionBeanBase;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.irb.correspondence.ProtocolCorrespondence;
import org.kuali.kra.irb.notification.IRBNotificationContext;
import org.kuali.kra.irb.notification.IRBNotificationRenderer;
import org.kuali.kra.irb.notification.IRBProtocolNotification;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReviewService;
import org.kuali.kra.irb.personnel.ProtocolPersonTrainingService;
import org.kuali.kra.irb.personnel.ProtocolPersonnelService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.protocol.ProtocolActionBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.kra.protocol.notification.ProtocolNotification;
import org.kuali.kra.protocol.notification.ProtocolNotificationContextBase;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.print.QuestionnairePrintingService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

public abstract class ProtocolAction
extends ProtocolActionBase {
    public static final String PROTOCOL_NAME_HOOK = "protocol";
    public static final String PROTOCOL_QUESTIONNAIRE_HOOK = "questionnaire";
    public static final String PROTOCOL_PERSONNEL_HOOK = "personnel";
    public static final String PROTOCOL_SPECIAL_REVIEW_HOOK = "specialReview";
    public static final String PROTOCOL_NOTE_ATTACHMENT_HOOK = "noteAndAttachment";
    public static final String PROTOCOL_ACTIONS_HOOK = "protocolActions";
    public static final String PROTOCOL_ONLINE_REVIEW_HOOK = "onlineReview";
    public static final String PROTOCOL_PERMISSIONS_HOOK = "permissions";
    public static final String PROTOCOL_CUSTOM_DATA_HOOK = "customData";
    public static final String PROTOCOL_MEDUSA = "medusa";
    private static final Log LOG = LogFactory.getLog(ProtocolAction.class);
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    private static final String SUBMISSION_NUMBER = "submissionNumber";
    private static final String SUFFIX_T = "T";
    private static final String NOT_FOUND_SELECTION = "The attachment was not found for selection ";
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;

    protected ProtocolSubmissionBeanBase getSubmissionBean(ActionForm form, String submissionActionType) {
        Object submissionBean = null;
        submissionBean = "116".equals(submissionActionType) ? ((ProtocolForm)form).getActionHelper().getProtocolNotifyIrbBean() : ((ProtocolForm)form).getActionHelper().getRequestBean(submissionActionType);
        return submissionBean;
    }

    public ActionForward customData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ((ProtocolForm)form).getCustomDataHelper().prepareCustomData();
        return this.branchToPanelOrNotificationEditor(mapping, (ProtocolFormBase)form, this.getCustomDataForwardNameHook());
    }

    public ActionForward medusa(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (protocolForm.getProtocolDocument().getDocumentNumber() == null) {
            this.loadDocument((KualiDocumentFormBase)protocolForm);
        }
        protocolForm.getMedusaBean().setMedusaViewRadio("0");
        protocolForm.getMedusaBean().setModuleName("irb");
        protocolForm.getMedusaBean().setModuleIdentifier(protocolForm.getProtocolDocument().getProtocol().getProtocolId());
        protocolForm.getMedusaBean().generateParentNodes();
        return this.branchToPanelOrNotificationEditor(mapping, (ProtocolFormBase)protocolForm, PROTOCOL_MEDUSA);
    }

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        ProtocolForm protocolForm = (ProtocolForm)form;
        String command = protocolForm.getCommand();
        if (command.startsWith("displayDocSearchViewdetailId")) {
            String detailId = command.substring("displayDocSearchViewdetailId".length());
            protocolForm.setDetailId(detailId);
            this.viewBatchCorrespondence(mapping, (ActionForm)protocolForm, request, response);
            return RESPONSE_ALREADY_HANDLED;
        }
        if ("displayActionListInlineView".equals(command)) {
            String docIdRequestParameter = request.getParameter("docId");
            Document retrievedDocument = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
            protocolForm.setDocument(retrievedDocument);
            request.setAttribute("docId", (Object)docIdRequestParameter);
            forward = mapping.findForward("copyProposal");
            forward = new ActionForward(forward.getPath() + "?" + "docId" + "=" + docIdRequestParameter);
        } else if (PROTOCOL_ACTIONS_HOOK.equals(command) || PROTOCOL_ONLINE_REVIEW_HOOK.equals(command)) {
            String docIdRequestParameter = request.getParameter("docId");
            Document retrievedDocument = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
            protocolForm.setDocument(retrievedDocument);
            request.setAttribute("docId", (Object)docIdRequestParameter);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
        } else {
            forward = super.docHandler(mapping, form, request, response);
        }
        if ("initiate".equals(protocolForm.getCommand())) {
            protocolForm.getProtocolDocument().initialize();
        } else {
            protocolForm.initialize();
        }
        if (PROTOCOL_ACTIONS_HOOK.equals(command)) {
            forward = this.protocolActions(mapping, (ActionForm)protocolForm, request, response);
        }
        if (PROTOCOL_ONLINE_REVIEW_HOOK.equals(command)) {
            forward = this.onlineReview(mapping, (ActionForm)protocolForm, request, response);
        }
        return forward;
    }

    protected ProtocolPersonTrainingService getProtocolPersonTrainingService() {
        return (ProtocolPersonTrainingService)KraServiceLocator.getService((String)"protocolPersonTrainingService");
    }

    protected ProtocolPersonnelService getProtocolPersonnelService() {
        return (ProtocolPersonnelService)KraServiceLocator.getService((String)"protocolPersonnelService");
    }

    protected ProtocolOnlineReviewService getProtocolOnlineReviewService() {
        return (ProtocolOnlineReviewService)KraServiceLocator.getService(ProtocolOnlineReviewService.class);
    }

    public ActionForward printSubmissionQuestionnaireAnswer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Protocol protocol;
        ActionForward forward = mapping.findForward("basic");
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        AnswerHeader answerHeader = this.getAnswerHeader(request);
        reportParameters.put("questionnaireId", answerHeader.getQuestionnaire().getQuestionnaireIdAsInteger());
        reportParameters.put("template", answerHeader.getQuestionnaire().getTemplate());
        if ("2".equals(answerHeader.getModuleSubItemCode())) {
            reportParameters.put(PROTOCOL_NUMBER, answerHeader.getModuleItemKey());
            reportParameters.put(SUBMISSION_NUMBER, answerHeader.getModuleSubItemKey());
            protocol = this.getProtocolFinder().findCurrentProtocolByNumber(this.getProtocolNumber(answerHeader));
        } else {
            HashMap<String, String> keyValues = new HashMap<String, String>();
            keyValues.put(PROTOCOL_NUMBER, answerHeader.getModuleItemKey());
            keyValues.put("sequenceNumber", answerHeader.getModuleSubItemKey());
            protocol = (Protocol)((List)this.getBusinessObjectService().findMatching(Protocol.class, keyValues)).get(0);
        }
        AttachmentDataSource dataStream = this.getQuestionnairePrintingService().printQuestionnaireAnswer((KraPersistableBusinessObjectBase)protocol, reportParameters);
        if (dataStream.getContent() != null) {
            this.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    private AnswerHeader getAnswerHeader(HttpServletRequest request) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("answerHeaderId", Integer.toString(this.getSelectedLine(request)));
        return (AnswerHeader)this.getBusinessObjectService().findByPrimaryKey(AnswerHeader.class, fieldValues);
    }

    protected QuestionnairePrintingService getQuestionnairePrintingService() {
        return (QuestionnairePrintingService)KraServiceLocator.getService(QuestionnairePrintingService.class);
    }

    private String getProtocolNumber(AnswerHeader answerHeader) {
        String protocolNumber = answerHeader.getModuleItemKey();
        if (protocolNumber.endsWith(SUFFIX_T)) {
            protocolNumber = protocolNumber.substring(0, protocolNumber.length() - 1);
        }
        return protocolNumber;
    }

    private ProtocolFinderDao getProtocolFinder() {
        return (ProtocolFinderDao)KraServiceLocator.getService(ProtocolFinderDao.class);
    }

    private void viewBatchCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        HashMap<String, Object> primaryKeys = new HashMap<String, Object>();
        primaryKeys.put("committeeBatchCorrespondenceDetailId", protocolForm.getDetailId());
        CommitteeBatchCorrespondenceDetail batchCorrespondenceDetail = (CommitteeBatchCorrespondenceDetail)this.getBusinessObjectService().findByPrimaryKey(CommitteeBatchCorrespondenceDetail.class, primaryKeys);
        primaryKeys.clear();
        primaryKeys.put("id", batchCorrespondenceDetail.getProtocolCorrespondenceId());
        ProtocolCorrespondence attachment = (ProtocolCorrespondence)this.getBusinessObjectService().findByPrimaryKey(ProtocolCorrespondence.class, primaryKeys);
        if (attachment == null) {
            LOG.info((Object)("The attachment was not found for selection detailID: " + protocolForm.getDetailId()));
        } else {
            this.streamToResponse(attachment.getCorrespondence(), StringUtils.replace((String)attachment.getProtocolCorrespondenceType().getDescription(), (String)" ", (String)"") + ".pdf", "application/pdf", response);
        }
    }

    protected void sendNotification(ProtocolFormBase protocolForm) {
        Protocol protocol = (Protocol)protocolForm.getProtocolDocument().getProtocol();
        IRBNotificationRenderer renderer = new IRBNotificationRenderer(protocol);
        IRBNotificationContext context = new IRBNotificationContext(protocol, "320", "Created", (NotificationRenderer)renderer);
        KcNotificationService notificationService = (KcNotificationService)KraServiceLocator.getService(KcNotificationService.class);
        notificationService.sendNotificationAndPersist((NotificationContext)context, (KcNotification)new IRBProtocolNotification(), (KraPersistableBusinessObjectBase)protocol);
    }

    protected String getProtocolForwardNameHook() {
        return PROTOCOL_NAME_HOOK;
    }

    protected String getQuestionnaireForwardNameHook() {
        return PROTOCOL_QUESTIONNAIRE_HOOK;
    }

    protected String getPersonnelForwardNameHook() {
        return PROTOCOL_PERSONNEL_HOOK;
    }

    protected String getNoteAndAttachmentForwardNameHook() {
        return PROTOCOL_NOTE_ATTACHMENT_HOOK;
    }

    protected String getProtocolActionsForwardNameHook() {
        return PROTOCOL_ACTIONS_HOOK;
    }

    protected String getProtocolOnlineReviewForwardNameHook() {
        return PROTOCOL_ONLINE_REVIEW_HOOK;
    }

    protected String getProtocolPermissionsForwardNameHook() {
        return PROTOCOL_PERMISSIONS_HOOK;
    }

    protected String getSpecialReviewForwardNameHook() {
        return PROTOCOL_SPECIAL_REVIEW_HOOK;
    }

    protected String getCustomDataForwardNameHook() {
        return PROTOCOL_CUSTOM_DATA_HOOK;
    }

    protected ProtocolNotification getProtocolNotificationHook() {
        return new IRBProtocolNotification();
    }

    protected ProtocolTaskBase createNewModifyProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("modifyProtocol", (Protocol)protocol);
    }

    protected void initialDocumentSaveAddRolesHook(String userId, ProtocolBase protocol) {
        KraAuthorizationService kraAuthService = this.getKraAuthorizationService();
        kraAuthService.addRole(userId, "Protocol Aggregator", (Permissionable)protocol);
        kraAuthService.addRole(userId, "ProtocolApprover", (Permissionable)protocol);
    }

    protected String getProtocolOnlineReviewMappingNameHoook() {
        return PROTOCOL_ONLINE_REVIEW_HOOK;
    }

    protected String getProtocolActionsMappingNameHoook() {
        return PROTOCOL_ACTIONS_HOOK;
    }

    protected String getProtocolNotificationEditorHook() {
        return "protocolNotificationEditor";
    }

    protected ProtocolNotificationContextBase getProtocolInitialSaveNotificationContextHook(ProtocolBase protocol) {
        IRBNotificationRenderer renderer = new IRBNotificationRenderer((Protocol)protocol);
        return new IRBNotificationContext((Protocol)protocol, "320", "Protocol Created", (NotificationRenderer)renderer, PROTOCOL_NAME_HOOK);
    }
}

