/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.CustomAttributeDocValue;
import org.kuali.kra.bo.DocumentCustomData;
import org.kuali.kra.bo.ResearchAreaBase;
import org.kuali.kra.common.notification.NotificationRenderer;
import org.kuali.kra.common.notification.bo.KcNotification;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolFinderDao;
import org.kuali.kra.irb.ProtocolVersionService;
import org.kuali.kra.irb.ResearchArea;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.notification.ProtocolDisapprovedNotificationRenderer;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.correspondence.ProtocolCorrespondence;
import org.kuali.kra.irb.notification.IRBNotificationContext;
import org.kuali.kra.irb.notification.IRBProtocolNotification;
import org.kuali.kra.irb.protocol.location.ProtocolLocationService;
import org.kuali.kra.irb.protocol.research.ProtocolResearchAreaService;
import org.kuali.kra.krms.service.impl.KcKrmsFactBuilderServiceHelper;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.notification.ProtocolNotification;
import org.kuali.kra.protocol.notification.ProtocolNotificationContextBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krms.api.engine.Facts;

@ParameterConstants.NAMESPACE(namespace="KC-PROTOCOL")
@ParameterConstants.COMPONENT(component="Document")
public class ProtocolDocument
extends ProtocolDocumentBase {
    private static final long serialVersionUID = 803158468103165087L;
    private static final Log LOG = LogFactory.getLog(ProtocolDocument.class);
    public static final String DOCUMENT_TYPE_CODE = "PROT";
    private static final String APPROVED_COMMENT = "Approved";
    private static final String DISAPPROVED_COMMENT = "Disapproved";
    private static final String listOfStatiiEligibleForMerging = "101 102 103 104 105 106 302 303 304";
    private static final String DISAPPROVED_CONTEXT_NAME = "Disapproved";
    private List<CustomAttributeDocValue> customDataList = new ArrayList();

    public Protocol getProtocol() {
        return (Protocol)super.getProtocol();
    }

    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    protected void mergeProtocolAmendment() {
        if (this.isAmendment()) {
            this.mergeAmendment("400", "Amendment");
        } else if (this.isRenewal()) {
            this.mergeAmendment("401", "Renewal");
        }
    }

    protected void mergeAmendment(String protocolStatusCode, String type) {
        ProtocolDocument newProtocolDocument;
        Protocol currentProtocol = this.getProtocolFinder().findCurrentProtocolByNumber(this.getOriginalProtocolNumber());
        try {
            currentProtocol.setProtocolDocument((ProtocolDocumentBase)((ProtocolDocument)this.getDocumentService().getByDocumentHeaderId(currentProtocol.getProtocolDocument().getDocumentNumber())));
            currentProtocol.setMergeAmendment(true);
            newProtocolDocument = (ProtocolDocument)this.getProtocolVersionService().versionProtocolDocument(currentProtocol.getProtocolDocument());
        }
        catch (Exception e) {
            throw new ProtocolDocumentBase.ProtocolMergeException((Throwable)e);
        }
        newProtocolDocument.getProtocol().merge((ProtocolBase)this.getProtocol());
        this.getProtocol().setProtocolStatusCode(protocolStatusCode);
        ProtocolAction action = new ProtocolAction(newProtocolDocument.getProtocol(), null, "204");
        action.setComments(type + "-" + this.getProtocolNumberIndex() + ": Approved");
        newProtocolDocument.setProtocolWorkflowType(ProtocolDocumentBase.ProtocolWorkflowType.APPROVED);
        newProtocolDocument.getProtocol().getProtocolActions().add(action);
        try {
            this.getDocumentService().saveDocument((Document)newProtocolDocument);
            newProtocolDocument.getDocumentHeader().getWorkflowDocument().route(type + "-" + this.getProtocolNumberIndex() + ": merged");
        }
        catch (WorkflowException e) {
            throw new ProtocolDocumentBase.ProtocolMergeException((Throwable)e);
        }
        this.getProtocol().setActive(false);
        for (ProtocolBase otherProtocol : this.getProtocolFinder().findProtocols(this.getOriginalProtocolNumber())) {
            String status = otherProtocol.getProtocolStatus().getProtocolStatusCode();
            if (!this.isEligibleForMerging(status, (Protocol)otherProtocol)) continue;
            LOG.info((Object)("Merging amendment " + this.getProtocol().getProtocolNumber() + " into editable protocol " + otherProtocol.getProtocolNumber()));
            otherProtocol.merge((ProtocolBase)this.getProtocol(), false);
            String protocolType = protocolStatusCode.equals("400") ? "103" : "102";
            action = new ProtocolAction((Protocol)otherProtocol, null, protocolType);
            action.setComments(type + "-" + this.getProtocolNumberIndex() + ": Merged");
            otherProtocol.getProtocolActions().add(action);
            this.getBusinessObjectService().save((PersistableBusinessObject)otherProtocol);
        }
        this.finalizeAttachmentProtocol(this.getProtocol());
        this.getBusinessObjectService().save((PersistableBusinessObject)this);
        this.mergeProtocolCorrespondenceAndNotification(newProtocolDocument, this.getProtocol().getLastProtocolAction().getProtocolActionTypeCode());
    }

    protected void mergeProtocolCorrespondenceAndNotification(ProtocolDocument newProtocolDocument, String protocolActionType) {
        ProtocolAction getProtocolPaToUse = null;
        for (ProtocolActionBase pa : this.getProtocol().getProtocolActions()) {
            if (!StringUtils.equals((String)protocolActionType, (String)pa.getProtocolActionTypeCode()) || getProtocolPaToUse != null && !getProtocolPaToUse.getUpdateTimestamp().before(pa.getUpdateTimestamp())) continue;
            getProtocolPaToUse = (ProtocolAction)pa;
        }
        ProtocolAction newDocPaToUse = null;
        for (ProtocolActionBase pa2 : newProtocolDocument.getProtocol().getProtocolActions()) {
            if (!StringUtils.equals((String)"204", (String)pa2.getProtocolActionTypeCode()) || newDocPaToUse != null && !newDocPaToUse.getUpdateTimestamp().before(pa2.getUpdateTimestamp())) continue;
            newDocPaToUse = (ProtocolAction)pa2;
        }
        if (newDocPaToUse != null && getProtocolPaToUse != null) {
            for (org.kuali.kra.protocol.correspondence.ProtocolCorrespondence pc : getProtocolPaToUse.getProtocolCorrespondences()) {
                ProtocolCorrespondence newPc = new ProtocolCorrespondence();
                newPc.setActionId(pc.getActionId());
                newPc.setActionIdFk(newDocPaToUse.getProtocolActionId());
                newPc.setCorrespondence(pc.getCorrespondence());
                newPc.setCreateTimestamp(pc.getCreateTimestamp());
                newPc.setCreateUser(pc.getCreateUser());
                newPc.setExtension(pc.getExtension());
                newPc.setFinalFlag(pc.getFinalFlag());
                newPc.setFinalFlagTimestamp(pc.getFinalFlagTimestamp());
                newPc.setForwardName(pc.getForwardName());
                newPc.setHoldingPage(pc.isHoldingPage());
                newPc.setNewCollectionRecord(pc.isNewCollectionRecord());
                newPc.setNotificationRequestBean(pc.getNotificationRequestBean());
                newPc.setProtocol(newDocPaToUse.getProtocol());
                newPc.setProtocolAction((ProtocolActionBase)newDocPaToUse);
                newPc.setProtocolCorrespondenceType(pc.getProtocolCorrespondenceType());
                newPc.setProtocolId(newDocPaToUse.getProtocolId());
                newPc.setProtocolNumber(newDocPaToUse.getProtocolNumber());
                newPc.setProtoCorrespTypeCode(pc.getProtoCorrespTypeCode());
                newPc.setRegenerateFlag(pc.isRegenerateFlag());
                newPc.setSequenceNumber(pc.getSequenceNumber());
                if (newDocPaToUse.getProtocolCorrespondences() == null) {
                    newDocPaToUse.setProtocolCorrespondences(new ArrayList());
                }
                newDocPaToUse.getProtocolCorrespondences().add(newPc);
                this.getBusinessObjectService().save((PersistableBusinessObject)newPc);
            }
            for (KcNotification notification : getProtocolPaToUse.getProtocolNotifications()) {
                KcNotification newNotification = this.getKcNotificationService().copy(notification);
                this.getBusinessObjectService().save((PersistableBusinessObject)newNotification);
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)newDocPaToUse);
        }
    }

    private KcNotificationService getKcNotificationService() {
        return (KcNotificationService)KraServiceLocator.getService(KcNotificationService.class);
    }

    private boolean isEligibleForMerging(String status, Protocol otherProtocol) {
        return listOfStatiiEligibleForMerging.contains(status) && !StringUtils.equals((String)this.getProtocol().getProtocolNumber(), (String)otherProtocol.getProtocolNumber());
    }

    private void finalizeAttachmentProtocol(Protocol protocol) {
        for (ProtocolAttachmentProtocolBase attachment : protocol.getAttachmentProtocols()) {
            attachment.setProtocol((ProtocolBase)protocol);
            if (!attachment.isDraft()) continue;
            attachment.setDocumentStatusCode("2");
        }
    }

    private ProtocolVersionService getProtocolVersionService() {
        return (ProtocolVersionService)KraServiceLocator.getService(ProtocolVersionService.class);
    }

    private ProtocolFinderDao getProtocolFinder() {
        return (ProtocolFinderDao)KraServiceLocator.getService(ProtocolFinderDao.class);
    }

    public boolean isProcessComplete() {
        boolean isComplete = true;
        if (this.getProtocol().getProtocolStatusCode().equals("101")) {
            if (this.getWorkflowDocumentService().getCurrentRouteNodeNames(this.getDocumentHeader().getWorkflowDocument()).equalsIgnoreCase("Initiated")) {
                isComplete = false;
            }
            this.getProtocol().getProtocolSubmission().refreshReferenceObject("submissionStatus");
            String status = this.getProtocol().getProtocolSubmission().getSubmissionStatusCode();
            if ((this.isAmendment() || this.isRenewal()) && status.equals("203") && this.getWorkflowDocumentService().getCurrentRouteNodeNames(this.getDocumentHeader().getWorkflowDocument()).equalsIgnoreCase("IRBReview")) {
                isComplete = false;
            }
        } else {
            if (this.getProtocol().getProtocolStatusCode().equals("400") || this.getProtocol().getProtocolStatusCode().equals("401")) {
                String protocolId = this.getNewProtocolDocId();
                if (ObjectUtils.isNull((Object)protocolId)) {
                    isComplete = false;
                } else {
                    String oldLocation = (String)GlobalVariables.getUserSession().retrieveObject("holdingPageReturnLocation");
                    String oldDocNbr = this.getProtocol().getProtocolDocument().getDocumentNumber();
                    String returnLocation = oldLocation.replaceFirst(oldDocNbr, protocolId);
                    GlobalVariables.getUserSession().addObject("holdingPageReturnLocation", (Object)returnLocation);
                }
            }
            if (!this.getDocumentHeader().getWorkflowDocument().isFinal()) {
                isComplete = false;
            }
        }
        return isComplete;
    }

    public void populateContextQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("namespaceCode", "KC-PROTOCOL");
        qualifiers.put("name", "KC Protocol Context");
    }

    public void addFacts(Facts.Builder factsBuilder) {
        KcKrmsFactBuilderServiceHelper fbService = (KcKrmsFactBuilderServiceHelper)KraServiceLocator.getService((String)"irbProtocolFactBuilderService");
        fbService.addFacts(factsBuilder, (ResearchDocumentBase)this);
    }

    protected Protocol createNewProtocolInstanceHook() {
        return new Protocol();
    }

    protected Class<? extends org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaService> getProtocolResearchAreaServiceClassHook() {
        return ProtocolResearchAreaService.class;
    }

    protected Class<? extends ResearchAreaBase> getResearchAreaBoClassHook() {
        return ResearchArea.class;
    }

    protected ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase protocol, ProtocolSubmissionBase protocolSubmission, String actionTypeCode) {
        return new ProtocolAction((Protocol)protocol, (ProtocolSubmission)protocolSubmission, actionTypeCode);
    }

    protected Class<? extends org.kuali.kra.protocol.actions.submit.ProtocolActionService> getProtocolActionServiceClassHook() {
        return ProtocolActionService.class;
    }

    protected Class<? extends org.kuali.kra.protocol.protocol.location.ProtocolLocationService> getProtocolLocationServiceClassHook() {
        return ProtocolLocationService.class;
    }

    protected Class<? extends ProtocolBase> getProtocolBOClassHook() {
        return Protocol.class;
    }

    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return this.getCustomDataList();
    }

    public List<CustomAttributeDocValue> getCustomDataList() {
        return this.customDataList;
    }

    public void setCustomDataList(List<CustomAttributeDocValue> customDataList) {
        this.customDataList = customDataList;
    }

    protected Class<? extends ProtocolGenericActionService> getProtocolGenericActionServiceClassHook() {
        return ProtocolGenericActionService.class;
    }

    protected ProtocolNotification getNewProtocolNotificationInstanceHook() {
        return new IRBProtocolNotification();
    }

    protected ProtocolNotificationContextBase getDisapproveNotificationContextHook(ProtocolBase protocol) {
        return new IRBNotificationContext((Protocol)protocol, "304", "Disapproved", (NotificationRenderer)new ProtocolDisapprovedNotificationRenderer((Protocol)protocol));
    }

    protected String getCommitteeDisapprovedStatusCodeHook() {
        return "306";
    }
}

