/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.common.notification.web.struts.form.NotificationHelper;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ActionHelper;
import org.kuali.kra.irb.actions.ProtocolStatus;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.customdata.CustomDataHelper;
import org.kuali.kra.irb.noteattachment.NotesAttachmentsHelper;
import org.kuali.kra.irb.onlinereview.OnlineReviewsActionHelper;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReviewService;
import org.kuali.kra.irb.permission.PermissionsHelper;
import org.kuali.kra.irb.personnel.PersonnelHelper;
import org.kuali.kra.irb.protocol.ProtocolHelper;
import org.kuali.kra.irb.protocol.reference.ProtocolReferenceBean;
import org.kuali.kra.irb.questionnaire.ProtocolModuleQuestionnaireBean;
import org.kuali.kra.irb.questionnaire.QuestionnaireHelper;
import org.kuali.kra.irb.specialreview.SpecialReviewHelper;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.actions.ActionHelperBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.customdata.ProtocolCustomDataHelperBase;
import org.kuali.kra.protocol.noteattachment.NotesAttachmentsHelperBase;
import org.kuali.kra.protocol.notification.ProtocolNotificationContextBase;
import org.kuali.kra.protocol.onlinereview.OnlineReviewsActionHelperBase;
import org.kuali.kra.protocol.permission.PermissionsHelperBase;
import org.kuali.kra.protocol.personnel.PersonnelHelperBase;
import org.kuali.kra.protocol.protocol.ProtocolHelperBase;
import org.kuali.kra.protocol.protocol.reference.ProtocolReferenceBeanBase;
import org.kuali.kra.protocol.questionnaire.QuestionnaireHelperBase;
import org.kuali.kra.protocol.specialreview.ProtocolSpecialReviewHelperBase;
import org.kuali.kra.questionnaire.answer.ModuleQuestionnaireBean;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kns.datadictionary.HeaderNavigation;
import org.kuali.rice.kns.util.ActionFormUtilMap;
import org.kuali.rice.kns.web.ui.HeaderField;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolForm
extends ProtocolFormBase {
    private static final long serialVersionUID = 3736148760520952504L;
    private static final boolean HIDE_ONLINE_REVIEW_WHEN_DISABLED = true;
    private static final String ONLINE_REVIEW_NAV_TO = "onlineReview";
    private static final String CUSTOM_DATA_NAV_TO = "customData";

    protected String getDefaultDocumentTypeName() {
        return "ProtocolDocument";
    }

    public HeaderNavigation[] getHeaderNavigationTabs() {
        HeaderNavigation[] navigation = super.getHeaderNavigationTabs();
        ProtocolOnlineReviewService onlineReviewService = this.getProtocolOnlineReviewService();
        ArrayList<HeaderNavigation> resultList = new ArrayList<HeaderNavigation>();
        boolean onlineReviewTabEnabled = false;
        if (this.getProtocolDocument() != null && this.getProtocolDocument().getProtocol() != null) {
            String principalId = GlobalVariables.getUserSession().getPrincipalId();
            ProtocolSubmission submission = this.getProtocolDocument().getProtocol().getProtocolSubmission();
            boolean isUserOnlineReviewer = onlineReviewService.isProtocolReviewer(principalId, false, (ProtocolSubmissionBase)submission);
            boolean isUserIrbAdmin = this.getKraAuthorizationService().hasRole(GlobalVariables.getUserSession().getPrincipalId(), "KC-UNT", "IRB Administrator");
            onlineReviewTabEnabled = (isUserOnlineReviewer || isUserIrbAdmin) && onlineReviewService.isProtocolInStateToBeReviewed((ProtocolBase)this.getProtocolDocument().getProtocol());
        }
        for (HeaderNavigation nav : navigation) {
            if (StringUtils.equals((String)nav.getHeaderTabNavigateTo(), (String)ONLINE_REVIEW_NAV_TO)) {
                nav.setDisabled(!onlineReviewTabEnabled);
                if (!onlineReviewTabEnabled) {
                    if (onlineReviewTabEnabled) continue;
                    continue;
                }
                resultList.add(nav);
                continue;
            }
            if (StringUtils.equals((String)nav.getHeaderTabNavigateTo(), (String)CUSTOM_DATA_NAV_TO)) {
                boolean displayTab = this.getCustomDataHelper().canDisplayCustomDataTab();
                nav.setDisabled(!displayTab);
                if (!displayTab) continue;
                resultList.add(nav);
                continue;
            }
            resultList.add(nav);
        }
        HeaderNavigation[] result = new HeaderNavigation[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    protected ProtocolOnlineReviewService getProtocolOnlineReviewService() {
        return (ProtocolOnlineReviewService)KraServiceLocator.getService(ProtocolOnlineReviewService.class);
    }

    public void populate(HttpServletRequest request) {
        this.initAnswerList(request);
        super.populate(request);
        if (this.getActionFormUtilMap() instanceof ActionFormUtilMap) {
            ((ActionFormUtilMap)this.getActionFormUtilMap()).clear();
        }
    }

    private void initAnswerList(HttpServletRequest request) {
        String protocolNumber = request.getParameter("questionnaireHelper.protocolNumber");
        String submissionNumber = request.getParameter("questionnaireHelper.submissionNumber");
        if (StringUtils.isNotBlank((String)protocolNumber) && protocolNumber.endsWith("T")) {
            ProtocolModuleQuestionnaireBean moduleQuestionnaireBean = new ProtocolModuleQuestionnaireBean("7", protocolNumber, "2", submissionNumber, false);
            this.getQuestionnaireHelper().setAnswerHeaders(this.getQuestionnaireAnswerService().getQuestionnaireAnswer((ModuleQuestionnaireBean)moduleQuestionnaireBean));
        }
    }

    private QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return (QuestionnaireAnswerService)KraServiceLocator.getService(QuestionnaireAnswerService.class);
    }

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        super.populateHeaderFields(workflowDocument);
        ProtocolDocument pd = this.getProtocolDocument();
        HeaderField documentNumber = (HeaderField)this.getDocInfo().get(0);
        documentNumber.setDdAttributeEntryName("DataDictionary.ProtocolDocument.attributes.documentNumber");
        ProtocolStatus protocolStatus = (ProtocolStatus)(pd == null ? null : pd.getProtocol().getProtocolStatus());
        HeaderField docStatus = new HeaderField("DataDictionary.AttributeReferenceDummy.attributes.workflowDocumentStatus", protocolStatus == null ? "" : protocolStatus.getDescription());
        this.getDocInfo().set(1, docStatus);
        String lastUpdatedDateStr = null;
        if (pd != null && pd.getUpdateTimestamp() != null) {
            lastUpdatedDateStr = CoreApiServiceLocator.getDateTimeService().toString((Date)pd.getUpdateTimestamp(), "hh:mm a MM/dd/yyyy");
        }
        if (this.getDocInfo().size() > 2) {
            String modifiedInitiatorFieldStr;
            KcPerson initiator = this.getKcPersonService().getKcPersonByPersonId(pd.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId());
            String string = modifiedInitiatorFieldStr = initiator == null ? "" : initiator.getUserName();
            if (StringUtils.isNotBlank((String)lastUpdatedDateStr)) {
                modifiedInitiatorFieldStr = modifiedInitiatorFieldStr + " : " + lastUpdatedDateStr;
            }
            this.getDocInfo().set(2, new HeaderField("DataDictionary.Protocol.attributes.initiatorLastUpdated", modifiedInitiatorFieldStr));
        }
        String protocolSubmissionStatusStr = null;
        if (pd != null && pd.getProtocol() != null && pd.getProtocol().getProtocolSubmission() != null) {
            pd.getProtocol().getProtocolSubmission().refreshReferenceObject("submissionStatus");
            protocolSubmissionStatusStr = pd.getProtocol().getProtocolSubmission().getSubmissionStatus().getDescription();
        }
        HeaderField protocolSubmissionStatus = new HeaderField("DataDictionary.Protocol.attributes.protocolSubmissionStatus", protocolSubmissionStatusStr);
        this.getDocInfo().set(3, protocolSubmissionStatus);
        this.getDocInfo().add(new HeaderField("DataDictionary.Protocol.attributes.protocolNumber", pd == null ? null : pd.getProtocol().getProtocolNumber()));
        String expirationDateStr = null;
        if (pd != null && pd.getProtocol().getExpirationDate() != null) {
            expirationDateStr = CoreApiServiceLocator.getDateTimeService().toString((Date)pd.getProtocol().getExpirationDate(), "MM/dd/yyyy");
        }
        HeaderField expirationDate = new HeaderField("DataDictionary.Protocol.attributes.expirationDate", expirationDateStr);
        this.getDocInfo().add(expirationDate);
    }

    public ProtocolHelper getProtocolHelper() {
        return (ProtocolHelper)super.getProtocolHelper();
    }

    public PersonnelHelper getPersonnelHelper() {
        return (PersonnelHelper)super.getPersonnelHelper();
    }

    public PermissionsHelper getPermissionsHelper() {
        return (PermissionsHelper)super.getPermissionsHelper();
    }

    public ProtocolReferenceBean getNewProtocolReferenceBean() {
        return (ProtocolReferenceBean)super.getNewProtocolReferenceBean();
    }

    protected String getLockRegion() {
        return "PROTOCOL";
    }

    public String getActionName() {
        return "protocol";
    }

    public NotesAttachmentsHelper getNotesAttachmentsHelper() {
        return (NotesAttachmentsHelper)super.getNotesAttachmentsHelper();
    }

    public ActionHelper getActionHelper() {
        return (ActionHelper)super.getActionHelper();
    }

    public ProtocolDocument getProtocolDocument() {
        return (ProtocolDocument)super.getProtocolDocument();
    }

    public boolean isPropertyEditable(String propertyName) {
        if (propertyName.startsWith("actionHelper.protocolSubmitAction.reviewer") || propertyName.startsWith("methodToCall.printSubmissionQuestionnaireAnswer.line") || propertyName.startsWith("methodToCall.saveCorrespondence") || propertyName.startsWith("methodToCall.closeCorrespondence")) {
            return true;
        }
        return super.isPropertyEditable(propertyName);
    }

    public boolean getDisplayRiskLevelPanel() {
        return this.getProtocolDocument().getProtocol().getProtocolRiskLevels() != null && this.getProtocolDocument().getProtocol().getProtocolRiskLevels().size() > 0;
    }

    public String getModuleCode() {
        return "7";
    }

    protected NotificationHelper<? extends ProtocolNotificationContextBase> getNotificationHelperHook() {
        return new NotificationHelper();
    }

    protected ProtocolReferenceBeanBase createNewProtocolReferenceBeanInstance() {
        return new ProtocolReferenceBean();
    }

    protected QuestionnaireHelperBase createNewQuestionnaireHelperInstanceHook(ProtocolFormBase protocolForm) {
        return new QuestionnaireHelper((ProtocolFormBase)((ProtocolForm)protocolForm));
    }

    protected ActionHelperBase createNewActionHelperInstanceHook(ProtocolFormBase protocolForm) throws Exception {
        return new ActionHelper((ProtocolForm)protocolForm);
    }

    protected ProtocolSpecialReviewHelperBase createNewSpecialReviewHelperInstanceHook(ProtocolFormBase protocolForm) {
        return new SpecialReviewHelper((ProtocolForm)protocolForm);
    }

    protected ProtocolCustomDataHelperBase createNewCustomDataHelperInstanceHook(ProtocolFormBase protocolForm) {
        return new CustomDataHelper((ProtocolForm)protocolForm);
    }

    protected OnlineReviewsActionHelperBase createNewOnlineReviewsActionHelperInstanceHook(ProtocolFormBase protocolForm) {
        return new OnlineReviewsActionHelper((ProtocolForm)protocolForm);
    }

    protected ProtocolHelperBase createNewProtocolHelperInstanceHook(ProtocolFormBase protocolForm) {
        return new ProtocolHelper((ProtocolForm)protocolForm);
    }

    protected PermissionsHelperBase createNewPermissionsHelperInstanceHook(ProtocolFormBase protocolForm) {
        return new PermissionsHelper((ProtocolForm)protocolForm);
    }

    protected PersonnelHelperBase createNewPersonnelHelperInstanceHook(ProtocolFormBase protocolForm) {
        return new PersonnelHelper((ProtocolForm)protocolForm);
    }

    protected QuestionnaireHelperBase createNewQuestionnaireHelper(ProtocolFormBase protocolForm) {
        return new QuestionnaireHelper(protocolForm);
    }

    protected NotesAttachmentsHelperBase createNewNotesAttachmentsHelperInstanceHook(ProtocolFormBase protocolForm) {
        return new NotesAttachmentsHelper((ProtocolForm)protocolForm);
    }

    protected List<String> getTerminalNodeNamesHook() {
        ArrayList<String> retVal = new ArrayList<String>();
        retVal.add("IRBReview");
        return retVal;
    }
}

