/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDao;
import org.kuali.kra.protocol.ProtocolLookupableHelperServiceImplBase;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.krad.bo.BusinessObject;

public class ProtocolLookupableHelperServiceImpl
extends ProtocolLookupableHelperServiceImplBase<Protocol> {
    private static final long serialVersionUID = -6170836146164439176L;
    private ProtocolDao<Protocol> protocolDao;
    private static final String[] AMEND_RENEW_PROTOCOL_TASK_CODES = new String[]{"createAmendment", "createRenewal"};
    private static final String NOTIFY_IRB_PROTOCOL_LOOKUP_ACTION = "lookupActionNotifyIRBProtocol";
    private static final String[] NOTIFY_IRB_PROTOCOL_TASK_CODES = new String[]{"protocolNotifyIrb"};
    private static final String[] REQUEST_PROTOCOL_TASK_CODES = new String[]{"protocolRequestClose", "protocolRequestCloseEnrollment", "protocolRequestDataAnalysis", "protocolRequestReOpenEnrollment", "protocolRequestSuspension", "protocolRequestTerminate"};
    private static final String[] PENDING_PROTOCOL_STATUS_CODES = new String[]{"100", "101", "102", "104", "105", "106", "304"};
    private static final String[] PENDING_PI_ACTION_PROTOCOL_STATUS_CODES = new String[]{"102", "104", "305"};

    protected ProtocolTaskBase createNewProtocolTaskInstanceHook(String taskName, ProtocolBase protocol) {
        return new ProtocolTask(taskName, (Protocol)protocol);
    }

    protected List<? extends BusinessObject> getSearchResultsFilteredByTask(Map<String, String> fieldValues) {
        List searchResults = null;
        searchResults = BooleanUtils.toBoolean((String)fieldValues.get("lookupActionAmendRenewProtocol")) ? this.filterProtocolsByTask(fieldValues, AMEND_RENEW_PROTOCOL_TASK_CODES) : (BooleanUtils.toBoolean((String)fieldValues.get(NOTIFY_IRB_PROTOCOL_LOOKUP_ACTION)) ? this.filterProtocolsByTask(fieldValues, NOTIFY_IRB_PROTOCOL_TASK_CODES) : (BooleanUtils.toBoolean((String)fieldValues.get("lookupActionRequestProtocol")) ? this.filterProtocolsByTask(fieldValues, REQUEST_PROTOCOL_TASK_CODES) : (BooleanUtils.toBoolean((String)fieldValues.get("lookupPendingProtocol")) ? this.filterProtocolsByStatus(fieldValues, PENDING_PROTOCOL_STATUS_CODES) : (BooleanUtils.toBoolean((String)fieldValues.get("lookupPendingPIActionProtocol")) ? this.filterProtocolsByStatus(fieldValues, PENDING_PI_ACTION_PROTOCOL_STATUS_CODES) : (StringUtils.isNotBlank((String)fieldValues.get("lookupProtocolPersonId")) ? this.filterProtocolsByPrincipal(fieldValues, "lookupProtocolPersonId") : this.filterProtocols(fieldValues))))));
        return searchResults;
    }

    protected Map<String, String> removeExtraFilterParameters(Map<String, String> fieldValues) {
        fieldValues.remove("lookupActionAmendRenewProtocol");
        fieldValues.remove(NOTIFY_IRB_PROTOCOL_LOOKUP_ACTION);
        fieldValues.remove("lookupActionRequestProtocol");
        fieldValues.remove("lookupPendingProtocol");
        fieldValues.remove("lookupPendingPIActionProtocol");
        fieldValues.remove("lookupProtocolPersonId");
        return fieldValues;
    }

    protected List<HtmlData> getCustomActions(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        if (this.isParameterTrue("lookupActionAmendRenewProtocol")) {
            htmlDataList.add((HtmlData)this.getPerformActionLink(businessObject, "lookupActionAmendRenewProtocol"));
        } else if (this.isParameterTrue(NOTIFY_IRB_PROTOCOL_LOOKUP_ACTION)) {
            htmlDataList.add((HtmlData)this.getPerformActionLink(businessObject, NOTIFY_IRB_PROTOCOL_LOOKUP_ACTION));
        } else if (this.isParameterTrue("lookupActionRequestProtocol")) {
            htmlDataList.add((HtmlData)this.getPerformActionLink(businessObject, "lookupActionRequestProtocol"));
        } else {
            htmlDataList.addAll(this.getEditCopyViewLinks(businessObject, pkNames));
        }
        return htmlDataList;
    }

    protected ProtocolDao<Protocol> getProtocolDaoHook() {
        return this.protocolDao;
    }

    public void setProtocolDao(ProtocolDao<Protocol> protocolDao) {
        this.protocolDao = protocolDao;
    }

    protected String getDocumentTypeNameHook() {
        return "ProtocolDocument";
    }

    protected String getHtmlActionHook() {
        return "protocolProtocol.do";
    }

    protected Class<? extends ProtocolBase> getProtocolClassHook() {
        return Protocol.class;
    }
}

