/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.ActionHelper;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.questionnaire.IrbSubmissionQuestionnaireHelper;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.print.QuestionnairePrintOption;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.questionnaire.ProtocolSubmissionQuestionnaireHelper;

public class ProtocolAction
extends ProtocolActionBase {
    private static final long serialVersionUID = -2148599171919464303L;
    private transient QuestionnairePrintOption questionnairePrintOption;

    public ProtocolAction() {
    }

    public ProtocolAction(Protocol protocol, ProtocolSubmission protocolSubmission, String protocolActionTypeCode) {
        super((ProtocolBase)protocol, (ProtocolSubmissionBase)protocolSubmission, protocolActionTypeCode);
    }

    public ProtocolAction(Protocol protocol, String protocolActionTypeCode) {
        super((ProtocolBase)protocol, protocolActionTypeCode);
    }

    public QuestionnairePrintOption getQuestionnairePrintOption() {
        return this.questionnairePrintOption;
    }

    public void setQuestionnairePrintOption(QuestionnairePrintOption questionnairePrintOption) {
        this.questionnairePrintOption = questionnairePrintOption;
    }

    public void setQuestionnairePrintOptionFromHelper(ActionHelper actionHelper) {
        if (this.getSubmissionNumber() != null && !"101".equals(this.getProtocolActionTypeCode())) {
            if (this.getQuestionnaireHelper().getAnswerHeaders().isEmpty()) {
                this.setQuestionnairePrintOption(this.getQnPrintOptionForAction(this.getProtocolNumber(), this.getSubmissionNumber().toString(), "2"));
            }
        } else if ("101".equals(this.getProtocolActionTypeCode()) && "Submitted to IRB".equals(this.getComments())) {
            if (this.getProtocol().isAmendment() || this.getProtocol().isRenewal()) {
                this.setQuestionnairePrintOption(this.getQnPrintOptionForAction(this.getProtocolNumber(), this.getSequenceNumber().toString(), "1"));
            } else {
                this.setQuestionnairePrintOption(this.getQnPrintOptionForAction(this.getProtocolNumber(), this.getInitialSequence(this, ""), "0"));
            }
        } else if ("101".equals(this.getProtocolActionTypeCode()) && StringUtils.isNotBlank((String)this.getComments()) && (this.getComments().startsWith("Amendment-") || this.getComments().startsWith("Renewal-"))) {
            String amendmentRenewalNumber = this.getAmendmentRenewalNumber(this.getComments());
            this.setQuestionnairePrintOption(this.getQnPrintOptionForAction(this.getProtocolNumber() + amendmentRenewalNumber, this.getInitialSequence(this, amendmentRenewalNumber), "1"));
        }
    }

    private QuestionnairePrintOption getQnPrintOptionForAction(String itemKey, String subItemKey, String subItemCode) {
        if (!this.getQuestionnaireHelper().getAnswerHeaders().isEmpty()) {
            QuestionnairePrintOption qnPrintOption = new QuestionnairePrintOption();
            qnPrintOption.setItemKey(itemKey);
            qnPrintOption.setSubItemCode(subItemCode);
            qnPrintOption.setSubItemKey(subItemKey);
            return qnPrintOption;
        }
        return null;
    }

    private String getInitialSequence(ProtocolAction protocolAction, String amendmentRenewalNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("protocolNumber", protocolAction.getProtocolNumber() + amendmentRenewalNumber);
        if (StringUtils.isBlank((String)amendmentRenewalNumber)) {
            fieldValues.put("actionId", protocolAction.getActionId().toString());
        } else {
            fieldValues.put("submissionNumber", protocolAction.getSubmissionNumber().toString());
        }
        fieldValues.put("protocolActionTypeCode", "101");
        return ((ProtocolAction)((List)this.getBusinessObjectService().findMatchingOrderBy(ProtocolAction.class, fieldValues, "protocolActionId", true)).get(0)).getProtocol().getSequenceNumber().toString();
    }

    protected Class<? extends CommitteeServiceBase> getCommitteeServiceClassHook() {
        return CommitteeService.class;
    }

    protected String getCoeusModule() {
        return "7";
    }

    protected ProtocolSubmissionQuestionnaireHelper getProtocolSubmissionQuestionnaireHelperHook(ProtocolBase protocol, String actionTypeCode, String submissionNumber) {
        return new IrbSubmissionQuestionnaireHelper(protocol, actionTypeCode, submissionNumber, true);
    }
}

