/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.common.notification.NotificationRenderer;
import org.kuali.kra.common.notification.bo.KcNotification;
import org.kuali.kra.common.notification.bo.NotificationTypeRecipient;
import org.kuali.kra.common.notification.rule.event.AddNotificationRecipientEvent;
import org.kuali.kra.common.notification.rule.event.SendNotificationEvent;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.ProtocolAction;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.actions.notification.AssignReviewerNotificationRenderer;
import org.kuali.kra.irb.actions.notification.ProtocolNotificationRequestBean;
import org.kuali.kra.irb.notification.IRBNotificationContext;
import org.kuali.kra.irb.notification.IRBProtocolNotification;
import org.kuali.kra.protocol.notification.ProtocolNotification;
import org.kuali.kra.protocol.notification.ProtocolNotificationContextBase;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class ProtocolNotificationEditorAction
extends ProtocolAction {
    private static final String PROTOCOL_ACTIONS_TAB = "protocolActions";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        ProtocolForm protocolForm = (ProtocolForm)form;
        protocolForm.getNotificationHelper().prepareView();
        return actionForward;
    }

    public ActionForward addNotificationRecipient(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List notificationRecipients;
        NotificationTypeRecipient notificationRecipient;
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        if (this.applyRules((KualiDocumentEvent)new AddNotificationRecipientEvent((Document)document, notificationRecipient = protocolForm.getNotificationHelper().getNewNotificationRecipient(), notificationRecipients = protocolForm.getNotificationHelper().getNotificationRecipients()))) {
            protocolForm.getNotificationHelper().getNotificationRecipients().add(notificationRecipient);
            protocolForm.getNotificationHelper().setNewNotificationRecipient(new NotificationTypeRecipient());
            protocolForm.getNotificationHelper().setNewRoleId(null);
            protocolForm.getNotificationHelper().setNewPersonId(null);
            protocolForm.getNotificationHelper().setNewRolodexId(null);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteNotificationRecipient(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        protocolForm.getNotificationHelper().getNotificationRecipients().remove(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward sendNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object notificationRequestBeans;
        List notificationRecipients;
        KcNotification notification;
        ActionForward actionForward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        if (this.applyRules((KualiDocumentEvent)new SendNotificationEvent((Document)document, notification = protocolForm.getNotificationHelper().getNotification(), notificationRecipients = protocolForm.getNotificationHelper().getNotificationRecipients()))) {
            protocolForm.getNotificationHelper().sendNotificationAndPersist((KcNotification)new IRBProtocolNotification(), (KraPersistableBusinessObjectBase)document.getProtocol());
            String forwardName = ((ProtocolNotificationContextBase)protocolForm.getNotificationHelper().getNotificationContext()).getForwardName();
            protocolForm.getNotificationHelper().setNotificationContext(null);
            if (StringUtils.isNotBlank((String)forwardName)) {
                if (StringUtils.startsWith((String)forwardName, (String)"holdingPage")) {
                    if (StringUtils.equals((String)forwardName, (String)"holdingPage")) {
                        return this.routeProtocolToHoldingPage(mapping, protocolForm);
                    }
                    String[] params = StringUtils.split((String)forwardName, (String)":");
                    return this.routeProtocolOLRToHoldingPage(mapping, protocolForm, params[1], params[2]);
                }
                actionForward = mapping.findForward(forwardName);
            } else {
                this.recordProtocolActionSuccess("Send Notification");
                actionForward = mapping.findForward(PROTOCOL_ACTIONS_TAB);
            }
        }
        if ((notificationRequestBeans = GlobalVariables.getUserSession().retrieveObject("removeReviewer")) != null) {
            GlobalVariables.getUserSession().removeObject("removeReviewer");
            actionForward = this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_ACTIONS_TAB), protocolForm, (List)notificationRequestBeans);
        }
        return actionForward;
    }

    private ActionForward checkToSendNotification(ActionMapping mapping, ActionForward forward, ProtocolForm protocolForm, List<ProtocolNotificationRequestBean> notificationRequestBeans) {
        AssignReviewerNotificationRenderer renderer = new AssignReviewerNotificationRenderer(notificationRequestBeans.get(0).getProtocol(), "removed");
        IRBNotificationContext context = new IRBNotificationContext(notificationRequestBeans.get(0).getProtocol(), notificationRequestBeans.get(0).getProtocolOnlineReview(), notificationRequestBeans.get(0).getActionType(), notificationRequestBeans.get(0).getDescription(), (NotificationRenderer)renderer);
        if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor((NotificationContext)context)) {
            context.setForwardName(forward.getName());
            context.setPopulateRole(true);
            protocolForm.getNotificationHelper().initializeDefaultValues((NotificationContext)context);
            List notificationRecipients = protocolForm.getNotificationHelper().getNotificationRecipients();
            ArrayList<NotificationTypeRecipient> allRecipients = new ArrayList<NotificationTypeRecipient>();
            for (NotificationTypeRecipient recipient : notificationRecipients) {
                try {
                    NotificationTypeRecipient copiedRecipient = (NotificationTypeRecipient)ObjectUtils.deepCopy((Serializable)recipient);
                    context.populateRoleQualifiers(copiedRecipient);
                    allRecipients.add(copiedRecipient);
                }
                catch (Exception e) {}
            }
            for (int i = 1; notificationRequestBeans.size() > i; ++i) {
                context = new IRBNotificationContext(notificationRequestBeans.get(i).getProtocol(), notificationRequestBeans.get(i).getProtocolOnlineReview(), notificationRequestBeans.get(i).getActionType(), notificationRequestBeans.get(i).getDescription(), (NotificationRenderer)renderer);
                context.setPopulateRole(true);
                protocolForm.getNotificationHelper().initializeDefaultValues((NotificationContext)context);
                List recipients = protocolForm.getNotificationHelper().getNotificationRecipients();
                for (NotificationTypeRecipient recipient : recipients) {
                    try {
                        NotificationTypeRecipient copiedRecipient = (NotificationTypeRecipient)ObjectUtils.deepCopy((Serializable)recipient);
                        context.populateRoleQualifiers(copiedRecipient);
                        allRecipients.add(copiedRecipient);
                    }
                    catch (Exception e) {}
                }
            }
            protocolForm.getNotificationHelper().setNotificationRecipients(allRecipients);
            return mapping.findForward("protocolNotificationEditor");
        }
        boolean i = false;
        return forward;
    }

    private KcNotificationService getKcNotificationService() {
        return (KcNotificationService)KraServiceLocator.getService(KcNotificationService.class);
    }

    public ActionForward cancelNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        protocolForm.getNotificationHelper().setNotificationContext(null);
        return mapping.findForward(PROTOCOL_ACTIONS_TAB);
    }

    private ActionForward routeProtocolOLRToHoldingPage(ActionMapping mapping, ProtocolForm protocolForm, String olrDocId, String olrEvent) {
        String routeHeaderId = protocolForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "onlineReview", "ProtocolDocument");
        returnLocation = returnLocation + "&olrDocId=" + olrDocId + "&" + "olrEvent=" + olrEvent;
        ActionForward basicForward = mapping.findForward("portal");
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        GlobalVariables.getUserSession().addObject("holdingPageDocumentId", (Object)olrDocId);
        GlobalVariables.getUserSession().addObject("alternateDocIdSessionKey", (Object)"holdingPageDocumentId");
        return this.routeToHoldingPage(basicForward, basicForward, holdingPageForward, returnLocation);
    }

    private ActionForward routeProtocolToHoldingPage(ActionMapping mapping, ProtocolForm protocolForm) {
        String routeHeaderId = protocolForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, PROTOCOL_ACTIONS_TAB, "ProtocolDocument");
        ActionForward basicForward = mapping.findForward("portal");
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        return this.routeToHoldingPage(basicForward, basicForward, holdingPageForward, returnLocation);
    }

    private void recordProtocolActionSuccess(String protocolActionName) {
        KNSGlobalVariables.getMessageList().add("message.protocol.action.successfully.completed", new String[]{protocolActionName});
    }

    protected ProtocolNotification getProtocolNotificationHook() {
        return null;
    }
}

