/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.actions.IrbActionsKeyValuesBase;
import org.kuali.kra.irb.actions.submit.ProtocolReviewer;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiForm;

public class ProtocolReviewerValuesFinder
extends IrbActionsKeyValuesBase {
    private static final long serialVersionUID = 6339476452241934050L;

    public List<KeyValue> getKeyValues() {
        ProtocolSubmission submission;
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add((KeyValue)new ConcreteKeyValue("", "select"));
        Protocol protocol = this.getProtocol();
        if (protocol != null && (submission = this.getCurrentSubmission(protocol)) != null) {
            List reviewers = submission.getProtocolReviewers();
            for (ProtocolReviewer reviewer : reviewers) {
                keyValues.add((KeyValue)new ConcreteKeyValue(reviewer.getProtocolReviewerId().toString(), reviewer.getFullName()));
            }
        }
        return keyValues;
    }

    private ProtocolSubmission getCurrentSubmission(Protocol protocol) {
        List protocolSubmissions = protocol.getProtocolSubmissions();
        for (ProtocolSubmission submission : protocolSubmissions) {
            if (!StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"101") && !StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"100")) continue;
            return submission;
        }
        return null;
    }

    private Protocol getProtocol() {
        KualiForm form = KNSGlobalVariables.getKualiForm();
        if (form != null && form instanceof ProtocolForm) {
            return ((ProtocolForm)form).getProtocolDocument().getProtocol();
        }
        return null;
    }
}

