/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.upload.FormFile;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolFinderDao;
import org.kuali.kra.irb.actions.ProtocolSubmissionDoc;
import org.kuali.kra.irb.actions.submit.ProtocolExemptStudiesCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolExpeditedReviewCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.notify.ProtocolActionAttachment;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProtocolSubmissionBuilder {
    private static final Log LOG = LogFactory.getLog(ProtocolSubmissionBuilder.class);
    private static final String NEXT_SUBMISSION_NUMBER_KEY = "submissionNumber";
    private static final String NEXT_SUBMISSION_DOCUMENT_ID_KEY = "submissionDocId";
    private ProtocolSubmission protocolSubmission;
    private List<FormFile> attachments = new ArrayList();
    private List<ProtocolActionAttachment> actionAttachments = new ArrayList();

    public ProtocolSubmissionBuilder(Protocol protocol, String submissionTypeCode) {
        this.protocolSubmission = new ProtocolSubmission();
        this.protocolSubmission.setProtocol((ProtocolBase)protocol);
        this.protocolSubmission.setProtocolId(protocol.getProtocolId());
        this.protocolSubmission.setProtocolNumber(protocol.getProtocolNumber());
        this.protocolSubmission.setSequenceNumber(protocol.getSequenceNumber());
        this.protocolSubmission.setSubmissionNumber(this.getNextSubmissionNumber(protocol));
        this.protocolSubmission.setSubmissionDate(new Date(System.currentTimeMillis()));
        this.protocolSubmission.setSubmissionTypeCode(submissionTypeCode);
        ProtocolSubmission oldSubmission = protocol.getProtocolSubmission();
        this.setValuesFromOldSubmission(this.protocolSubmission, oldSubmission);
        this.protocolSubmission.setSubmissionStatusCode("100");
    }

    private Integer getNextSubmissionNumber(Protocol protocol) {
        Integer nextSubmissionNumber;
        if (protocol.isAmendment() || protocol.isRenewal()) {
            String origProtocolNumber = protocol.getProtocolNumber();
            String protocolNumber = origProtocolNumber.substring(0, 10);
            Protocol origProtocol = this.getProtocolFinderDao().findCurrentProtocolByNumber(protocolNumber);
            nextSubmissionNumber = origProtocol.getNextValue(NEXT_SUBMISSION_NUMBER_KEY);
            this.getBusinessObjectService().save(origProtocol.getProtocolDocument().getDocumentNextvalues());
        } else {
            nextSubmissionNumber = protocol.getNextValue(NEXT_SUBMISSION_NUMBER_KEY);
        }
        LOG.info((Object)("nextsubmissionnumber " + protocol.getProtocolId() + " " + (CollectionUtils.isEmpty((Collection)protocol.getProtocolSubmissions()) ? 0 : protocol.getProtocolSubmissions().size()) + "-" + nextSubmissionNumber));
        return nextSubmissionNumber;
    }

    private ProtocolFinderDao getProtocolFinderDao() {
        return (ProtocolFinderDao)KraServiceLocator.getService(ProtocolFinderDao.class);
    }

    private void setValuesFromOldSubmission(ProtocolSubmission newSubmission, ProtocolSubmission oldSubmission) {
        if (oldSubmission != null) {
            this.protocolSubmission.setSubmissionTypeQualifierCode(oldSubmission.getSubmissionTypeQualifierCode());
            this.protocolSubmission.setComments(oldSubmission.getComments());
            this.protocolSubmission.setYesVoteCount(oldSubmission.getYesVoteCount());
            this.protocolSubmission.setNoVoteCount(oldSubmission.getNoVoteCount());
            this.protocolSubmission.setAbstainerCount(oldSubmission.getAbstainerCount());
            this.protocolSubmission.setAbstainers(oldSubmission.getAbstainers());
            this.protocolSubmission.setRecusedCount(oldSubmission.getRecusedCount());
            this.protocolSubmission.setRecusers(oldSubmission.getRecusers());
            this.protocolSubmission.setVotingComments(oldSubmission.getVotingComments());
            this.protocolSubmission.setBillable(oldSubmission.isBillable());
        } else {
            this.protocolSubmission.setAbstainerCount(Integer.valueOf(0));
            this.protocolSubmission.setRecusedCount(Integer.valueOf(0));
            this.protocolSubmission.setBillable(false);
        }
    }

    public ProtocolSubmission create() {
        this.protocolSubmission.setSubmissionDate(new Date(System.currentTimeMillis()));
        this.getBusinessObjectService().save((PersistableBusinessObject)this.protocolSubmission);
        this.protocolSubmission.getProtocol().getProtocolSubmissions().add(this.protocolSubmission);
        this.saveAttachments();
        return this.protocolSubmission;
    }

    public void setSubmissionTypeQualifierCode(String submissionTypeQualifierCode) {
        this.protocolSubmission.setSubmissionTypeQualifierCode(submissionTypeQualifierCode);
    }

    public void setProtocolReviewTypeCode(String protocolReviewTypeCode) {
        this.protocolSubmission.setProtocolReviewTypeCode(protocolReviewTypeCode);
    }

    public void setSubmissionStatus(String submissionStatusCode) {
        this.protocolSubmission.setSubmissionStatusCode(submissionStatusCode);
    }

    public void setComments(String comments) {
        this.protocolSubmission.setComments(comments);
    }

    public void setCommittee(String committeeId) {
        Committee committee = (Committee)this.getCommitteeService().getCommitteeById(committeeId);
        if (committee != null) {
            this.protocolSubmission.setCommitteeId(committee.getCommitteeId());
            this.protocolSubmission.setCommitteeIdFk(committee.getId());
            this.protocolSubmission.setCommittee((CommitteeBase)committee);
        }
    }

    public void setSchedule(String scheduleId) {
        if (this.protocolSubmission.getCommittee() != null) {
            CommitteeSchedule schedule = (CommitteeSchedule)this.getCommitteeService().getCommitteeSchedule((CommitteeBase)this.protocolSubmission.getCommittee(), scheduleId);
            if (schedule != null) {
                this.protocolSubmission.setScheduleId(schedule.getScheduleId());
                this.protocolSubmission.setScheduleIdFk(schedule.getId());
                this.protocolSubmission.setCommitteeSchedule((CommitteeScheduleBase)schedule);
            } else {
                this.clearCommScheduleDataFromPreviousSubmission();
            }
        } else {
            this.clearCommScheduleDataFromPreviousSubmission();
        }
    }

    private void clearCommScheduleDataFromPreviousSubmission() {
        this.protocolSubmission.setScheduleId(null);
        this.protocolSubmission.setScheduleIdFk(null);
        this.protocolSubmission.setCommitteeSchedule(null);
    }

    public void addExemptStudiesCheckListItem(String exemptStudiesCheckListCode) {
        this.protocolSubmission.getExemptStudiesCheckList().add(this.createProtocolExemptStudiesCheckListItem(exemptStudiesCheckListCode));
    }

    private ProtocolExemptStudiesCheckListItem createProtocolExemptStudiesCheckListItem(String exemptStudiesCheckListCode) {
        ProtocolExemptStudiesCheckListItem chkLstItem = new ProtocolExemptStudiesCheckListItem();
        chkLstItem.setProtocolId(this.protocolSubmission.getProtocolId());
        chkLstItem.setSubmissionIdFk(this.protocolSubmission.getSubmissionId());
        chkLstItem.setProtocolNumber(this.protocolSubmission.getProtocolNumber());
        chkLstItem.setSequenceNumber(this.protocolSubmission.getSequenceNumber());
        chkLstItem.setSubmissionNumber(this.protocolSubmission.getSubmissionNumber());
        chkLstItem.setExemptStudiesCheckListCode(exemptStudiesCheckListCode);
        return chkLstItem;
    }

    public void addExpeditedReviewCheckListItem(String expeditedReviewCheckListCode) {
        this.protocolSubmission.getExpeditedReviewCheckList().add(this.createProtocolExpeditedReviewCheckListItem(expeditedReviewCheckListCode));
    }

    private ProtocolExpeditedReviewCheckListItem createProtocolExpeditedReviewCheckListItem(String expeditedReviewCheckListCode) {
        ProtocolExpeditedReviewCheckListItem chkLstItem = new ProtocolExpeditedReviewCheckListItem();
        chkLstItem.setProtocolId(this.protocolSubmission.getProtocolId());
        chkLstItem.setSubmissionIdFk(this.protocolSubmission.getSubmissionId());
        chkLstItem.setProtocolNumber(this.protocolSubmission.getProtocolNumber());
        chkLstItem.setSequenceNumber(this.protocolSubmission.getSequenceNumber());
        chkLstItem.setSubmissionNumber(this.protocolSubmission.getSubmissionNumber());
        chkLstItem.setExpeditedReviewCheckListCode(expeditedReviewCheckListCode);
        return chkLstItem;
    }

    private void saveAttachments() {
        for (ProtocolActionAttachment attachment : this.actionAttachments) {
            this.saveAttachment(attachment.getFile(), attachment.getDescription());
        }
    }

    private void saveAttachment(FormFile file, String description) {
        try {
            byte[] data = file.getFileData();
            if (data.length > 0) {
                ProtocolSubmissionDoc submissionDoc = this.createProtocolSubmissionDoc(this.protocolSubmission, file.getFileName(), file.getContentType(), data, description);
                this.getBusinessObjectService().save((PersistableBusinessObject)submissionDoc);
            }
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private ProtocolSubmissionDoc createProtocolSubmissionDoc(ProtocolSubmission submission, String fileName, String contentType, byte[] document, String description) {
        ProtocolSubmissionDoc submissionDoc = new ProtocolSubmissionDoc();
        submissionDoc.setProtocolNumber(submission.getProtocolNumber());
        submissionDoc.setSequenceNumber(submission.getSequenceNumber());
        submissionDoc.setSubmissionNumber(submission.getSubmissionNumber());
        submissionDoc.setProtocolId(submission.getProtocolId());
        submissionDoc.setSubmissionIdFk(submission.getSubmissionId());
        submissionDoc.setProtocol(submission.getProtocol());
        submissionDoc.setProtocolSubmission((ProtocolSubmissionBase)submission);
        submissionDoc.setDocumentId(submission.getProtocol().getNextValue(NEXT_SUBMISSION_DOCUMENT_ID_KEY));
        submissionDoc.setFileName(fileName);
        submissionDoc.setDocument(document);
        submissionDoc.setDescription(description);
        submissionDoc.setContentType(contentType);
        return submissionDoc;
    }

    private CommitteeService getCommitteeService() {
        return (CommitteeService)KraServiceLocator.getService(CommitteeService.class);
    }

    private BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    public List<ProtocolActionAttachment> getActionAttachments() {
        return this.actionAttachments;
    }

    public void setActionAttachments(List<ProtocolActionAttachment> actionAttachments) {
        this.actionAttachments = actionAttachments;
    }
}

