/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.approve;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.approve.ProtocolApproveBean;
import org.kuali.kra.irb.actions.approve.ProtocolApproveService;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericCorrespondence;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.approve.ProtocolApproveServiceImplBase;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionsCorrespondenceBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class ProtocolApproveServiceImpl
extends ProtocolApproveServiceImplBase
implements ProtocolApproveService {
    private static final String FULL_APPROVAL_FINALIZE_OLR_ANNOTATION = "Online Review finalized as part of full approval action on protocol.";
    private static final String EXPEDITED_APPROVAL_FINALIZE_OLR_ANNOTATION = "Online Review finalized as part of expedited approval action on protocol.";
    private ParameterService parameterService;

    public void grantFullApproval(ProtocolBase protocol, org.kuali.kra.protocol.actions.approve.ProtocolApproveBean actionBean) throws Exception {
        String exemptProtocolTypeCode;
        this.generateProtocolActionAndAttach(protocol, actionBean, "204");
        if (protocol.getApprovalDate() == null) {
            protocol.setApprovalDate(actionBean.getApprovalDate());
        }
        if (protocol.isRenewal() || protocol.isAmendment()) {
            protocol.setLastApprovalDate(actionBean.getApprovalDate());
        }
        if (!StringUtils.equals((String)(exemptProtocolTypeCode = this.parameterService.getParameterValueAsString(ProtocolDocument.class, "irb.protocol.protocoltype.exempt")), (String)protocol.getProtocolTypeCode())) {
            protocol.setExpirationDate(actionBean.getExpirationDate());
        }
        this.finalizeReviewsAndSave(protocol, "204", FULL_APPROVAL_FINALIZE_OLR_ANNOTATION);
    }

    public void grantExpeditedApproval(Protocol protocol, ProtocolApproveBean actionBean) throws Exception {
        this.generateProtocolActionAndAttach((ProtocolBase)protocol, (org.kuali.kra.protocol.actions.approve.ProtocolApproveBean)actionBean, "205");
        protocol.setApprovalDate(actionBean.getApprovalDate());
        protocol.setExpirationDate(actionBean.getExpirationDate());
        if (protocol.isRenewal() || protocol.isAmendment()) {
            protocol.setLastApprovalDate(actionBean.getApprovalDate());
        }
        this.finalizeReviewsAndSave((ProtocolBase)protocol, "205", EXPEDITED_APPROVAL_FINALIZE_OLR_ANNOTATION);
        protocol.getProtocolDocument().getDocumentHeader().getWorkflowDocument().approve(actionBean.getComments());
    }

    public void grantResponseApproval(Protocol protocol, ProtocolApproveBean actionBean) throws Exception {
        this.generateProtocolActionAndAttach((ProtocolBase)protocol, (org.kuali.kra.protocol.actions.approve.ProtocolApproveBean)actionBean, "208");
        if (protocol.getApprovalDate() == null) {
            protocol.setApprovalDate(actionBean.getApprovalDate());
        }
        if (protocol.isRenewal() || protocol.isAmendment()) {
            protocol.setLastApprovalDate(actionBean.getApprovalDate());
        }
        protocol.setExpirationDate(actionBean.getExpirationDate());
        this.finalizeReviewsAndSave((ProtocolBase)protocol, "204", "Online Review finalized as part of response approval action on protocol.");
        protocol.getProtocolDocument().getDocumentHeader().getWorkflowDocument().approve(actionBean.getComments());
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected String getProtocolActionTypeCodeForResponseApprovalHook() {
        return "208";
    }

    protected String getProtocolActionTypeCodeForAdminApprovalHook() {
        return null;
    }

    protected ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase protocol, Object object, String protocolActionTypeCode) {
        return new ProtocolAction((Protocol)protocol, null, protocolActionTypeCode);
    }

    protected ProtocolActionsCorrespondenceBase getNewProtocolActionsCorrespondence(String protocolActionTypeCode) {
        return new ProtocolGenericCorrespondence(protocolActionTypeCode);
    }
}

