/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.assignreviewers;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.actions.ActionHelper;
import org.kuali.kra.irb.actions.ProtocolActionBean;
import org.kuali.kra.irb.actions.assignreviewers.ProtocolAssignReviewersService;
import org.kuali.kra.irb.actions.submit.ProtocolReviewerBean;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewerBeanBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;

public class ProtocolAssignReviewersBean
extends ProtocolActionBean
implements org.kuali.kra.protocol.actions.assignreviewers.ProtocolAssignReviewersBean {
    private static final long serialVersionUID = -3769655019628462999L;
    private String currentCommitteeId = null;
    private String currentScheduleId = null;
    private List<ProtocolReviewerBean> reviewers = new ArrayList();

    public ProtocolAssignReviewersBean(ActionHelper actionHelper) {
        super(actionHelper);
    }

    public void prepareView() {
        ProtocolSubmission submission = this.getProtocol().getProtocolSubmission();
        if (submission != null) {
            String committeeId = submission.getCommitteeId();
            String scheduleId = submission.getScheduleId();
            if (!StringUtils.equals((String)committeeId, (String)this.currentCommitteeId) || !StringUtils.equals((String)scheduleId, (String)this.currentScheduleId)) {
                this.currentCommitteeId = committeeId;
                this.currentScheduleId = scheduleId;
                this.reviewers.clear();
                if (!(StringUtils.isBlank((String)committeeId) || StringUtils.isBlank((String)scheduleId) && !this.isExpeditedSubmission(submission))) {
                    List members = this.getProtocol().filterOutProtocolPersonnel(this.getCommitteeService().getAvailableMembers(committeeId, scheduleId));
                    for (CommitteeMembershipBase member : members) {
                        this.reviewers.add(new ProtocolReviewerBean((CommitteeMembership)member));
                    }
                    block1: for (ProtocolOnlineReviewBase review : submission.getProtocolOnlineReviews()) {
                        if (!review.isActive()) continue;
                        for (ProtocolReviewerBean reviewerBean : this.reviewers) {
                            if (!reviewerBean.isProtocolReviewerBeanForReviewer(review.getProtocolReviewer())) continue;
                            reviewerBean.setReviewerTypeCode(review.getProtocolReviewer().getReviewerTypeCode());
                            continue block1;
                        }
                    }
                }
            }
        }
    }

    private ProtocolAssignReviewersService getProtocolAssignReviewersService() {
        return (ProtocolAssignReviewersService)KraServiceLocator.getService(ProtocolAssignReviewersService.class);
    }

    private CommitteeService getCommitteeService() {
        return (CommitteeService)KraServiceLocator.getService(CommitteeService.class);
    }

    public List<ProtocolReviewerBeanBase> getReviewers() {
        return this.reviewers;
    }

    public ProtocolReviewerBean getReviewer(int i) {
        return (ProtocolReviewerBean)this.reviewers.get(i);
    }

    public List<ProtocolReviewerBeanBase> getLeftReviewers() {
        ArrayList<ProtocolReviewerBeanBase> leftReviewers = new ArrayList<ProtocolReviewerBeanBase>();
        for (int i = 0; i < (this.reviewers.size() + 1) / 2; ++i) {
            leftReviewers.add((ProtocolReviewerBeanBase)this.reviewers.get(i));
        }
        return leftReviewers;
    }

    public List<ProtocolReviewerBeanBase> getRightReviewers() {
        ArrayList<ProtocolReviewerBeanBase> rightReviewers = new ArrayList<ProtocolReviewerBeanBase>();
        for (int i = (this.reviewers.size() + 1) / 2; i < this.reviewers.size(); ++i) {
            rightReviewers.add((ProtocolReviewerBeanBase)this.reviewers.get(i));
        }
        return rightReviewers;
    }

    private boolean isExpeditedSubmission(ProtocolSubmission submission) {
        return submission != null && "2".equals(submission.getProtocolReviewTypeCode());
    }
}

