/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.assignreviewers;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolOnlineReviewDocument;
import org.kuali.kra.irb.actions.assignreviewers.ExecuteProtocolAssignReviewersRule;
import org.kuali.kra.irb.actions.assignreviewers.ProtocolAssignReviewersBean;
import org.kuali.kra.irb.actions.submit.ProtocolReviewerBean;
import org.kuali.kra.irb.actions.submit.ProtocolReviewerType;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReviewService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProtocolAssignReviewersRule
extends ResearchDocumentRuleBase
implements ExecuteProtocolAssignReviewersRule {
    private ProtocolOnlineReviewService protocolOnlineReviewService;

    public boolean processAssignReviewers(ProtocolDocument document, ProtocolAssignReviewersBean actionBean) {
        boolean isValid = true;
        List reviewers = actionBean.getReviewers();
        List protocolOnlineReviewDocuments = this.getProtocolOnlineReviewService().getProtocolReviewDocumentsForCurrentSubmission((ProtocolBase)document.getProtocol());
        block0: for (int i = 0; i < reviewers.size(); ++i) {
            ProtocolReviewerBean reviewer = (ProtocolReviewerBean)reviewers.get(i);
            if (!this.isReviewerValid(reviewer, i)) {
                isValid = false;
                continue;
            }
            if (!StringUtils.isBlank((String)reviewer.getReviewerTypeCode())) continue;
            for (ProtocolOnlineReviewDocument pDocument : protocolOnlineReviewDocuments) {
                if (!reviewer.isProtocolReviewerBeanForReviewer(pDocument.getProtocolOnlineReview().getProtocolReviewer())) continue;
                isValid &= this.isValidRemovalRequest(pDocument, reviewer, i);
                continue block0;
            }
        }
        return isValid;
    }

    private boolean isReviewerValid(ProtocolReviewerBean reviewer, int reviewerIndex) {
        boolean isValid = true;
        String reviewerTypeCode = reviewer.getReviewerTypeCode();
        String propertyName = "actionHelper.protocolAssignReviewersBean.reviewer[" + reviewerIndex + "].reviewerTypeCode";
        if (!StringUtils.isBlank((String)reviewerTypeCode) && this.isReviewerTypeInvalid(reviewerTypeCode)) {
            isValid = false;
            this.reportError(propertyName, "error.protocol.reviewerTypeCode.invalid", new String[]{reviewer.getFullName()});
        }
        return isValid;
    }

    public boolean isValidRemovalRequest(ProtocolOnlineReviewDocument document, ProtocolReviewerBean reviewer, int reviewerIndex) {
        boolean isValid = true;
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        String propertyName = "actionHelper.protocolAssignReviewersBean.reviewer[" + reviewerIndex + "].reviewerTypeCode";
        String documentRouteStatus = workflowDocument.getStatus().getCode();
        if (StringUtils.equals((String)"F", (String)documentRouteStatus)) {
            this.reportWarning(propertyName, "warning.protocol.reviewer.removeReview.cannotRemoveFinalReview", new String[]{reviewer.getFullName()});
        }
        if (document.getProtocolOnlineReview().getCommitteeScheduleMinutes().size() > 0) {
            this.reportWarning(propertyName, "warning.protocol.reviewer.removeReview.cannotRemoveReviewWithComments", new String[]{reviewer.getFullName(), "" + document.getProtocolOnlineReview().getCommitteeScheduleMinutes().size()});
        }
        if (StringUtils.equals((String)document.getProtocolOnlineReview().getProtocolOnlineReviewStatusCode(), (String)"F")) {
            this.reportWarning(propertyName, "warning.protocol.reviewer.removeReview.cannotRemoveFinalReview", new String[]{reviewer.getFullName()});
        }
        return isValid;
    }

    private boolean isReviewerTypeInvalid(String reviewerTypeCode) {
        return !this.existsUnique(ProtocolReviewerType.class, "reviewerTypeCode", reviewerTypeCode);
    }

    private boolean existsUnique(Class<? extends BusinessObject> boType, String propertyName, String keyField) {
        if (keyField != null) {
            BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(propertyName, keyField);
            if (businessObjectService.countMatching(boType, fieldValues) == 1) {
                return true;
            }
        }
        return false;
    }

    private ProtocolOnlineReviewService getProtocolOnlineReviewService() {
        if (this.protocolOnlineReviewService == null) {
            this.protocolOnlineReviewService = (ProtocolOnlineReviewService)KraServiceLocator.getService(ProtocolOnlineReviewService.class);
        }
        return this.protocolOnlineReviewService;
    }
}

