/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.correspondence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kra.irb.actions.correspondence.ProtocolActionTypeToCorrespondenceTemplateService;
import org.kuali.kra.irb.correspondence.ProtocolCorrespondenceType;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTemplateBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProtocolActionTypeToCorrespondenceTemplateServiceImpl
implements ProtocolActionTypeToCorrespondenceTemplateService {
    private static Map<String, List<String>> actionTypesToCorrespondenceType = new HashMap();
    private BusinessObjectService businessObjectService;

    public List<ProtocolCorrespondenceTemplateBase> getTemplatesByProtocolAction(String protocolActionType) {
        if (actionTypesToCorrespondenceType.containsKey(protocolActionType)) {
            ArrayList<ProtocolCorrespondenceTemplateBase> templates = new ArrayList<ProtocolCorrespondenceTemplateBase>();
            Collection protocolCorrespondenceTypes = this.getBusinessObjectService().findAll(ProtocolCorrespondenceType.class);
            List correspondenceTypeDescriptions = (List)actionTypesToCorrespondenceType.get(protocolActionType);
            for (ProtocolCorrespondenceType correspondenceType : protocolCorrespondenceTypes) {
                if (!correspondenceTypeDescriptions.contains(correspondenceType.getDescription())) continue;
                templates.addAll(correspondenceType.getProtocolCorrespondenceTemplates());
            }
            return templates;
        }
        throw new IllegalArgumentException("An illegal protocol action type was provided");
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    static {
        actionTypesToCorrespondenceType.put("101", Arrays.asList("Protocol Submission Report #1", "Protocol Submission Report #2"));
        actionTypesToCorrespondenceType.put("303", Arrays.asList("Withdrawal Notice"));
        actionTypesToCorrespondenceType.put("105", Arrays.asList(""));
        actionTypesToCorrespondenceType.put("114", Arrays.asList(""));
        actionTypesToCorrespondenceType.put("104", Arrays.asList(""));
        actionTypesToCorrespondenceType.put("115", Arrays.asList(""));
        actionTypesToCorrespondenceType.put("116", Arrays.asList(""));
        actionTypesToCorrespondenceType.put("103", Arrays.asList(""));
        actionTypesToCorrespondenceType.put("125", Arrays.asList(""));
        actionTypesToCorrespondenceType.put("102", Arrays.asList(""));
        actionTypesToCorrespondenceType.put("200", Arrays.asList(""));
        actionTypesToCorrespondenceType.put("204", Arrays.asList("Approval Letter"));
        actionTypesToCorrespondenceType.put("304", Arrays.asList("Rejection Letter"));
        actionTypesToCorrespondenceType.put("100", Arrays.asList(""));
        actionTypesToCorrespondenceType.put("207", Arrays.asList(""));
        actionTypesToCorrespondenceType.put("208", Arrays.asList(""));
        actionTypesToCorrespondenceType.put("209", Arrays.asList(""));
        actionTypesToCorrespondenceType.put("210", Arrays.asList(""));
        actionTypesToCorrespondenceType.put("211", Arrays.asList(""));
        actionTypesToCorrespondenceType.put("212", Arrays.asList(""));
        actionTypesToCorrespondenceType.put("300", Arrays.asList("Closure Notice"));
        actionTypesToCorrespondenceType.put("301", Arrays.asList("Termination Notice"));
        actionTypesToCorrespondenceType.put("302", Arrays.asList("Suspension notice"));
        actionTypesToCorrespondenceType.put("305", Arrays.asList(""));
        actionTypesToCorrespondenceType.put("306", Arrays.asList("Suspension notice"));
        actionTypesToCorrespondenceType.put("205", Arrays.asList("Expedited Approval Letter"));
        actionTypesToCorrespondenceType.put("206", Arrays.asList("Grant Exemption Notice"));
        actionTypesToCorrespondenceType.put("113", Arrays.asList(""));
        actionTypesToCorrespondenceType.put("203", Arrays.asList("Specific Minor Revisions Letter"));
        actionTypesToCorrespondenceType.put("202", Arrays.asList("Substantive Revisions Required Letter"));
        actionTypesToCorrespondenceType.put("201", Arrays.asList("Notice Of Deferral"));
        actionTypesToCorrespondenceType.put("119", Arrays.asList("Abandon Notice"));
        actionTypesToCorrespondenceType.put("213", Arrays.asList("Returned to PI Notice"));
    }
}

