/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.decision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.common.committee.bo.CommitteeDecisionMotionType;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.actions.ActionHelper;
import org.kuali.kra.irb.actions.ProtocolActionBean;
import org.kuali.kra.irb.actions.decision.CommitteePerson;
import org.kuali.kra.irb.actions.reviewcomments.ReviewAttachmentsBean;
import org.kuali.kra.irb.actions.reviewcomments.ReviewCommentsBean;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.meeting.ProtocolVoteAbstainee;
import org.kuali.kra.meeting.ProtocolVoteRecused;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsBeanBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public class CommitteeDecision
extends ProtocolActionBean
implements org.kuali.kra.protocol.actions.decision.CommitteeDecision<CommitteePerson> {
    private static final long serialVersionUID = -8052093280852074307L;
    private String motionTypeCode;
    private Integer noCount;
    private Integer yesCount;
    private Integer abstainCount;
    private Integer recusedCount;
    private String votingComments;
    private CommitteeDecisionMotionType motionType;
    private CommitteePerson newAbstainer = new CommitteePerson();
    private CommitteePerson newRecused = new CommitteePerson();
    private List<CommitteePerson> abstainers = new ArrayList();
    private List<CommitteePerson> recused = new ArrayList();
    private List<CommitteePerson> abstainersToDelete = new ArrayList();
    private List<CommitteePerson> recusedToDelete = new ArrayList();
    private ReviewCommentsBean reviewCommentsBean = new ReviewCommentsBean("actionHelper.committeeDecision");

    public CommitteeDecision(ActionHelper actionHelper) {
        super(actionHelper);
    }

    public void init() {
        ProtocolSubmission submission = this.getProtocol().getProtocolSubmission();
        if (submission != null) {
            this.motionTypeCode = submission.getCommitteeDecisionMotionTypeCode();
            this.noCount = submission.getNoVoteCount();
            this.yesCount = submission.getYesVoteCount();
            this.abstainCount = submission.getAbstainerCount();
            this.recusedCount = submission.getRecusedCount();
            this.votingComments = submission.getVotingComments();
            this.setMotionType(submission.getCommitteeDecisionMotionType());
            if (submission.getScheduleIdFk() != null) {
                this.initializeAbstainees(submission);
                this.initializeRecused(submission);
            }
        }
    }

    public Integer getRecusedCount() {
        return this.getRecused().size();
    }

    public void setRecusedCount(Integer recusedCount) {
        this.recusedCount = recusedCount;
    }

    private Map<String, Long> getLookUpFields(Long protocolId, Long submissionIdFk) {
        HashMap<String, Long> lookUpFields = new HashMap<String, Long>();
        lookUpFields.put("PROTOCOL_ID_FK", protocolId);
        lookUpFields.put("SUBMISSION_ID_FK", submissionIdFk);
        return lookUpFields;
    }

    private List<CommitteeMembershipBase> getCommitteeMemberships() {
        String committeeId = this.getProtocol().getProtocolSubmission().getCommittee().getCommitteeId();
        String scheduleId = this.getProtocol().getProtocolSubmission().getScheduleId();
        List committeeMemberships = ((CommitteeService)KraServiceLocator.getService(CommitteeService.class)).getAvailableMembers(committeeId, scheduleId);
        return committeeMemberships;
    }

    private void initializeAbstainees(ProtocolSubmission submission) {
        Map absenteeLookFields = this.getLookUpFields(this.getProtocol().getProtocolId(), submission.getSubmissionId());
        Collection protocolVoteAbstainees = ((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findMatching(ProtocolVoteAbstainee.class, absenteeLookFields);
        List committeeMemberships = this.getCommitteeMemberships();
        block0: for (ProtocolVoteAbstainee abstainee : protocolVoteAbstainees) {
            for (CommitteeMembershipBase membership : committeeMemberships) {
                if (!abstainee.isProtocolReviewerFromCommitteeMembership(membership)) continue;
                CommitteePerson person = new CommitteePerson();
                person.setMembershipId(membership.getCommitteeMembershipId());
                this.abstainers.add(person);
                continue block0;
            }
        }
    }

    private void initializeRecused(ProtocolSubmission submission) {
        Map absenteeLookFields = this.getLookUpFields(this.getProtocol().getProtocolId(), submission.getSubmissionId());
        Collection protocolVoteRecused = ((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findMatching(ProtocolVoteRecused.class, absenteeLookFields);
        List committeeMemberships = this.getCommitteeMemberships();
        block0: for (ProtocolVoteRecused recusee : protocolVoteRecused) {
            for (CommitteeMembershipBase membership : committeeMemberships) {
                if (!recusee.isProtocolReviewerFromCommitteeMembership(membership)) continue;
                CommitteePerson person = new CommitteePerson();
                person.setMembershipId(membership.getCommitteeMembershipId());
                this.recused.add(person);
                continue block0;
            }
        }
    }

    public String getMotionTypeCode() {
        return this.motionTypeCode;
    }

    public void setMotionTypeCode(String commDecisionMotionTypeCode) {
        this.motionTypeCode = commDecisionMotionTypeCode;
    }

    public Integer getNoCount() {
        return this.noCount;
    }

    public void setNoCount(Integer noCount) {
        this.noCount = noCount;
    }

    public Integer getYesCount() {
        return this.yesCount;
    }

    public void setYesCount(Integer yesCount) {
        this.yesCount = yesCount;
    }

    public Integer getAbstainCount() {
        return this.getAbstainers().size();
    }

    public void setAbstainCount(Integer abstainCount) {
        this.abstainCount = abstainCount;
    }

    public String getVotingComments() {
        return this.votingComments;
    }

    public void setVotingComments(String votingComments) {
        this.votingComments = votingComments;
    }

    public CommitteeDecisionMotionType getMotionType() {
        return this.motionType;
    }

    public void setMotionType(CommitteeDecisionMotionType motionType) {
        this.motionType = motionType;
    }

    public List<CommitteePerson> getAbstainers() {
        return this.abstainers;
    }

    public void setAbstainers(List<CommitteePerson> abstainers) {
        this.abstainers = abstainers;
    }

    public List<CommitteePerson> getAbstainersToDelete() {
        return this.abstainersToDelete;
    }

    public List<CommitteePerson> getRecused() {
        return this.recused;
    }

    public void setRecused(List<CommitteePerson> recused) {
        this.recused = recused;
    }

    public List<CommitteePerson> getRecusedToDelete() {
        return this.recusedToDelete;
    }

    public CommitteePerson getNewAbstainer() {
        return this.newAbstainer;
    }

    public void setNewAbstainer(CommitteePerson newAbstainer) {
        this.newAbstainer = newAbstainer;
    }

    public CommitteePerson getNewRecused() {
        return this.newRecused;
    }

    public void setNewRecused(CommitteePerson newRecused) {
        this.newRecused = newRecused;
    }

    public int getTotalVoteCount() {
        return (this.getYesCount() != null ? this.getYesCount() : 0) + (this.getNoCount() != null ? this.getNoCount() : 0) + (this.getAbstainCount() != null ? this.getAbstainCount() : 0) + (this.getRecusedCount() != null ? this.getRecusedCount() : 0);
    }

    public ReviewCommentsBean getReviewCommentsBean() {
        return this.reviewCommentsBean;
    }

    public void setReviewCommentsBean(ReviewCommentsBeanBase reviewCommentsBean) {
        this.reviewCommentsBean = (ReviewCommentsBean)reviewCommentsBean;
    }

    public ReviewAttachmentsBean getReviewAttachmentsBean() {
        return null;
    }

    public int getYesCountValue() {
        return this.getYesCount() != null ? this.getYesCount() : 0;
    }

    public int getNoCountValue() {
        return this.getNoCount() != null ? this.getNoCount() : 0;
    }
}

