/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.genericactions;

import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionBean;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionService;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericCorrespondence;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionsCorrespondenceBase;
import org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionServiceImplBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;

public class ProtocolGenericActionServiceImpl
extends ProtocolGenericActionServiceImplBase
implements ProtocolGenericActionService {
    public void close(Protocol protocol, ProtocolGenericActionBean actionBean) throws Exception {
        if ("105".equals(protocol.getLastProtocolAction().getProtocolActionType().getProtocolActionTypeCode())) {
            this.performGenericAction((ProtocolBase)protocol, (org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean)actionBean, "300", "301");
        } else {
            this.performGenericAction((ProtocolBase)protocol, (org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean)actionBean, "300", "300");
        }
    }

    public void closeEnrollment(Protocol protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction((ProtocolBase)protocol, (org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean)actionBean, "207", "201");
    }

    public ProtocolDocument defer(Protocol protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction((ProtocolBase)protocol, (org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean)actionBean, "201", "103");
        return this.getDeferredVersionedDocument(protocol);
    }

    public void disapprove(ProtocolBase protocol, org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "304", "306");
        this.performDisapprove(protocol);
    }

    public void expire(ProtocolBase protocol, org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "305", "305");
    }

    public void irbAcknowledgement(Protocol protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "209");
    }

    public void permitDataAnalysis(Protocol protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction((ProtocolBase)protocol, (org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean)actionBean, "211", "202");
    }

    public void reopenEnrollment(Protocol protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction((ProtocolBase)protocol, (org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean)actionBean, "212", "200");
    }

    public ProtocolDocument returnForSMR(ProtocolBase protocol, org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "203", "102");
        return this.getReturnedVersionedDocument(protocol);
    }

    public ProtocolDocument returnForSRR(ProtocolBase protocol, org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "202", "104");
        return this.getReturnedVersionedDocument(protocol);
    }

    public ProtocolDocument returnToPI(ProtocolBase protocol, org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "213", "107");
        return this.getReturnedVersionedDocument(protocol);
    }

    public void suspend(ProtocolBase protocol, org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean actionBean) throws Exception {
        if ("106".equals(protocol.getLastProtocolAction().getProtocolActionType().getProtocolActionTypeCode())) {
            this.performGenericAction(protocol, actionBean, "302", "302");
        } else {
            this.performGenericAction(protocol, actionBean, "302", "308");
        }
    }

    public void suspendByDsmb(Protocol protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction((ProtocolBase)protocol, (org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean)actionBean, "306", "311");
    }

    public void terminate(ProtocolBase protocol, org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "301", "307");
    }

    private void performGenericAction(Protocol protocol, ProtocolGenericActionBean actionBean, String protocolActionType) throws Exception {
        ProtocolAction protocolAction = (ProtocolAction)this.createProtocolActionAndAttach((ProtocolBase)protocol, (org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean)actionBean, protocolActionType);
        if (protocol.getNotifyIrbSubmissionId() == null) {
            this.getProtocolActionService().updateProtocolStatus((ProtocolActionBase)protocolAction, (ProtocolBase)protocol);
        } else {
            for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
                if (!submission.getSubmissionId().equals(protocol.getNotifyIrbSubmissionId())) continue;
                submission.setSubmissionStatusCode("212");
            }
        }
        protocol.refreshReferenceObject("protocolStatus");
        protocol.refreshReferenceObject("protocolSubmission");
        this.getDocumentService().saveDocument((Document)protocol.getProtocolDocument());
    }

    protected ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase protocol, ProtocolSubmissionBase submission, String protocolActionType) {
        return new ProtocolAction((Protocol)protocol, (ProtocolSubmission)submission, protocolActionType);
    }

    protected ProtocolActionsCorrespondenceBase getNewProtocolActionsCorrespondenceHook(String protocolActionType) {
        return new ProtocolGenericCorrespondence(protocolActionType);
    }

    protected void performDisapprove(ProtocolBase protocol) throws Exception {
        WorkflowDocument currentWorkflowDocument;
        if (protocol.getProtocolDocument() != null && (currentWorkflowDocument = protocol.getProtocolDocument().getDocumentHeader().getWorkflowDocument()) != null) {
            currentWorkflowDocument.disapprove("Protocol document disapproved after committee decision");
        }
        this.getProtocolOnlineReviewService().cancelOnlineReviews(protocol.getProtocolSubmission(), "Protocol Review cancelled - protocol has been disapproved.");
    }

    private ProtocolDocument getDeferredVersionedDocument(Protocol protocol) throws Exception {
        this.getDocumentService().cancelDocument((Document)protocol.getProtocolDocument(), "Protocol document cancelled - protocol has been deferred.");
        this.getProtocolOnlineReviewService().cancelOnlineReviews((ProtocolSubmissionBase)protocol.getProtocolSubmission(), "Protocol Review cancelled - protocol has been deferred.");
        ProtocolDocument newDocument = (ProtocolDocument)this.getVersionedDocument((ProtocolBase)protocol);
        ProtocolAction assignToAgendaProtocolAction = (ProtocolAction)this.getProtocolAssignToAgendaService().getAssignedToAgendaProtocolAction((ProtocolBase)newDocument.getProtocol());
        if (assignToAgendaProtocolAction != null) {
            newDocument.getProtocol().getProtocolActions().remove(assignToAgendaProtocolAction);
            this.getBusinessObjectService().delete((PersistableBusinessObject)assignToAgendaProtocolAction);
        }
        newDocument.getProtocol().refreshReferenceObject("protocolStatus");
        this.getDocumentService().saveDocument((Document)newDocument);
        return newDocument;
    }

    protected ProtocolDocument getReturnedVersionedDocument(ProtocolBase protocol) throws Exception {
        this.getDocumentService().cancelDocument((Document)protocol.getProtocolDocument(), "Protocol document cancelled - protocol has been returned for revisions.");
        this.getProtocolOnlineReviewService().finalizeOnlineReviews(protocol.getProtocolSubmission(), "Protocol Review finalized - protocol has been returned for revisions.");
        return (ProtocolDocument)this.getVersionedDocument(protocol);
    }

    protected String getProtocolPendingInProgressStatusCodeHook() {
        return "100";
    }

    protected String getProtocolSubmissionStatusRejectedInRoutingCodeHook() {
        return "405";
    }

    protected ProtocolActionBase getNewDisapprovedInRoutingProtocolActionInstanceHook(ProtocolBase protocol) {
        return new ProtocolAction((Protocol)protocol, null, "404");
    }

    protected String getDisapprovedProtocolStatusCodeHook() {
        return "306";
    }

    protected String getRecallProtocolActionTypeCodeHook() {
        return "405";
    }
}

