/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.history;

import java.util.Date;
import org.kuali.kra.irb.actions.history.ProtocolHistoryFilterDatesEvent;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;

public class ProtocolHistoryFilterDatesRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<ProtocolHistoryFilterDatesEvent> {
    private static final String BEGINNING_ON_DATE = "Beginning On Date";
    private static final String ENDING_ON_DATE = "Ending On Date";

    public boolean processRules(ProtocolHistoryFilterDatesEvent event) {
        boolean isValid = true;
        Date startDate = event.getStartDate();
        Date endDate = event.getEndDate();
        if (startDate == null) {
            this.reportError("actionHelper.filteredHistoryStartDate", "error.required", new String[]{BEGINNING_ON_DATE});
            isValid = false;
        }
        if (endDate == null) {
            this.reportError("actionHelper.filteredHistoryEndDate", "error.required", new String[]{ENDING_ON_DATE});
            isValid = false;
        }
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            this.reportError("actionHelper.filteredHistoryStartDate", "error.start.date.after.end.date", new String[]{BEGINNING_ON_DATE, ENDING_ON_DATE});
            isValid = false;
        }
        return isValid;
    }
}

