/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.modifysubmission;

import java.io.Serializable;
import java.util.List;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.actions.ActionHelper;
import org.kuali.kra.irb.actions.ProtocolActionBean;
import org.kuali.kra.irb.actions.submit.CheckListService;
import org.kuali.kra.irb.actions.submit.ExemptStudiesCheckListItem;
import org.kuali.kra.irb.actions.submit.ExpeditedReviewCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolExpeditedReviewCheckListItem;

public class ProtocolModifySubmissionBean
extends ProtocolActionBean
implements Serializable {
    private static final long serialVersionUID = 6809400244968716321L;
    private String submissionTypeCode = "";
    private String protocolReviewTypeCode = "";
    private String submissionQualifierTypeCode = "";
    private boolean billable;
    private List<ExpeditedReviewCheckListItem> expeditedReviewCheckList;
    private List<ExemptStudiesCheckListItem> exemptStudiesCheckList;
    private int checkListItemDescriptionIndex = 0;
    private String selectedProtocolReviewTypeCode = null;

    public ProtocolModifySubmissionBean(ActionHelper actionHelper) {
        super(actionHelper);
        this.submissionTypeCode = actionHelper.getProtocol().getProtocolSubmission().getProtocolSubmissionType().getSubmissionTypeCode();
        this.submissionQualifierTypeCode = actionHelper.getProtocol().getProtocolSubmission().getSubmissionTypeQualifierCode();
        this.protocolReviewTypeCode = actionHelper.getProtocol().getProtocolSubmission().getProtocolReviewTypeCode();
        this.billable = actionHelper.getProtocol().getProtocolSubmission().isBillable();
        this.expeditedReviewCheckList = this.getCheckListService().getExpeditedReviewCheckList();
        for (ExpeditedReviewCheckListItem displayItem : this.expeditedReviewCheckList) {
            for (ProtocolExpeditedReviewCheckListItem databaseItem : actionHelper.getProtocol().getProtocolSubmission().getExpeditedReviewCheckList()) {
                if (!displayItem.getExpeditedReviewCheckListCode().equals(databaseItem.getExpeditedReviewCheckListCode())) continue;
                displayItem.setChecked(true);
            }
        }
        this.exemptStudiesCheckList = this.getCheckListService().getExemptStudiesCheckList();
        for (ExpeditedReviewCheckListItem displayItem : this.exemptStudiesCheckList) {
            for (ProtocolExpeditedReviewCheckListItem databaseItem : actionHelper.getProtocol().getProtocolSubmission().getExemptStudiesCheckList()) {
                if (!displayItem.getExemptStudiesCheckListCode().equals(databaseItem.getExemptStudiesCheckListCode())) continue;
                displayItem.setChecked(true);
            }
        }
    }

    public void prepareView() {
    }

    public String getSubmissionTypeCode() {
        return this.submissionTypeCode;
    }

    public void setSubmissionTypeCode(String submissionTypeCode) {
        this.submissionTypeCode = submissionTypeCode;
    }

    public String getProtocolReviewTypeCode() {
        return this.protocolReviewTypeCode;
    }

    public void setProtocolReviewTypeCode(String protocolReviewTypeCode) {
        this.protocolReviewTypeCode = protocolReviewTypeCode;
    }

    public String getSubmissionQualifierTypeCode() {
        return this.submissionQualifierTypeCode;
    }

    public void setSubmissionQualifierTypeCode(String submissionQualifierTypeCode) {
        this.submissionQualifierTypeCode = submissionQualifierTypeCode;
    }

    public void setExpeditedReviewCheckList(List<ExpeditedReviewCheckListItem> checkList) {
        this.expeditedReviewCheckList = checkList;
    }

    public List<ExpeditedReviewCheckListItem> getExpeditedReviewCheckList() {
        return this.expeditedReviewCheckList;
    }

    public void setExemptStudiesCheckList(List<ExemptStudiesCheckListItem> checkList) {
        this.exemptStudiesCheckList = checkList;
    }

    public List<ExemptStudiesCheckListItem> getExemptStudiesCheckList() {
        return this.exemptStudiesCheckList;
    }

    public boolean isBillable() {
        return this.billable;
    }

    public void setBillable(boolean billable) {
        this.billable = billable;
    }

    public void setCheckListItemDescriptionInfo(String protocolReviewTypeCode, int index) {
        this.selectedProtocolReviewTypeCode = protocolReviewTypeCode;
        this.checkListItemDescriptionIndex = index;
    }

    public String getCheckListItemDescription() {
        String retVal = "";
        if ("2".equals(this.selectedProtocolReviewTypeCode)) {
            retVal = ((ExpeditedReviewCheckListItem)this.getExpeditedReviewCheckList().get(this.checkListItemDescriptionIndex)).getDescription();
        } else if ("3".equals(this.selectedProtocolReviewTypeCode)) {
            retVal = ((ExemptStudiesCheckListItem)this.getExemptStudiesCheckList().get(this.checkListItemDescriptionIndex)).getDescription();
        }
        return retVal;
    }

    private CheckListService getCheckListService() {
        return (CheckListService)KraServiceLocator.getService(CheckListService.class);
    }
}

