/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.modifysubmission;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.modifysubmission.ExecuteProtocolModifySubmissionRule;
import org.kuali.kra.irb.actions.modifysubmission.ProtocolModifySubmissionBean;
import org.kuali.kra.irb.actions.submit.ExemptStudiesCheckListItem;
import org.kuali.kra.irb.actions.submit.ExpeditedReviewCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolReviewType;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionQualifierType;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionType;
import org.kuali.kra.irb.actions.submit.ValidProtoSubRevType;
import org.kuali.kra.irb.actions.submit.ValidProtoSubTypeQual;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolModifySubmissionRule
extends ResearchDocumentRuleBase
implements ExecuteProtocolModifySubmissionRule {
    public boolean processModifySubmissionRule(ProtocolDocument document, ProtocolModifySubmissionBean actionBean) {
        boolean valid = true;
        Object errorParameters = null;
        if (StringUtils.isBlank((String)actionBean.getProtocolReviewTypeCode())) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("actionHelper.protocolModifySubmissionBean.protocolReviewTypeCode", "error.protocol.reviewTypeCode.notFound", new String[]{errorParameters});
            valid = false;
        } else if ("3".equals(actionBean.getProtocolReviewTypeCode()) && !this.verifyExemptChecklist(actionBean)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("actionHelper.protocolModifySubmissionBean.exemptStudiesCheckList[0].checked", "error.protocol.submission.exemptCheckbox", new String[]{errorParameters});
            valid = false;
        } else if ("2".equals(actionBean.getProtocolReviewTypeCode()) && !this.verifyExpediteChecklist(actionBean)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("actionHelper.protocolModifySubmissionBean.expeditedReviewCheckList[0].checked", "error.protocol.submission.expeditedCheckbox", new String[]{errorParameters});
            valid = false;
        }
        if (StringUtils.isBlank((String)actionBean.getSubmissionTypeCode())) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("actionHelper.protocolModifySubmissionBean.submissionTypeCode", "error.protocol.submissionTypeCode.notFound", new String[]{errorParameters});
            valid = false;
        }
        if (StringUtils.isNotBlank((String)actionBean.getSubmissionTypeCode())) {
            valid &= this.isValidSubmTypeQual(actionBean);
            if (StringUtils.isNotBlank((String)actionBean.getProtocolReviewTypeCode())) {
                valid &= this.isValidSubmReviewType(actionBean);
            }
        }
        return valid;
    }

    private boolean verifyExemptChecklist(ProtocolModifySubmissionBean actionBean) {
        for (ExemptStudiesCheckListItem item : actionBean.getExemptStudiesCheckList()) {
            if (!item.getChecked()) continue;
            return true;
        }
        return false;
    }

    private boolean verifyExpediteChecklist(ProtocolModifySubmissionBean actionBean) {
        for (ExpeditedReviewCheckListItem item : actionBean.getExpeditedReviewCheckList()) {
            if (!item.getChecked()) continue;
            return true;
        }
        return false;
    }

    private boolean isValidSubmReviewType(ProtocolModifySubmissionBean submitAction) {
        boolean valid = true;
        if (StringUtils.isNotBlank((String)submitAction.getSubmissionTypeCode()) && StringUtils.isNotBlank((String)submitAction.getProtocolReviewTypeCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("submissionTypeCode", submitAction.getSubmissionTypeCode());
            List validProtoSubRevTypes = (List)this.getBusinessObjectService().findMatching(ValidProtoSubRevType.class, fieldValues);
            if (!validProtoSubRevTypes.isEmpty()) {
                ArrayList<String> reviewTypes = new ArrayList<String>();
                for (ValidProtoSubRevType validProtoSubRevType : validProtoSubRevTypes) {
                    reviewTypes.add(validProtoSubRevType.getProtocolReviewTypeCode());
                }
                if (!reviewTypes.contains(submitAction.getProtocolReviewTypeCode())) {
                    GlobalVariables.getMessageMap().putError("actionHelper.protocolModifySubmissionBean.protocolReviewTypeCode", "invalid.submreviewtype", new String[]{((ProtocolSubmissionType)this.getBo(ProtocolSubmissionType.class, "submissionTypeCode", submitAction.getSubmissionTypeCode())).getDescription(), ((ProtocolReviewType)this.getBo(ProtocolReviewType.class, "reviewTypeCode", submitAction.getProtocolReviewTypeCode())).getDescription()});
                    valid = false;
                }
            }
        }
        return valid;
    }

    private boolean isValidSubmTypeQual(ProtocolModifySubmissionBean submitAction) {
        boolean valid = true;
        if (StringUtils.isNotBlank((String)submitAction.getSubmissionTypeCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("submissionTypeCode", submitAction.getSubmissionTypeCode());
            List validProtoSubTypeQuals = (List)this.getBusinessObjectService().findMatching(ValidProtoSubTypeQual.class, fieldValues);
            if (!validProtoSubTypeQuals.isEmpty()) {
                ArrayList<String> typeQuals = new ArrayList<String>();
                for (ValidProtoSubTypeQual validProtoSubTypeQual : validProtoSubTypeQuals) {
                    typeQuals.add(validProtoSubTypeQual.getSubmissionTypeQualCode());
                }
                if (StringUtils.isBlank((String)submitAction.getSubmissionQualifierTypeCode()) || !typeQuals.contains(submitAction.getSubmissionQualifierTypeCode())) {
                    String desc = "";
                    ProtocolSubmissionQualifierType typeQual = (ProtocolSubmissionQualifierType)this.getBo(ProtocolSubmissionQualifierType.class, "submissionQualifierTypeCode", submitAction.getSubmissionQualifierTypeCode());
                    if (typeQual != null) {
                        desc = typeQual.getDescription();
                    }
                    GlobalVariables.getMessageMap().putError("actionHelper.protocolModifySubmissionBean.submissionQualifierTypeCode", "invalid.submtypequal", new String[]{((ProtocolSubmissionType)this.getBo(ProtocolSubmissionType.class, "submissionTypeCode", submitAction.getSubmissionTypeCode())).getDescription(), desc});
                    valid = false;
                }
            }
        }
        return valid;
    }

    private BusinessObject getBo(Class<? extends BusinessObject> boType, String propertyName, String keyField) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(propertyName, keyField);
        List results = (List)this.getBusinessObjectService().findMatching(boType, fieldValues);
        if (results.isEmpty()) {
            return null;
        }
        return (BusinessObject)results.get(0);
    }
}

