/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.notification;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.actions.notification.ProtocolNotificationTemplate;
import org.kuali.kra.irb.actions.notification.ProtocolNotificationTemplateAuthorizationService;
import org.kuali.kra.irb.actions.notification.ProtocolNotificationTemplateForm;
import org.kuali.kra.irb.actions.notification.ProtocolNotificationTemplateRule;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.action.KualiDocumentActionBase;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolNotificationTemplateAction
extends KualiDocumentActionBase {
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.getProtocolNotificationTemplateAuthorizationService().hasPermission("Modify Notification Template")) {
            ((ProtocolNotificationTemplateForm)form).setReadOnly(false);
        } else if (this.getProtocolNotificationTemplateAuthorizationService().hasPermission("View Notification Template")) {
            ((ProtocolNotificationTemplateForm)form).setReadOnly(true);
        } else {
            throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), this.findMethodToCall(form, request), this.getClass().getSimpleName());
        }
        if (StringUtils.equals((String)request.getParameter("init"), (String)"true") || StringUtils.isNotBlank((String)((String)request.getAttribute("methodToCallAttribute"))) && ((String)request.getAttribute("methodToCallAttribute")).startsWith("methodToCall.reload.")) {
            ProtocolNotificationTemplateForm templateForm = (ProtocolNotificationTemplateForm)form;
            templateForm.setNotificationTemplates(templateForm.initNotificationTemplates());
        }
        return super.execute(mapping, form, request, response);
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KNSGlobalVariables.getMessageList().add("message.document.reloaded", new String[0]);
        return mapping.findForward("basic");
    }

    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = mapping.findForward("portal");
        if (this.getProtocolNotificationTemplateAuthorizationService().hasPermission("Modify Correspondence Template")) {
            if (!StringUtils.equals((String)request.getParameter("questionIndex"), (String)"DocSaveBeforeClose")) {
                actionForward = this.performQuestionWithoutInput(mapping, form, request, response, "DocSaveBeforeClose", this.getKualiConfigurationService().getPropertyValueAsString("document.question.saveBeforeClose.text"), "confirmationQuestion", "close", "");
            } else if (StringUtils.equals((String)request.getParameter("buttonClicked"), (String)"0")) {
                ProtocolNotificationTemplateForm notificationTemplateForm = (ProtocolNotificationTemplateForm)form;
                this.getBusinessObjectService().save(notificationTemplateForm.getNotificationTemplates());
                actionForward = mapping.findForward("portal");
            }
        }
        return actionForward;
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.getProtocolNotificationTemplateAuthorizationService().hasPermission("Modify Correspondence Template")) {
            throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), this.findMethodToCall(form, request), this.getClass().getSimpleName());
        }
        ProtocolNotificationTemplateForm notificationTemplateForm = (ProtocolNotificationTemplateForm)form;
        KNSGlobalVariables.getMessageList().add("message.saved", new String[0]);
        this.getBusinessObjectService().save(notificationTemplateForm.getNotificationTemplates());
        return mapping.findForward("basic");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = StringUtils.equals((String)request.getParameter("questionIndex"), (String)"DocCancel") ? (StringUtils.equals((String)request.getParameter("buttonClicked"), (String)"0") ? mapping.findForward("portal") : mapping.findForward("basic")) : this.performQuestionWithoutInput(mapping, form, request, response, "DocCancel", this.getKualiConfigurationService().getPropertyValueAsString("document.question.cancel.text"), "confirmationQuestion", "cancel", "");
        return actionForward;
    }

    public ActionForward replaceNotificationTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int templateIndex = this.getSelectedNotificationTemplate(request);
        ProtocolNotificationTemplateForm notificationTemplateForm = (ProtocolNotificationTemplateForm)form;
        ProtocolNotificationTemplate notificationTemplate = (ProtocolNotificationTemplate)notificationTemplateForm.getNotificationTemplates().get(templateIndex);
        boolean rulePassed = new ProtocolNotificationTemplateRule().processReplaceProtocolNotificationTemplateRules(notificationTemplate, templateIndex);
        if (rulePassed) {
            notificationTemplate.setFileName(notificationTemplate.getTemplateFile().getFileName());
            notificationTemplate.setNotificationTemplate(notificationTemplate.getTemplateFile().getFileData());
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewNotificationTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int templateIndex = this.getSelectedNotificationTemplate(request);
        ProtocolNotificationTemplateForm notificationTemplateForm = (ProtocolNotificationTemplateForm)form;
        ProtocolNotificationTemplate notificationTemplate = (ProtocolNotificationTemplate)notificationTemplateForm.getNotificationTemplates().get(templateIndex);
        this.streamToResponse(notificationTemplate.getNotificationTemplate(), notificationTemplate.getFileName(), "text/xml", response);
        return RESPONSE_ALREADY_HANDLED;
    }

    private int getSelectedNotificationTemplate(HttpServletRequest request) {
        int index = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            index = Integer.parseInt(StringUtils.substringBetween((String)parameterName, (String)"notificationTemplates[", (String)"]"));
        }
        return index;
    }

    private ProtocolNotificationTemplateAuthorizationService getProtocolNotificationTemplateAuthorizationService() {
        return (ProtocolNotificationTemplateAuthorizationService)KraServiceLocator.getService(ProtocolNotificationTemplateAuthorizationService.class);
    }
}

