/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.notification;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.actions.ProtocolActionType;
import org.kuali.kra.irb.actions.notification.ProtocolNotificationTemplate;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProtocolNotificationTemplateForm
extends KualiForm {
    private static final long serialVersionUID = 6043169784839779473L;
    private List<ProtocolNotificationTemplate> notificationTemplates;
    private boolean readOnly = true;

    public ProtocolNotificationTemplateForm() {
        this.setNotificationTemplates(this.initNotificationTemplates());
    }

    private BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    public List<ProtocolNotificationTemplate> initNotificationTemplates() {
        List templates = (List)this.getBusinessObjectService().findAll(ProtocolNotificationTemplate.class);
        if (templates.isEmpty()) {
            templates = this.getDefaultTemplates();
        }
        return templates;
    }

    private List<ProtocolNotificationTemplate> getDefaultTemplates() {
        ArrayList<ProtocolNotificationTemplate> templates = new ArrayList<ProtocolNotificationTemplate>();
        templates.add(this.getTemplate("303", "ProtocolWithdrawNotification.xsl"));
        templates.add(this.getTemplate("116", "NotifyIrbNotification.xsl"));
        templates.add(this.getTemplate("105", "RequestToCloseNotification.xsl"));
        templates.add(this.getTemplate("106", "RequestToSuspensionNotification.xsl"));
        templates.add(this.getTemplate("115", "OpenEnrollmentNotification.xsl"));
        templates.add(this.getTemplate("114", "DataAnalysisNotification.xsl"));
        templates.add(this.getTemplate("108", "CloseEnrollmentNotification.xsl"));
        templates.add(this.getTemplate("209", "IrbAcknowledgementNotification.xsl"));
        templates.add(this.getTemplate("119", "AbandonProtocolNotification.xsl"));
        templates.add(this.getTemplate("200", "AssignToAgendaReviewerNotification.xsl"));
        templates.add(this.getTemplate("901", "AssignReviewerNotification.xsl"));
        templates.add(this.getTemplate("902", "ReviewCompleteNotification.xsl"));
        templates.add(this.getTemplate("111", "BatchCorrespondenceNotification.xsl"));
        templates.add(this.getTemplate("903", "RejectReviewNotification.xsl"));
        templates.add(this.getTemplate("904", "FundingSourceNotification.xsl"));
        return templates;
    }

    private ProtocolNotificationTemplate getTemplate(String actionTypeCode, String fileName) {
        ProtocolActionType actionType;
        ProtocolNotificationTemplate template = new ProtocolNotificationTemplate();
        template.setActionTypeCode(actionTypeCode);
        template.setFileName(fileName);
        template.setNotificationTemplate(this.getFileContent("/org/kuali/kra/irb/notification/stylesheet/" + fileName));
        template.refreshReferenceObject("protocolActionType");
        if (actionTypeCode.equals("901")) {
            actionType = new ProtocolActionType();
            actionType.setProtocolActionTypeCode(actionTypeCode);
            actionType.setDescription("Assign Reviewer");
            template.setProtocolActionType(actionType);
        }
        if (actionTypeCode.equals("902")) {
            actionType = new ProtocolActionType();
            actionType.setProtocolActionTypeCode(actionTypeCode);
            actionType.setDescription("Review Complete");
            template.setProtocolActionType(actionType);
        }
        return template;
    }

    private byte[] getFileContent(String filePath) {
        try {
            int readNum;
            InputStream inStream = this.getClass().getResourceAsStream(filePath);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((readNum = inStream.read(buf)) != -1) {
                bos.write(buf, 0, readNum);
            }
            return bos.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public List<ProtocolNotificationTemplate> getNotificationTemplates() {
        return this.notificationTemplates;
    }

    public void setNotificationTemplates(List<ProtocolNotificationTemplate> notificationTemplates) {
        this.notificationTemplates = notificationTemplates;
    }
}

