/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.print;

import java.sql.Date;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.bo.CustomAttributeDocValue;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.common.permissions.web.bean.AssignedRole;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewModule;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewal;
import org.kuali.kra.irb.actions.notification.ProtocolNotificationTemplateAuthorizationService;
import org.kuali.kra.irb.actions.print.ProtocolPrintPermissionUtils;
import org.kuali.kra.irb.actions.risklevel.ProtocolRiskLevel;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentProtocol;
import org.kuali.kra.irb.noteattachment.ProtocolNotepad;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.personnel.ProtocolUnit;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSource;
import org.kuali.kra.irb.protocol.location.ProtocolLocation;
import org.kuali.kra.irb.protocol.participant.ProtocolParticipant;
import org.kuali.kra.irb.protocol.reference.ProtocolReference;
import org.kuali.kra.irb.protocol.research.ProtocolResearchArea;
import org.kuali.kra.irb.specialreview.ProtocolSpecialReview;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.print.ProtocolSummaryPrintOptions;
import org.kuali.kra.protocol.actions.print.ProtocolSummaryXmlStreamBase;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.w3.x2001.protocolSummarySchema.ProtoAmendRenewalType;
import org.w3.x2001.protocolSummarySchema.ProtocolActionsType;
import org.w3.x2001.protocolSummarySchema.ProtocolCorrespondentType;
import org.w3.x2001.protocolSummarySchema.ProtocolDetailsType;
import org.w3.x2001.protocolSummarySchema.ProtocolDocumentType;
import org.w3.x2001.protocolSummarySchema.ProtocolDocumentsType;
import org.w3.x2001.protocolSummarySchema.ProtocolFundingSourceType;
import org.w3.x2001.protocolSummarySchema.ProtocolInvestigatorType;
import org.w3.x2001.protocolSummarySchema.ProtocolKeyPersonsType;
import org.w3.x2001.protocolSummarySchema.ProtocolLocationType;
import org.w3.x2001.protocolSummarySchema.ProtocolModulesType;
import org.w3.x2001.protocolSummarySchema.ProtocolNotesType;
import org.w3.x2001.protocolSummarySchema.ProtocolOtherDataType;
import org.w3.x2001.protocolSummarySchema.ProtocolOtherDocumentsType;
import org.w3.x2001.protocolSummarySchema.ProtocolReferencesType;
import org.w3.x2001.protocolSummarySchema.ProtocolResearchAreasType;
import org.w3.x2001.protocolSummarySchema.ProtocolRiskLevelsType;
import org.w3.x2001.protocolSummarySchema.ProtocolRolesType;
import org.w3.x2001.protocolSummarySchema.ProtocolSpecialReviewType;
import org.w3.x2001.protocolSummarySchema.ProtocolSubjectsType;
import org.w3.x2001.protocolSummarySchema.ProtocolSummaryDocument;
import org.w3.x2001.protocolSummarySchema.ProtocolUnitsType;
import org.w3.x2001.protocolSummarySchema.ProtocolUserRolesType;
import org.w3.x2001.protocolSummarySchema.SchoolInfoType;

public class ProtocolSummaryXmlStream
extends ProtocolSummaryXmlStreamBase {
    private static final String OTHER = "9";
    private static final String SCHOOL_NAME = "SCHOOL_NAME";
    private static final String SCHOOL_ACRONYM = "SCHOOL_ACRONYM";
    private SponsorService sponsorService;
    private UnitService unitService;
    private BusinessObjectService businessObjectService;
    private InstitutionalProposalService institutionalProposalService;
    private AwardService awardService;

    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        Protocol protocol = (Protocol)printableBusinessObject;
        ProtocolSummaryDocument protocolSummaryDocument = ProtocolSummaryDocument.Factory.newInstance();
        protocolSummaryDocument.setProtocolSummary(this.getProtocolSummary((KraPersistableBusinessObjectBase)protocol, reportParameters));
        HashMap<String, XmlObject> map = new HashMap<String, XmlObject>();
        map.put("PrtocolSummary", (XmlObject)protocolSummaryDocument);
        return map;
    }

    private String getOptionString(boolean printOption) {
        return printOption ? "1" : "0";
    }

    public ProtocolSummaryDocument.ProtocolSummary getProtocolSummary(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> htData) {
        Protocol protocol = (Protocol)printableBusinessObject;
        ProtocolSummaryDocument.ProtocolSummary protocolSummary = ProtocolSummaryDocument.ProtocolSummary.Factory.newInstance();
        ProtocolSummaryDocument.ProtocolSummary.PrintRequirement printRequirementType = protocolSummary.addNewPrintRequirement();
        protocolSummary.setPrintRequirement(printRequirementType);
        if (htData != null) {
            ProtocolSummaryPrintOptions summaryOptions = (ProtocolSummaryPrintOptions)htData.get(ProtocolSummaryPrintOptions.class);
            printRequirementType.setActionsRequired(this.getOptionString(summaryOptions.isActions()));
            printRequirementType.setAmendRenewModulesRequired(this.getOptionString(summaryOptions.isAmmendmentRenewalSummary()));
            printRequirementType.setAmendRenewSRequired(this.getOptionString(summaryOptions.isAmendmentRenewalHistory()));
            printRequirementType.setDocumentsRequired(this.getOptionString(summaryOptions.isDocuments()));
            printRequirementType.setResearchAreasRequired(this.getOptionString(summaryOptions.isAreaOfResearch()));
            printRequirementType.setCorrespondentsRequired(this.getOptionString(summaryOptions.isCorrespondents()));
            printRequirementType.setFundingSourcesRequired(this.getOptionString(summaryOptions.isFundingSource()));
            printRequirementType.setInvestigatorsRequired(this.getOptionString(summaryOptions.isInvestigator()));
            printRequirementType.setNotesRequired(this.getOptionString(summaryOptions.isNotes()));
            printRequirementType.setOrganizationRequired(this.getOptionString(summaryOptions.isOrganizaition()));
            printRequirementType.setOtherDataRequired(this.getOptionString(summaryOptions.isOtherData()));
            printRequirementType.setProtocolDetailsRequired(this.getOptionString(summaryOptions.isProtocolDetails()));
            printRequirementType.setReferencesRequired(this.getOptionString(summaryOptions.isReferences()));
            printRequirementType.setRiskLevelsRequired(this.getOptionString(summaryOptions.isRiskLevel()));
            printRequirementType.setUserRolesRequired(this.getOptionString(summaryOptions.isRoles()));
            printRequirementType.setSpecialReviewRequired(this.getOptionString(summaryOptions.isSpecialReview()));
            printRequirementType.setKeyPersonsRequired(this.getOptionString(summaryOptions.isStudyPersonnels()));
            printRequirementType.setSubjectsRequired(this.getOptionString(summaryOptions.isSubjects()));
        }
        printRequirementType.setCurrentDate(this.getDateTimeService().getCurrentCalendar());
        this.setProtocolDetails(protocolSummary, protocol);
        this.setProtocolPersons(protocolSummary, protocol);
        this.setProtocolLocations(protocolSummary, protocol);
        this.setProtocolResearchAreas(protocolSummary, protocol);
        this.setProtocolFundingResources(protocolSummary, protocol);
        this.setProtocolActions(protocolSummary, protocol);
        this.setProtocolVulnerableSubjects(protocolSummary, protocol);
        this.setProtocolSpecialReviewes(protocolSummary, protocol);
        this.setProtocolRiskLevels(protocolSummary, protocol);
        this.setProtocolNotes(protocolSummary, protocol);
        this.setProtocolAmendmentRenewals(protocolSummary, protocol);
        this.setProtocolOtherData(protocolSummary, protocol);
        this.setProtocolReferences(protocolSummary, protocol);
        this.setProtocolUserRoles(protocolSummary, protocol);
        this.setProtocolDocuments(protocolSummary, protocol);
        this.setSchoolInfo(protocolSummary, protocol);
        return protocolSummary;
    }

    private void setSchoolInfo(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protoInfoBean) {
        String schoolName = this.getProposalParameterValue(SCHOOL_NAME);
        String schoolAcronym = this.getProposalParameterValue(SCHOOL_ACRONYM);
        SchoolInfoType schoolInfoType = protocolSummary.addNewSchoolInfo();
        schoolInfoType.setSchoolName(schoolName);
        schoolInfoType.setAcronym(schoolAcronym);
        protocolSummary.setSchoolInfo(schoolInfoType);
    }

    private String getProposalParameterValue(String param) {
        ParameterService parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        return parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, param);
    }

    private void setProtocolDocuments(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        ProtocolDocumentsType protocolDocumentsType = protocolSummary.addNewProtocolDocuments();
        protocolDocumentsType.setProtocolNumber(protocol.getProtocolNumber());
        protocolDocumentsType.setSequenceNumber(protocol.getSequenceNumber().intValue());
        List protocolAttachments = protocol.getActiveAttachmentProtocols();
        for (ProtocolAttachmentProtocol protocolAttachmentProtocol : protocolAttachments) {
            if (protocolAttachmentProtocol.getTypeCode().equals(OTHER)) {
                ProtocolOtherDocumentsType protocolOtherDocumentsType = protocolDocumentsType.addNewProtocolOtherDocuments();
                protocolOtherDocumentsType.setDescription(protocolAttachmentProtocol.getDescription());
                protocolOtherDocumentsType.setDocumentId(protocolAttachmentProtocol.getDocumentId().intValue());
                protocolOtherDocumentsType.setDocumentTypeCode(Integer.parseInt(protocolAttachmentProtocol.getTypeCode()));
                protocolOtherDocumentsType.setDocumentTypeDesc(protocolAttachmentProtocol.getType().getDescription());
                protocolOtherDocumentsType.setFileName(protocolAttachmentProtocol.getFile().getName());
                if (protocolAttachmentProtocol.getUpdateTimestamp() != null) {
                    protocolOtherDocumentsType.setUpdateTimestamp(this.getDateTimeService().getCalendar((java.util.Date)protocolAttachmentProtocol.getUpdateTimestamp()));
                }
                protocolOtherDocumentsType.setUpdateUser(protocolAttachmentProtocol.getUpdateUser());
                continue;
            }
            ProtocolDocumentType protocolDocumentType = protocolDocumentsType.addNewProtocolDocument();
            protocolDocumentType.setDescription(protocolAttachmentProtocol.getDescription());
            protocolDocumentType.setDocumentTypeCode(Integer.parseInt(protocolAttachmentProtocol.getTypeCode()));
            protocolDocumentType.setDocumentTypeGroup(protocolAttachmentProtocol.getType().getDescription());
            if (protocolAttachmentProtocol.getUpdateTimestamp() != null) {
                protocolDocumentType.setUpdateTimestamp(this.getDateTimeService().getCalendar((java.util.Date)protocolAttachmentProtocol.getUpdateTimestamp()));
            }
            protocolDocumentType.setUpdateUser(protocolAttachmentProtocol.getUpdateUser());
        }
    }

    private void setProtocolUserRoles(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        ProtocolPrintPermissionUtils protocolPrintPermissionUtils = new ProtocolPrintPermissionUtils("KC-PROTOCOL");
        protocolPrintPermissionUtils.setProtocol(protocol);
        List assignedRoles = protocolPrintPermissionUtils.getAssignedRoles();
        for (AssignedRole userRolesInfoBean : assignedRoles) {
            ProtocolRolesType protocolRolesType = protocolSummary.addNewProtocolUserRoles();
            protocolRolesType.setRoleName(userRolesInfoBean.getRole().getName());
            List vecUsers = userRolesInfoBean.getUserNames();
            for (String userName : vecUsers) {
                ProtocolUserRolesType protocolUserRolesType = protocolRolesType.addNewUserRoles();
                protocolUserRolesType.setUserName(userName);
                protocolUserRolesType.setPersonName(userName);
            }
        }
    }

    private void setProtocolReferences(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List protocolReferences = protocol.getProtocolReferences();
        for (ProtocolReference protocolReferencesBean : protocolReferences) {
            protocolReferencesBean.refreshNonUpdateableReferences();
            ProtocolReferencesType protocolReferencesType = protocolSummary.addNewProtocolReferences();
            protocolReferencesType.setApplicationDate(this.convertDateToCalendar(protocolReferencesBean.getApplicationDate()));
            protocolReferencesType.setApprovalDate(this.convertDateToCalendar(protocolReferencesBean.getApprovalDate()));
            protocolReferencesType.setComments(protocolReferencesBean.getComments());
            protocolReferencesType.setProtocolNumber(protocolReferencesBean.getProtocolNumber());
            protocolReferencesType.setProtocolReferenceNumber(protocolReferencesBean.getProtocolReferenceNumber().intValue());
            if (protocolReferencesBean.getProtocolReferenceType() != null) {
                protocolReferencesType.setProtocolReferenceTypeCode(protocolReferencesBean.getProtocolReferenceTypeCode().intValue());
                protocolReferencesType.setProtocolReferenceTypeDesc(protocolReferencesBean.getProtocolReferenceType().getDescription());
            }
            protocolReferencesType.setReferenceKey(protocolReferencesBean.getReferenceKey());
            protocolReferencesType.setSequenceNumber(protocolReferencesBean.getSequenceNumber().intValue());
        }
    }

    public void prepareView(ProtocolDocument protocolDocument) {
        Map customAttributeDocuments = protocolDocument.getCustomAttributeDocuments();
        String documentNumber = protocolDocument.getDocumentNumber();
        for (Map.Entry customAttributeDocumentEntry : customAttributeDocuments.entrySet()) {
            CustomAttributeDocument customAttributeDocument = (CustomAttributeDocument)customAttributeDocumentEntry.getValue();
            HashMap<String, Object> primaryKeys = new HashMap<String, Object>();
            primaryKeys.put("documentNumber", documentNumber);
            primaryKeys.put("customAttributeId", customAttributeDocument.getCustomAttributeId());
            CustomAttributeDocValue customAttributeDocValue = (CustomAttributeDocValue)((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findByPrimaryKey(CustomAttributeDocValue.class, primaryKeys);
            if (customAttributeDocValue == null) continue;
            customAttributeDocument.getCustomAttribute().setValue(customAttributeDocValue.getValue());
        }
    }

    private void setProtocolOtherData(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        ProtocolDocument protocolDocument = (ProtocolDocument)protocol.getProtocolDocument();
        this.prepareView(protocolDocument);
        Map customAttributes = protocolDocument.getCustomAttributeDocuments();
        for (String attributeKey : customAttributes.keySet()) {
            CustomAttributeDocument attributeDocument = (CustomAttributeDocument)customAttributes.get(attributeKey);
            String value = attributeDocument.getCustomAttribute().getValue();
            ProtocolOtherDataType protocolOtherDataType = protocolSummary.addNewProtocolOthersData();
            protocolOtherDataType.setColumnName(attributeKey);
            protocolOtherDataType.setColumnValue(value);
            protocolOtherDataType.setProtocolNumber(protocol.getProtocolNumber());
            protocolOtherDataType.setSequenceNumber(protocol.getSequenceNumber().intValue());
            protocolOtherDataType.setUpdateUser(((CustomAttributeDocument)customAttributes.get(attributeKey)).getUpdateUser());
        }
    }

    private void setProtocolAmendmentRenewals(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        String versionNo = "";
        String moduleType = "";
        String amendType = "Amendment";
        String renewalType = "Renewal";
        String protocolNo = null;
        List protocolAmendmentRenewals = protocol.getProtocolAmendRenewals();
        for (ProtocolAmendRenewal protocolAmendRenewalBean : protocolAmendmentRenewals) {
            ProtoAmendRenewalType protoAmendRenewalType = protocolSummary.addNewProtocolAmenRenewal();
            protoAmendRenewalType.setDateCreated(this.convertDateToCalendar(protocolAmendRenewalBean.getDateCreated()));
            protoAmendRenewalType.setProtoAmendRenNumber(protocolAmendRenewalBean.getProtoAmendRenNumber());
            protoAmendRenewalType.setProtocolNumber(protocolAmendRenewalBean.getProtocolNumber());
            protoAmendRenewalType.setSequenceNumber(protocolAmendRenewalBean.getSequenceNumber().intValue());
            protoAmendRenewalType.setSummary(protocolAmendRenewalBean.getSummary());
            protoAmendRenewalType.setUpdateUser(protocolAmendRenewalBean.getUpdateUser());
            protocolNo = protocolAmendRenewalBean.getProtoAmendRenNumber();
            if (protocolNo != null && protocolNo.length() >= 14) {
                versionNo = protocolNo.substring(11);
                if (protocolNo.indexOf(65) != -1) {
                    moduleType = amendType;
                } else if (protocolNo.indexOf(82) != -1) {
                    moduleType = renewalType;
                }
            }
            if (moduleType != null && moduleType.length() > 0) {
                protoAmendRenewalType.setType(moduleType);
            }
            if (versionNo != null && versionNo.length() > 0) {
                protoAmendRenewalType.setVersion(versionNo);
            }
            if (protocolAmendRenewalBean.getProtocol() != null && protocolAmendRenewalBean.getProtocol().getProtocolStatus() != null) {
                protoAmendRenewalType.setProtocolStatusDesc(protocolAmendRenewalBean.getProtocol().getProtocolStatus().getDescription());
                protoAmendRenewalType.setProtocolStatusCode(Integer.parseInt(protocolAmendRenewalBean.getProtocol().getProtocolStatusCode()));
            }
            List vecModuleData = protocolAmendRenewalBean.getModules();
            for (ProtocolAmendRenewModule amendRenewModuleBean : vecModuleData) {
                ProtocolModulesType protocolModulesType = protoAmendRenewalType.addNewProtocolModules();
                if (amendRenewModuleBean.getProtocolModule() != null) {
                    protocolModulesType.setProtocolModuleCode(amendRenewModuleBean.getProtocolModule().getProtocolModuleCode());
                    protocolModulesType.setDescription(amendRenewModuleBean.getProtocolModule().getDescription());
                }
                protocolModulesType.setUpdateUser(amendRenewModuleBean.getUpdateUser());
            }
        }
    }

    private void setProtocolNotes(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List protocolNotes = protocol.getNotepads();
        boolean isProtocolPerson = ((ProtocolActionService)KraServiceLocator.getService(ProtocolActionService.class)).isProtocolPersonnel((ProtocolBase)protocol);
        boolean hasPermission = ((ProtocolNotificationTemplateAuthorizationService)KraServiceLocator.getService(ProtocolNotificationTemplateAuthorizationService.class)).hasPermission("View Restricted Notes");
        for (ProtocolNotepad protocolNotepad : protocolNotes) {
            boolean restrictedView = protocolNotepad.getRestrictedView();
            if ((isProtocolPerson || !hasPermission) && restrictedView) continue;
            ProtocolNotesType protocolNotesType = protocolSummary.addNewProtocolNotes();
            protocolNotesType.setComments(protocolNotepad.getComments());
            protocolNotesType.setEntryNumber(protocolNotepad.getEntryNumber().intValue());
            protocolNotesType.setProtocolNumber(protocolNotepad.getProtocolNumber());
            protocolNotesType.setSequenceNumber(protocolNotepad.getSequenceNumber().intValue());
            protocolNotesType.setUpdateUser(protocolNotepad.getUpdateUser());
            if (protocolNotepad.getUpdateTimestamp() == null) continue;
            protocolNotesType.setUpdateTimestamp(this.getDateTimeService().getCalendar((java.util.Date)protocolNotepad.getUpdateTimestamp()));
        }
    }

    private Calendar convertDateToCalendar(Date date) {
        return date == null ? null : this.getDateTimeService().getCalendar((java.util.Date)date);
    }

    private void setProtocolRiskLevels(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List protocolRiskLevels = protocol.getProtocolRiskLevels();
        for (ProtocolRiskLevel protocolRiskLevelBean : protocolRiskLevels) {
            protocolRiskLevelBean.refreshNonUpdateableReferences();
            ProtocolRiskLevelsType protocolRiskLevelsType = protocolSummary.addNewProtocolRiskLevels();
            protocolRiskLevelsType.setComments(protocolRiskLevelBean.getComments());
            protocolRiskLevelsType.setDateAssigned(this.convertDateToCalendar(protocolRiskLevelBean.getDateAssigned()));
            protocolRiskLevelsType.setDateUpdated(this.convertDateToCalendar(protocolRiskLevelBean.getDateInactivated()));
            protocolRiskLevelsType.setProtocolNumber(protocolRiskLevelBean.getProtocolNumber());
            if (protocolRiskLevelBean.getRiskLevelCode() != null) {
                protocolRiskLevelsType.setRiskLevelCode(Integer.parseInt(protocolRiskLevelBean.getRiskLevelCode()));
                protocolRiskLevelsType.setRiskLevelDesc(protocolRiskLevelBean.getRiskLevel().getDescription());
            }
            protocolRiskLevelsType.setSequenceNumber(protocolRiskLevelBean.getSequenceNumber().intValue());
            protocolRiskLevelsType.setStatus(protocolRiskLevelBean.getStatus());
            protocolRiskLevelsType.setUpdateUser(protocolRiskLevelBean.getUpdateUser());
        }
    }

    private void setProtocolSpecialReviewes(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List protocolSpecialReviews = protocol.getSpecialReviews();
        for (ProtocolSpecialReview specialReview : protocolSpecialReviews) {
            specialReview.refreshNonUpdateableReferences();
            ProtocolSpecialReviewType protocolSpecialReviewType = protocolSummary.addNewProtocolSpecialReview();
            if (specialReview.getApplicationDate() != null) {
                protocolSpecialReviewType.setApplicationDate(this.getDateTimeService().getCalendar((java.util.Date)specialReview.getApplicationDate()));
            }
            if (specialReview.getApprovalDate() != null) {
                protocolSpecialReviewType.setApprovalDate(this.getDateTimeService().getCalendar((java.util.Date)specialReview.getApprovalDate()));
            }
            if (specialReview.getApprovalTypeCode() != null) {
                protocolSpecialReviewType.setApprovalTypeCode(Integer.parseInt(specialReview.getApprovalTypeCode()));
                protocolSpecialReviewType.setApprovalTypeDesc(specialReview.getApprovalType().getDescription());
            }
            protocolSpecialReviewType.setComments(specialReview.getComments());
            protocolSpecialReviewType.setProtocolNumber(specialReview.getProtocolNumber());
            protocolSpecialReviewType.setSequenceNumber(specialReview.getSequenceNumber().intValue());
            protocolSpecialReviewType.setSpRevProtocolNumber(specialReview.getProtocolNumber());
            if (specialReview.getSpecialReviewTypeCode() != null) {
                protocolSpecialReviewType.setSpecialReviewCode(Integer.parseInt(specialReview.getSpecialReviewTypeCode()));
                protocolSpecialReviewType.setSpecialReviewDesc(specialReview.getSpecialReviewType().getDescription());
            }
            protocolSpecialReviewType.setSpecialReviewNumber(specialReview.getSpecialReviewNumber().intValue());
            protocolSpecialReviewType.setUpdateUser(specialReview.getUpdateUser());
        }
    }

    private void setProtocolVulnerableSubjects(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List protocolParticipants = protocol.getProtocolParticipants();
        for (ProtocolParticipant vulnerableSubListsBean : protocolParticipants) {
            ProtocolSubjectsType protocolSubjectsType = protocolSummary.addNewProtocolSubjects();
            protocolSubjectsType.setProtocolNumber(vulnerableSubListsBean.getProtocolNumber());
            protocolSubjectsType.setSequenceNumber(vulnerableSubListsBean.getSequenceNumber().intValue());
            if (vulnerableSubListsBean.getParticipantCount() != null) {
                protocolSubjectsType.setSubjectCount(vulnerableSubListsBean.getParticipantCount().intValue());
            }
            if (vulnerableSubListsBean.getParticipantType() != null) {
                protocolSubjectsType.setVulnerableSubjectTypeCode(Integer.parseInt(vulnerableSubListsBean.getParticipantTypeCode()));
                protocolSubjectsType.setVulnerableSubjectTypeDesc(vulnerableSubListsBean.getParticipantType().getDescription());
            }
            protocolSubjectsType.setUpdateUser(vulnerableSubListsBean.getUpdateUser());
        }
    }

    private void setProtocolActions(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List protocolAction = protocol.getProtocolActions();
        for (ProtocolAction protocolActionsBean : protocolAction) {
            ProtocolActionsType protocolActionsType = protocolSummary.addNewProtocolActions();
            protocolActionsType.setActionId(protocolActionsBean.getActionId().intValue());
            if (protocolActionsBean.getActionDate() != null) {
                protocolActionsType.setActionDate(this.getDateTimeService().getCalendar((java.util.Date)protocolActionsBean.getActionDate()));
            }
            protocolActionsType.setComments(protocolActionsBean.getComments());
            if (protocolActionsBean.getProtocolActionTypeCode() != null) {
                protocolActionsType.setProtocolActionTypeCode(Integer.parseInt(protocolActionsBean.getProtocolActionTypeCode()));
                protocolActionsType.setProtocolActionTypeDesc(protocolActionsBean.getProtocolActionType().getDescription());
            }
            protocolActionsType.setProtocolNumber(protocolActionsBean.getProtocolNumber());
            protocolActionsType.setSequenceNumber(protocolActionsBean.getSequenceNumber().intValue());
            if (protocolActionsBean.getSubmissionNumber() != null) {
                protocolActionsType.setSubmissionNumber(protocolActionsBean.getSubmissionNumber().intValue());
            }
            protocolActionsType.setUpdateUser(protocolActionsBean.getUpdateUser());
            if (protocol.getApprovalDate() == null) continue;
            protocolActionsType.setApprovalDate(this.convertDateToCalendar(protocol.getApprovalDate()));
        }
    }

    private void setProtocolFundingResources(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List protocolFundngSources = protocol.getProtocolFundingSources();
        for (ProtocolFundingSource fundingSourceBean : protocolFundngSources) {
            ProtocolFundingSourceType protocolFundingSourceType = protocolSummary.addNewProtocolFundingSources();
            protocolFundingSourceType.setFundingSource(fundingSourceBean.getFundingSourceNumber());
            protocolFundingSourceType.setFundingSourceTypeCode(Integer.valueOf(fundingSourceBean.getFundingSourceTypeCode()).intValue());
            String title = this.getFundingSourceNameOrTitle(fundingSourceBean);
            if (title != null) {
                protocolFundingSourceType.setTitle(title);
            }
            if (fundingSourceBean.getFundingSourceType() != null) {
                protocolFundingSourceType.setFundingSourceTypeDesc(fundingSourceBean.getFundingSourceType().getDescription());
            }
            protocolFundingSourceType.setProtocolNumber(fundingSourceBean.getProtocolNumber());
            protocolFundingSourceType.setSequenceNumber(fundingSourceBean.getSequenceNumber().intValue());
            protocolFundingSourceType.setUpdateUser(fundingSourceBean.getUpdateUser());
        }
    }

    private String getFundingSourceNameOrTitle(ProtocolFundingSource fundingSourceBean) {
        String title = null;
        String fundingSourceTypeCode = fundingSourceBean.getFundingSourceTypeCode();
        if ("1".equals(fundingSourceTypeCode)) {
            title = this.getSponsorName(fundingSourceBean.getFundingSourceNumber());
        } else if ("2".equals(fundingSourceTypeCode)) {
            title = this.getUnitName(fundingSourceBean.getFundingSourceNumber());
        } else if ("4".equals(fundingSourceTypeCode)) {
            title = this.getDevelopmentProposalTitle(fundingSourceBean.getFundingSourceNumber());
        } else if ("5".equals(fundingSourceTypeCode)) {
            title = this.getInstitutionalProposalTitle(fundingSourceBean.getFundingSourceNumber());
        } else if ("6".equals(fundingSourceTypeCode)) {
            title = this.getAwardTitle(fundingSourceBean.getFundingSourceNumber());
        }
        return title;
    }

    private String getSponsorName(String fundingSourceNumber) {
        return this.getSponsorService().getSponsorName(fundingSourceNumber);
    }

    private String getUnitName(String fundingSourceNumber) {
        return this.getUnitService().getUnitName(fundingSourceNumber);
    }

    private String getDevelopmentProposalTitle(String fundingSourceNumber) {
        DevelopmentProposal developmentProposal = (DevelopmentProposal)this.getBusinessObjectService().findBySinglePrimaryKey(DevelopmentProposal.class, (Object)fundingSourceNumber);
        return developmentProposal == null ? null : developmentProposal.getTitle();
    }

    private String getInstitutionalProposalTitle(String fundingSourceNumber) {
        InstitutionalProposal institutionalProposal = this.getInstitutionalProposalService().getActiveInstitutionalProposalVersion(fundingSourceNumber);
        if (institutionalProposal == null) {
            institutionalProposal = this.getInstitutionalProposalService().getPendingInstitutionalProposalVersion(fundingSourceNumber);
        }
        return institutionalProposal == null ? null : institutionalProposal.getTitle();
    }

    private String getAwardTitle(String fundingSourceNumber) {
        Award award = null;
        List awards = this.getAwardService().findAwardsForAwardNumber(fundingSourceNumber);
        if (!awards.isEmpty()) {
            award = (Award)awards.get(awards.size() - 1);
        }
        return award == null ? null : award.getTitle();
    }

    private void setProtocolResearchAreas(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List vecResearchAreas = protocol.getProtocolResearchAreas();
        for (ProtocolResearchArea reasearchAreasBean : vecResearchAreas) {
            ProtocolResearchAreasType protocolResearchAreasType = protocolSummary.addNewProtocolResearchAreas();
            protocolResearchAreasType.setProtocolNumber(reasearchAreasBean.getProtocolNumber());
            protocolResearchAreasType.setResearchAreaCode(reasearchAreasBean.getResearchAreaCode());
            protocolResearchAreasType.setResearchAreaDesc(reasearchAreasBean.getResearchAreas().getDescription());
            protocolResearchAreasType.setSequenceNumber(reasearchAreasBean.getSequenceNumber().intValue());
            protocolResearchAreasType.setUpdateUser(reasearchAreasBean.getUpdateUser());
        }
    }

    private void setProtocolLocations(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List protocolLocationList = protocol.getProtocolLocations();
        for (ProtocolLocation protocolLocationListBean : protocolLocationList) {
            protocolLocationListBean.refreshNonUpdateableReferences();
            ProtocolLocationType protocolLocationType = protocolSummary.addNewProtocolOrganization();
            protocolLocationType.setOrganizationId(protocolLocationListBean.getOrganizationId());
            if (protocolLocationListBean.getProtocolOrganizationType() != null) {
                protocolLocationType.setProtocolOrgTypeCode(Integer.parseInt(protocolLocationListBean.getProtocolOrganizationTypeCode()));
                protocolLocationType.setProtocolOrgTypeDesc(protocolLocationListBean.getProtocolOrganizationType().getDescription());
            }
            if (protocolLocationListBean.getOrganization() != null) {
                protocolLocationType.setOrgName(protocolLocationListBean.getOrganization().getOrganizationName());
            }
            protocolLocationType.setAddress(this.getAddress(protocolLocationListBean));
            protocolLocationType.setRolodexId(protocolLocationListBean.getRolodexId().intValue());
        }
    }

    private String getAddress(ProtocolLocation protocolLocationListBean) {
        Rolodex address;
        protocolLocationListBean.refreshNonUpdateableReferences();
        StringBuffer strBffr = new StringBuffer();
        if (protocolLocationListBean.getOrganization() != null) {
            strBffr.append(protocolLocationListBean.getOrganization().getOrganizationName());
            strBffr.append(" ");
        }
        if ((address = protocolLocationListBean.getRolodex()) != null) {
            strBffr.append(address.getAddressLine1());
            strBffr.append(" ");
            strBffr.append(address.getAddressLine2());
            strBffr.append(" ");
            strBffr.append(address.getAddressLine3());
            strBffr.append(" ");
            strBffr.append(address.getCity());
            strBffr.append(" ");
            strBffr.append(address.getCounty());
            strBffr.append(" ");
            strBffr.append(address.getState());
            strBffr.append(" ");
            strBffr.append(address.getPostalCode());
            strBffr.append(" ");
            strBffr.append(address.getCountryCode());
            strBffr.append(" ");
        }
        return strBffr.toString();
    }

    private void setProtocolPersons(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        List vecInvestigator = protocol.getProtocolPersons();
        for (ProtocolPerson protocolPerson : vecInvestigator) {
            protocolPerson.refreshNonUpdateableReferences();
            if (protocolPerson.getProtocolPersonRoleId().equals("PI") || protocolPerson.getProtocolPersonRoleId().equals("COI")) {
                ProtocolInvestigatorType protocolInvestigatorType = protocolSummary.addNewProtocolInvestigators();
                protocolInvestigatorType.setPersonId(protocolPerson.getPersonId());
                protocolInvestigatorType.setPersonName(protocolPerson.getPersonName());
                if (protocolPerson.getAffiliationType() != null) {
                    protocolInvestigatorType.setAffiliationTypeCode(protocolPerson.getAffiliationType().getAffiliationTypeCode().intValue());
                    protocolInvestigatorType.setAffiliationTypeDesc(protocolPerson.getAffiliationType().getDescription());
                }
                protocolInvestigatorType.setNonEmployeeFlag(protocolPerson.isNonEmployee() ? "Y" : "N");
                protocolInvestigatorType.setPrincipalInvestigatorFlag(protocolPerson.isPrincipalInvestigator() ? "Y" : "N");
                protocolInvestigatorType.setProtocolNumber(protocolPerson.getProtocolNumber());
                protocolInvestigatorType.setSequenceNumber(protocolPerson.getSequenceNumber().intValue());
                protocolInvestigatorType.setUpdateUser(protocolPerson.getUpdateUser());
                protocolInvestigatorType.setTrainingFlag(protocolPerson.isTrained() ? "Y" : "N");
                List vecInvUnits = protocolPerson.getProtocolUnits();
                for (ProtocolUnit protocolUnit : vecInvUnits) {
                    ProtocolUnitsType protocolUnitsType = protocolInvestigatorType.addNewProtocolUnits();
                    protocolUnitsType.setLeadUnitFlag(protocolUnit.getLeadUnitFlag() ? "Y" : "N");
                    protocolUnitsType.setPersonId(protocolUnit.getPersonId());
                    protocolUnitsType.setUnitNumber(protocolUnit.getUnitNumber());
                    protocolUnitsType.setUnitName(protocolUnit.getUnitName());
                    protocolUnitsType.setProtocolNumber(protocolUnit.getProtocolNumber());
                    protocolUnitsType.setSequenceNumber(protocolUnit.getSequenceNumber().intValue());
                }
                continue;
            }
            if (protocolPerson.getProtocolPersonRoleId().equals("SP")) {
                ProtocolKeyPersonsType protocolKeyPersonsType = protocolSummary.addNewProtocolKeyPersons();
                protocolKeyPersonsType.setPersonId(protocolPerson.getPersonId());
                protocolKeyPersonsType.setPersonName(protocolPerson.getPersonName());
                protocolKeyPersonsType.setAffiliationTypeCode(protocolPerson.getAffiliationType().getAffiliationTypeCode().intValue());
                protocolKeyPersonsType.setNonEmployeeFlag(protocolPerson.isNonEmployee() ? "Y" : "N");
                protocolKeyPersonsType.setProtocolNumber(protocolPerson.getProtocolNumber());
                protocolKeyPersonsType.setSequenceNumber(protocolPerson.getSequenceNumber().intValue());
                protocolKeyPersonsType.setUpdateUser(protocolPerson.getUpdateUser());
                if (protocolPerson.getProtocolPersonRole() != null) {
                    protocolKeyPersonsType.setPersonRole(protocolPerson.getProtocolPersonRole().getDescription());
                }
                protocolKeyPersonsType.setTrainingFlag(protocolPerson.isTrained() ? "Y" : "N");
                protocolKeyPersonsType.setAffiliationTypeCode(protocolPerson.getAffiliationType().getAffiliationTypeCode().intValue());
                if (protocolPerson.getAffiliationType() == null) continue;
                protocolKeyPersonsType.setAffiliationTypeDesc(protocolPerson.getAffiliationType().getDescription());
                continue;
            }
            if (!protocolPerson.getProtocolPersonRoleId().equals("CRC") && !protocolPerson.getProtocolPersonRoleId().equals("CA")) continue;
            ProtocolCorrespondentType protocolCorrespondentType = protocolSummary.addNewProtocolCorrespondents();
            protocolCorrespondentType.setCorrespondentTypeCode(Integer.parseInt(protocolPerson.getProtocolPersonRoleId()));
            protocolCorrespondentType.setCorrespondentTypeDesc(protocolPerson.getProtocolPersonRole().getDescription());
            protocolCorrespondentType.setComments(protocolPerson.getComments());
            protocolCorrespondentType.setNonEmployeeFlag(protocolPerson.isNonEmployee() ? "Y" : "N");
            protocolCorrespondentType.setPersonId(protocolPerson.getPersonId());
            protocolCorrespondentType.setPersonName(protocolPerson.getPersonName());
            protocolCorrespondentType.setProtocolNumber(protocolPerson.getProtocolNumber());
            protocolCorrespondentType.setSequenceNumber(protocolPerson.getSequenceNumber().intValue());
            protocolCorrespondentType.setUpdateUser(protocolPerson.getUpdateUser());
        }
    }

    private void setProtocolDetails(ProtocolSummaryDocument.ProtocolSummary protocolSummary, Protocol protocol) {
        ProtocolDetailsType protocolDetailsType = null;
        if (protocol != null) {
            protocolDetailsType = protocolSummary.addNewProtocolDetails();
            if (protocol.getSubmissionDate() != null) {
                protocolDetailsType.setApplicationDate(this.getDateTimeService().getCalendar((java.util.Date)protocol.getSubmissionDate()));
            }
            if (protocol.getApprovalDate() != null) {
                protocolDetailsType.setApprovalDate(this.getDateTimeService().getCalendar((java.util.Date)protocol.getApprovalDate()));
            }
            if (protocol.getInitialSubmissionDate() != null) {
                protocolDetailsType.setCreateTimestamp(this.getDateTimeService().getCalendar((java.util.Date)protocol.getUpdateTimestamp()));
            }
            protocolDetailsType.setDescription(protocol.getDescription());
            if (protocol.getExpirationDate() != null) {
                protocolDetailsType.setExpirationDate(this.getDateTimeService().getCalendar((java.util.Date)protocol.getExpirationDate()));
            }
            protocolDetailsType.setFdaApplicationNumber(protocol.getFdaApplicationNumber());
            if (protocol.getProtocolSubmission() != null) {
                protocolDetailsType.setIsBillable(protocol.getProtocolSubmission().isBillable() ? "Y" : "N");
            }
            if (protocol.getLastApprovalDate() != null) {
                protocolDetailsType.setLastApprovalDate(this.getDateTimeService().getCalendar((java.util.Date)protocol.getLastApprovalDate()));
            }
            protocolDetailsType.setProtocolNumber(protocol.getProtocolNumber());
            if (protocol.getProtocolStatusCode() != null) {
                protocolDetailsType.setProtocolStatusCode(Integer.parseInt(protocol.getProtocolStatusCode()));
                protocolDetailsType.setProtocolStatusDesc(protocol.getProtocolStatus().getDescription());
            }
            protocolDetailsType.setProtocolStatusDesc(protocol.getProtocolStatus().getDescription());
            if (protocol.getProtocolTypeCode() != null) {
                protocolDetailsType.setProtocolTypeCode(Integer.parseInt(protocol.getProtocolTypeCode()));
                protocolDetailsType.setProtocolTypeDesc(protocol.getProtocolType().getDescription());
            }
            this.setProtocolInvestigator(protocol, protocolDetailsType);
            protocolDetailsType.setReferenceNumber1(protocol.getReferenceNumber1());
            protocolDetailsType.setReferenceNumber2(protocol.getReferenceNumber2());
            protocolDetailsType.setSequenceNumber(protocol.getSequenceNumber().intValue());
            protocolDetailsType.setTitle(protocol.getTitle());
            protocolDetailsType.setUpdateUser(protocol.getUpdateUser());
        }
    }

    private void setProtocolInvestigator(Protocol protocol, ProtocolDetailsType protocolDetailsType) {
        List vecInvestigator = protocol.getProtocolPersons();
        for (ProtocolPerson protocolPerson : vecInvestigator) {
            protocolPerson.refreshNonUpdateableReferences();
            if (!protocolPerson.getProtocolPersonRoleId().equals("PI")) continue;
            protocolDetailsType.setInvestigator(protocolPerson.getPersonName());
        }
    }

    public SponsorService getSponsorService() {
        if (this.sponsorService == null) {
            this.sponsorService = (SponsorService)KraServiceLocator.getService(SponsorService.class);
        }
        return this.sponsorService;
    }

    public void setSponsorService(SponsorService sponsorService) {
        this.sponsorService = sponsorService;
    }

    public UnitService getUnitService() {
        if (this.unitService == null) {
            this.unitService = (UnitService)KraServiceLocator.getService(UnitService.class);
        }
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        if (this.institutionalProposalService == null) {
            this.institutionalProposalService = (InstitutionalProposalService)KraServiceLocator.getService(InstitutionalProposalService.class);
        }
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }

    protected final boolean hasPermission(String userId, Protocol protocol, String permissionName) {
        return ((KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class)).hasPermission(userId, (Permissionable)protocol, permissionName);
    }

    public AwardService getAwardService() {
        if (this.awardService == null) {
            this.awardService = (AwardService)KraServiceLocator.getService(AwardService.class);
        }
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }
}

