/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.common.notification.NotificationRenderer;
import org.kuali.kra.common.notification.bo.KcNotification;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.ProtocolActionType;
import org.kuali.kra.irb.actions.ProtocolSubmissionBuilder;
import org.kuali.kra.irb.actions.request.ProtocolRequestBean;
import org.kuali.kra.irb.actions.request.ProtocolRequestService;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.notification.IRBNotificationContext;
import org.kuali.kra.irb.notification.IRBNotificationRenderer;
import org.kuali.kra.irb.notification.IRBProtocolNotification;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class ProtocolRequestServiceImpl
implements ProtocolRequestService {
    private static final Log LOG = LogFactory.getLog(ProtocolRequestServiceImpl.class);
    private static final String MODULE_ITEM_CODE = "moduleItemCode";
    private static final String MODULE_ITEM_KEY = "moduleItemKey";
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;
    private ProtocolActionService protocolActionService;
    private KcNotificationService kcNotificationService;

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setProtocolActionService(ProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    public void submitRequest(Protocol protocol, ProtocolRequestBean requestBean) throws WorkflowException {
        LOG.info((Object)("submitRequest " + requestBean.getProtocolActionTypeCode() + " " + protocol.getProtocolDocument().getDocumentNumber()));
        String prevSubmissionStatusCode = protocol.getProtocolSubmission().getSubmissionStatusCode();
        ProtocolSubmission submission = this.createProtocolSubmission(protocol, requestBean);
        String submissionTypeCode = submission.getSubmissionTypeCode();
        protocol.setProtocolSubmission((ProtocolSubmissionBase)submission);
        ProtocolAction protocolAction = new ProtocolAction(protocol, submission, requestBean.getProtocolActionTypeCode());
        protocolAction.setComments(requestBean.getReason());
        protocolAction.setProtocol((ProtocolBase)protocol);
        protocolAction.setPrevProtocolStatusCode(protocol.getProtocolStatusCode());
        protocolAction.setPrevSubmissionStatusCode(prevSubmissionStatusCode);
        protocolAction.setSubmissionTypeCode(submissionTypeCode);
        protocol.getProtocolActions().add(protocolAction);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)protocolAction, (ProtocolBase)protocol);
        if (!CollectionUtils.isEmpty((Collection)requestBean.getQuestionnaireHelper().getAnswerHeaders())) {
            this.saveQuestionnaire(requestBean, submission.getSubmissionNumber());
            requestBean.getQuestionnaireHelper().setAnswerHeaders(new ArrayList());
        }
        this.cleanUnreferencedQuestionnaire(protocol.getProtocolNumber());
        this.documentService.saveDocument((Document)protocol.getProtocolDocument());
    }

    private void saveQuestionnaire(ProtocolRequestBean requestBean, Integer submissionNumber) {
        ArrayList<AnswerHeader> saveHeaders = new ArrayList<AnswerHeader>();
        for (AnswerHeader answerHeader : requestBean.getQuestionnaireHelper().getAnswerHeaders()) {
            if (answerHeader.getAnswerHeaderId() == null) continue;
            answerHeader.setModuleSubItemKey(submissionNumber.toString());
            if (answerHeader.getModuleItemKey().matches(".*[A-Z]$")) {
                answerHeader.setModuleItemKey(answerHeader.getModuleItemKey().substring(0, answerHeader.getModuleItemKey().length() - 1));
            }
            saveHeaders.add(answerHeader);
        }
        if (!saveHeaders.isEmpty()) {
            this.businessObjectService.save(saveHeaders);
        }
    }

    private void cleanUnreferencedQuestionnaire(String protocolNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(MODULE_ITEM_CODE, "7");
        fieldValues.put(MODULE_ITEM_KEY, protocolNumber + "T");
        List answerHeaders = (List)this.businessObjectService.findMatching(AnswerHeader.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)answerHeaders)) {
            this.businessObjectService.delete(answerHeaders);
        }
    }

    protected ProtocolSubmission createProtocolSubmission(Protocol protocol, ProtocolRequestBean requestBean) {
        ProtocolSubmissionBuilder submissionBuilder = new ProtocolSubmissionBuilder(protocol, requestBean.getSubmissionTypeCode());
        submissionBuilder.setProtocolReviewTypeCode("1");
        submissionBuilder.setSubmissionStatus("102");
        submissionBuilder.setCommittee(requestBean.getCommitteeId());
        submissionBuilder.setActionAttachments(requestBean.getActionAttachments());
        return submissionBuilder.create();
    }

    protected void sendRequestNotification(Protocol protocol, ProtocolRequestBean requestBean) throws Exception {
        ProtocolActionType protocolActionType = (ProtocolActionType)this.businessObjectService.findBySinglePrimaryKey(ProtocolActionType.class, (Object)requestBean.getProtocolActionTypeCode());
        String protocolActionTypeCode = protocolActionType.getProtocolActionTypeCode();
        String description = protocolActionType.getDescription();
        IRBNotificationRenderer renderer = new IRBNotificationRenderer(protocol);
        IRBNotificationContext context = new IRBNotificationContext(protocol, protocolActionTypeCode, description, (NotificationRenderer)renderer);
        this.kcNotificationService.sendNotificationAndPersist((NotificationContext)context, (KcNotification)new IRBProtocolNotification(), (KraPersistableBusinessObjectBase)protocol);
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setKcNotificationService(KcNotificationService kcNotificationService) {
        this.kcNotificationService = kcNotificationService;
    }
}

