/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.reviewcomments;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.irb.actions.submit.ProtocolReviewer;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReview;
import org.kuali.kra.irb.onlinereview.ProtocolReviewAttachment;
import org.kuali.kra.meeting.CommitteeScheduleMinute;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsServiceImplBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.kra.protocol.onlinereview.ProtocolReviewableBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class ReviewCommentsServiceImpl
extends ReviewCommentsServiceImplBase<ProtocolReviewAttachment>
implements ReviewCommentsService {
    private static final String[] PROTOCOL_SUBMISSION_COMPLETE_STATUSES = new String[]{"203", "204", "202", "201", "206", "210", "213", "205"};

    protected String[] getProtocolSubmissionCompleteStatusCodeArrayHook() {
        return PROTOCOL_SUBMISSION_COMPLETE_STATUSES;
    }

    protected Class<? extends CommitteeScheduleMinuteBase> getCommitteeScheduleMinuteBOClassHook() {
        return CommitteeScheduleMinute.class;
    }

    protected String getAdministratorRoleHook() {
        return "IRB Administrator";
    }

    protected ProtocolSubmissionBase getSubmission(ProtocolBase protocol) {
        ProtocolSubmissionBase protocolSubmission = protocol.getProtocolSubmission();
        if (protocol.getNotifyIrbSubmissionId() != null) {
            for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
                if (!submission.getSubmissionId().equals(protocol.getNotifyIrbSubmissionId())) continue;
                protocolSubmission = submission;
                break;
            }
        }
        return protocolSubmission;
    }

    protected String getDisplayRevNameToActiveCmtMembersHook() {
        return "IRB_DISPLAY_REVIEWER_NAME_TO_ACTIVE_COMMITTEE_MEMBERS";
    }

    protected String getDisplayRevNameToProtocolPersonnelHook() {
        return "IRB_DISPLAY_REVIEWER_NAME_TO_PROTOCOL_PERSONNEL";
    }

    protected String getDisplayRevNameToReviewersHook() {
        return "IRB_DISPLAY_REVIEWER_NAME_TO_REVIEWERS";
    }

    protected Class<? extends ProtocolDocumentBase> getProtocolDocumentBOClassHook() {
        return ProtocolDocument.class;
    }

    protected Class<? extends org.kuali.kra.protocol.actions.submit.ProtocolReviewer> getProtocolReviewClassHook() {
        return ProtocolReviewer.class;
    }

    protected String getNamespaceHook() {
        return "KC-PROTOCOL";
    }

    protected String getAggregatorRoleNameHook() {
        return "Protocol Aggregator";
    }

    protected String getProtocolViewerRoleNameHook() {
        return "Protocol Viewer";
    }

    protected Class<? extends ProtocolOnlineReviewBase> getProtocolOnlineReviewClassHook() {
        return ProtocolOnlineReview.class;
    }

    public void saveReviewAttachments(List<ProtocolReviewAttachment> reviewAttachments, List<ProtocolReviewAttachment> deletedReviewAttachments) {
        for (ProtocolReviewAttachment reviewAttachment : reviewAttachments) {
            boolean doUpdate = true;
            if (!doUpdate) continue;
            reviewAttachment.setPrivateFlag(!reviewAttachment.isProtocolPersonCanView());
            this.businessObjectService.save((PersistableBusinessObject)reviewAttachment);
        }
        if (!deletedReviewAttachments.isEmpty()) {
            this.businessObjectService.delete(deletedReviewAttachments);
        }
    }

    protected Class<ProtocolReviewAttachment> getProtocolReviewAttachmentClassHook() {
        return ProtocolReviewAttachment.class;
    }

    public List<CommitteeScheduleMinuteBase> getReviewerComments(String protocolNumber, int submissionNumber) {
        ArrayList<CommitteeScheduleMinuteBase> reviewComments = new ArrayList<CommitteeScheduleMinuteBase>();
        List protocolSubmissions = this.getProtocolFinderDao().findProtocolSubmissions(protocolNumber, submissionNumber);
        for (ProtocolSubmission protocolSubmission : protocolSubmissions) {
            if (protocolSubmission.getCommitteeScheduleMinutes() == null) continue;
            List committeeScheduleMinutes = protocolSubmission.getCommitteeScheduleMinutes();
            for (CommitteeScheduleMinute minute : committeeScheduleMinutes) {
                String minuteEntryTypeCode = minute.getMinuteEntryTypeCode();
                if (!"3".equals(minuteEntryTypeCode) && !"6".equals(minuteEntryTypeCode) || !this.isCurrentMinuteEntry((CommitteeScheduleMinuteBase)minute)) continue;
                minute.setCommitteeIdFromSubmission(protocolSubmission);
                if (!this.getReviewerCommentsView((ProtocolReviewableBase)minute)) continue;
                reviewComments.add((CommitteeScheduleMinuteBase)minute);
            }
        }
        return reviewComments;
    }

    protected boolean isActiveCommitteeMember(ProtocolReviewableBase minute, String principalId) {
        boolean retVal = false;
        if (minute.getCommitteeSchedule() != null) {
            retVal = super.isActiveCommitteeMember(minute, principalId);
        } else if (minute instanceof CommitteeScheduleMinute) {
            String committeeId = ((CommitteeScheduleMinute)minute).getCommitteeIdFromSubmission();
            retVal = super.isActiveCommitteeMember(committeeId, null, principalId);
        }
        return retVal;
    }
}

