/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.submit;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.drools.brms.FactBean;
import org.kuali.kra.drools.util.DroolsRuleHandler;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.ProtocolSubmissionDoc;
import org.kuali.kra.irb.actions.submit.ProtocolActionMapping;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolActionUpdateMapping;
import org.kuali.kra.irb.actions.submit.ProtocolUndoActionMapping;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.submit.ActionRightMapping;
import org.kuali.kra.protocol.actions.submit.ProtocolActionMappingBase;
import org.kuali.kra.protocol.actions.submit.ProtocolActionServiceImplBase;
import org.kuali.kra.questionnaire.answer.AnswerHeader;

public class ProtocolActionServiceImpl
extends ProtocolActionServiceImplBase
implements ProtocolActionService {
    private static final Log LOG = LogFactory.getLog(ProtocolActionServiceImpl.class);
    private static final int PERMISSIONS_LEADUNIT_RULE = 0;
    private static final int PERMISSIONS_SUBMIT_RULE = 1;
    private static final int PERMISSIONS_COMMITTEEMEMBERS_RULE = 2;
    private static final int PERMISSIONS_SPECIAL_RULE = 3;
    private static final int PERFORMACTION_RULE = 4;
    private static final int UPDATE_RULE = 5;
    private static final int UNDO_UPDATE_RULE = 6;
    private static final String PERFORMACTION_FILE = "org/kuali/kra/irb/drools/rules/canPerformProtocolActionRules.drl";
    private static final String UPDATE_FILE = "org/kuali/kra/irb/drools/rules/updateProtocolRules.drl";
    private static final String KC_PROTOCOL = "KC-PROTOCOL";
    private static final String[] actionCodes = new String[]{"101", "102", "103", "104", "105", "106", "108", "114", "115", "116", "200", "201", "202", "203", "204", "205", "206", "207", "208", "209", "210", "211", "212", "300", "301", "302", "303", "304", "305", "306"};

    public String getPerformActionFileNameHook() {
        return PERFORMACTION_FILE;
    }

    protected boolean hasPermissionLeadUnit(String actionTypeCode, ProtocolBase protocol, ActionRightMapping rightMapper) {
        rightMapper.setActionTypeCode(actionTypeCode);
        ((DroolsRuleHandler)this.rulesList.get(0)).executeRules((FactBean)rightMapper);
        return rightMapper.isAllowed() ? this.unitAuthorizationService.hasPermission(this.getUserIdentifier(), protocol.getLeadUnitNumber(), KC_PROTOCOL, "Modify Any Protocol") : false;
    }

    protected boolean hasPermissionToSubmit(String actionTypeCode, ProtocolBase protocol, ActionRightMapping rightMapper) {
        rightMapper.setActionTypeCode(actionTypeCode);
        ((DroolsRuleHandler)this.rulesList.get(1)).executeRules((FactBean)rightMapper);
        return rightMapper.isAllowed() ? this.kraAuthorizationService.hasPermission(this.getUserIdentifier(), (Permissionable)protocol, rightMapper.getRightId()) : false;
    }

    protected boolean hasPermissionAsCommitteeMember(String actionTypeCode, ProtocolBase protocol, ActionRightMapping rightMapper) {
        rightMapper.setActionTypeCode(actionTypeCode);
        rightMapper.setCommitteeId(protocol.getProtocolSubmission().getCommitteeId());
        rightMapper.setScheduleId(protocol.getProtocolSubmission().getScheduleId());
        ((DroolsRuleHandler)this.rulesList.get(2)).executeRules((FactBean)rightMapper);
        return rightMapper.isAllowed() ? this.unitAuthorizationService.hasPermission(this.getUserIdentifier(), protocol.getLeadUnitNumber(), KC_PROTOCOL, "Perform IRB Actions on a Protocol") : false;
    }

    protected boolean hasPermissionSpecialCase(String actionTypeCode, String unit, ActionRightMapping rightMapper) {
        rightMapper.setActionTypeCode(actionTypeCode);
        ((DroolsRuleHandler)this.rulesList.get(3)).executeRules((FactBean)rightMapper);
        return rightMapper.isAllowed() ? this.unitAuthorizationService.hasPermission(this.getUserIdentifier(), unit, KC_PROTOCOL, "Perform IRB Actions on a Protocol") : false;
    }

    public void resetProtocolStatus(ProtocolActionBase protocolActionBo, ProtocolBase protocol) {
        ProtocolUndoActionMapping protocolAction = new ProtocolUndoActionMapping(protocolActionBo.getProtocolActionTypeCode(), protocolActionBo.getSubmissionTypeCode(), protocol.getProtocolStatusCode());
        Protocol irbProtocol = (Protocol)protocol;
        protocolAction.setProtocol(irbProtocol);
        protocolAction.setProtocolSubmission(irbProtocol.getProtocolSubmission());
        protocolAction.setProtocolAction((ProtocolAction)protocolActionBo);
        ((DroolsRuleHandler)this.rulesList.get(6)).executeRules((FactBean)protocolAction);
        if (protocolAction.isProtocolSubmissionToBeDeleted()) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("submissionIdFk", protocolActionBo.getProtocolSubmission().getSubmissionId().toString());
            fieldValues.put("protocolNumber", protocol.getProtocolNumber());
            this.businessObjectService.deleteMatching(ProtocolSubmissionDoc.class, fieldValues);
            this.removeQuestionnaireAnswer(protocolActionBo, protocol);
            protocol.getProtocolSubmissions().remove(protocolActionBo.getProtocolSubmission());
            protocol.setProtocolSubmission(null);
        }
    }

    private void removeQuestionnaireAnswer(ProtocolActionBase protocolActionBo, ProtocolBase protocol) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("moduleItemCode", "7");
        fieldValues.put("moduleItemKey", protocol.getProtocolNumber());
        fieldValues.put("moduleSubItemCode", "2");
        fieldValues.put("moduleSubItemKey", protocolActionBo.getProtocolSubmission().getSubmissionNumber().toString());
        List answerHeaders = (List)this.businessObjectService.findMatching(AnswerHeader.class, fieldValues);
        if (!answerHeaders.isEmpty()) {
            this.businessObjectService.delete(answerHeaders);
        }
    }

    protected boolean isAuthorizedtoPerform(String actionTypeCode, Protocol protocol) {
        boolean flag = false;
        ActionRightMapping rightMapper = new ActionRightMapping();
        flag = this.hasPermissionLeadUnit(actionTypeCode, (ProtocolBase)protocol, rightMapper);
        if (!flag) {
            flag = this.hasPermissionToSubmit(actionTypeCode, (ProtocolBase)protocol, rightMapper);
        }
        if (!flag) {
            flag = this.hasPermissionAsCommitteeMember(actionTypeCode, (ProtocolBase)protocol, rightMapper);
        }
        if (!flag) {
            flag = this.hasPermissionSpecialCase(actionTypeCode, "000001", rightMapper);
        }
        return flag;
    }

    protected Log getLOGHook() {
        return LOG;
    }

    protected int getPerformActionRuleIndexHook() {
        return 4;
    }

    protected ProtocolActionMappingBase getNewProtocolActionMappingInstanceHook(String actionTypeCode, String submissionStatusCode, String submissionTypeCode, String protocolReviewTypeCode, String protocolStatusCode, String scheduleId, Integer submissionNumber) {
        return new ProtocolActionMapping(actionTypeCode, submissionStatusCode, submissionTypeCode, protocolReviewTypeCode, protocolStatusCode, scheduleId, submissionNumber);
    }

    protected ProtocolActionUpdateMapping getNewProtocolActionUpdateMappingHook(String actionTypeCode, String submissionTypeCode, String protocolStatusCode, String specialCondition) {
        return new ProtocolActionUpdateMapping(actionTypeCode, submissionTypeCode, protocolStatusCode, specialCondition);
    }

    protected int getUpdateRuleIndexHook() {
        return 5;
    }

    protected String[] getActionCodesArrayHook() {
        return actionCodes;
    }
}

