/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.submit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.kra.irb.actions.IrbActionsKeyValuesBase;
import org.kuali.kra.irb.actions.submit.ProtocolReviewType;
import org.kuali.kra.lookup.keyvalue.PrefixValuesFinder;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolReviewTypeValuesFinder
extends IrbActionsKeyValuesBase {
    private static final String PERMISSION_NAME = "View Active Protocol Review Types";
    private PermissionService permissionService;
    private List<ProtocolReviewType> allReviewTypes = null;

    public List<KeyValue> getKeyValues() {
        List keyValues = this.filterActiveProtocolReviewTypes();
        keyValues.add(0, new ConcreteKeyValue(PrefixValuesFinder.getPrefixKey(), PrefixValuesFinder.getDefaultPrefixValue()));
        return keyValues;
    }

    private List<KeyValue> filterActiveProtocolReviewTypes() {
        ArrayList<KeyValue> filteredKeyValues = new ArrayList<KeyValue>();
        boolean canViewNonGlobalReviewTypes = this.getPermissionService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", PERMISSION_NAME);
        for (ProtocolReviewType item : this.getAllReviewTypes()) {
            if (!item.isGlobalFlag() && !canViewNonGlobalReviewTypes) continue;
            filteredKeyValues.add((KeyValue)new ConcreteKeyValue(item.getReviewTypeCode(), item.getDescription()));
        }
        return filteredKeyValues;
    }

    public List<ProtocolReviewType> getAllReviewTypes() {
        if (this.allReviewTypes == null) {
            this.allReviewTypes = new ArrayList();
            Collection prTypes = this.getKeyValuesService().findAll(ProtocolReviewType.class);
            for (ProtocolReviewType protocolReviewType : prTypes) {
                this.allReviewTypes.add(protocolReviewType);
            }
        }
        return this.allReviewTypes;
    }

    public PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KimApiServiceLocator.getPermissionService();
        }
        return this.permissionService;
    }
}

